/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import bitel.billing.server.contract.bean.ContractManager;
import java.util.GregorianCalendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;

public class ActionGetBillPositionValues
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        int yy = this.getIntParameter("y", 0);
        int mm = this.getIntParameter("m", -1);
        if (this.mid <= 0 || yy <= 0 || mm < 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractDocType contractDocType = new ContractDocTypeManager(this.con, this.mid).getContractDocType(id);
        if (contractDocType == null) {
            return;
        }
        DocType docType = new DocTypeManager(this.con, this.mid).getType(contractDocType.getDocTypeId());
        if (docType == null) {
            return;
        }
        ContractManager contractManager = new ContractManager(this.con);
        String billCids = String.valueOf(contractDocType.getContractId());
        TemplateBill templateBill = new TemplateBill();
        new TemplateBillManager(this.con, this.mid, docType.getDocumentType()).getTemplatePositions(contractManager, templateBill, new GregorianCalendar(yy, mm, 1), contractDocType.getContractId(), billCids, contractDocType, docType, new PositionDao(this.con, this.mid, docType.getDocumentType()).getPositionMap());
        Element billElement = this.createElement(this.rootNode, "bill");
        billElement.setAttribute("cid", String.valueOf(contractDocType.getContractId()));
        billElement.setAttribute("contract", contractManager.getContractById(contractDocType.getContractId()).getTitle());
        for (PositionValue pos : templateBill.getPositionList()) {
            pos.toElement(this.createElement(billElement, "pos"));
        }
        for (TemplateBill subBill : templateBill.getSubBillList()) {
            Element sub = this.createElement(billElement, "sub_bill");
            sub.setAttribute("cid", String.valueOf(subBill.getContractId()));
            sub.setAttribute("contract", subBill.getContractTitle());
            for (PositionValue pos : templateBill.getPositionList()) {
                pos.toElement(this.createElement(sub, "pos"));
            }
        }
    }
}

