/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class PaymentQueueManager {
    private final Connection con;
    private final BGPluginServer plugin;

    public PaymentQueueManager(Connection con) {
        this.con = con;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
    }

    private Result<Payment> _getQueue(String _table, boolean _isPayment, Period period, List<Integer> paychatypes, Page page) throws BGException {
        LocalDate fiscalStart = this.plugin.getSetup().getLocalDate("fiscal.start", null);
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            Object query = "";
            query = (String)query + "SELECT SQL_CALC_FOUND_ROWS log.id, log." + _table + "_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ";
            query = (String)query + "FROM contract_" + _table + " as contract_payment ";
            query = (String)query + "LEFT JOIN contract ON contract_payment.cid=contract.id ";
            query = (String)query + "LEFT JOIN contract_" + _table + "_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ";
            query = (String)query + "LEFT JOIN cashcheck_" + _table + "_log AS log ON contract_payment.id=log." + _table + "_id ";
            query = (String)query + "WHERE ( log.dt IS NULL ) ";
            if (period.getDateFrom() != null) {
                query = (String)query + " AND contract_payment.dt>='" + TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd") + "'";
            }
            if (period.getDateTo() != null) {
                query = (String)query + " AND contract_payment.dt<='" + TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd") + "'";
            }
            if (fiscalStart != null) {
                query = (String)query + " AND contract_payment.dt>='" + DateTimeUtils.format((LocalDate)fiscalStart, (String)"yyyy-MM-dd") + "'";
            }
            query = paychatypes != null && !paychatypes.isEmpty() ? (String)query + " AND contract_payment.pt in (" + Utils.toString(paychatypes) + ")" : (String)query + " AND contract_payment.pt in (-1)";
            query = (String)query + " ORDER BY contract_payment.id DESC";
            query = (String)query + page.sqlLimit();
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, _isPayment);
                result.add(payment);
                PrinterManager.PaymentMapping mapping = _isPayment ? PrinterManager.getPt(payment.getPaymentTypeId()) : PrinterManager.getCh(payment.getPaymentTypeId());
                payment.setPosMapping((String)(mapping != null ? mapping.print.name() + ":" + Utils.toString(mapping.fr) : "?"));
            }
            rs.close();
            st.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public Result<Payment> getPaymentQueue(Period period, List<Integer> paytypes, Page page) throws BGException {
        return this._getQueue("payment", true, period, paytypes, page);
    }

    public Result<Payment> getChargeQueue(Period period, List<Integer> chatypes, Page page) throws BGException {
        return this._getQueue("charge", false, period, chatypes, page);
    }

    private static void loadPaymentFromRS(Payment payment, ResultSet rs, boolean isPayment) throws SQLException {
        payment.setLogId(rs.getInt("log.id"));
        int cpid = rs.getInt("contract_payment.id");
        int lpid = rs.getInt("log_payment_id");
        payment.setPaymentId(cpid > 0 ? cpid : lpid);
        payment.setPaymentTypeId(rs.getInt("pt"));
        payment.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        payment.setContractId(rs.getInt("contract.id"));
        payment.setSumma(rs.getBigDecimal("summa"));
        payment.setUserId(rs.getInt("uid"));
        payment.setComment(rs.getString("comment"));
        payment.setContractTitle(rs.getString("contract_title"));
        payment.setPaymentTypesTitle(rs.getString("contract_payment_types_title"));
        payment.setLogDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("log_dt")));
        payment.setContractComment(rs.getString("contract_comment"));
        payment.setPosId(rs.getInt("log_pos_id"));
        payment.setCheckData(rs.getString("log_check_data"));
        payment.setLastError(rs.getString("log_last_error"));
        try {
            payment.setCheckType(Check.Type.valueOf((String)rs.getString("log_check_type")));
        }
        catch (Exception e) {
            payment.setCheckType(null);
        }
        payment.setPosMapping(rs.getString("log_pos_mapping"));
        payment.setPendingId(rs.getString("log_pending_id"));
        payment.setFiscalData(rs.getString("log_fiscal_data"));
        payment.setIsPayment(isPayment);
    }

    private List<Payment> _getList(String _table, boolean _isPayment, List<Integer> ids) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            String query = "SELECT log.id, log." + _table + "_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title FROM contract_" + _table + " as contract_payment LEFT JOIN contract ON contract_payment.cid=contract.id LEFT JOIN contract_" + _table + "_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id LEFT JOIN cashcheck_" + _table + "_log AS log ON contract_payment.id=log." + _table + "_id WHERE contract_payment.id in (-1," + Utils.toString(ids) + ")";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, _isPayment);
                result.add(payment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<Payment> getPaymentNotLogList(List<Integer> paymentIds) throws BGException {
        return this._getList("payment", true, paymentIds);
    }

    public List<Payment> getChargesList(List<Integer> chargeIds) throws BGException {
        return this._getList("charge", false, chargeIds);
    }

    private void _updateLog(String _table, int paymentId, int posId, String checkData, Check.Type checkType, String posMapping, String errorText, String pendingId, int contractId, String fiscalData, Integer logId) throws BGException {
        try {
            String query = null;
            query = logId == null ? "INSERT INTO `cashcheck_" + _table + "_log` (`" + _table + "_id`,`pos_id`, `check_data`, `check_type`, `pos_mapping`, `last_error`, `pending_id`, `contract_id`, `fiscal_data`) VALUES (?,?,?,?,?,?,?,?,?)" : "UPDATE `cashcheck_" + _table + "_log` SET `" + _table + "_id`=?,`pos_id`=?, `check_data`=?, `check_type`=?, `pos_mapping`=?, `last_error`=?, `pending_id`=?, `contract_id`=?, `fiscal_data`=?, `dt`=NOW() WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, paymentId);
            ps.setInt(2, posId);
            ps.setString(3, checkData);
            if (checkType != null) {
                ps.setString(4, checkType.name());
            } else {
                ps.setNull(4, 12);
            }
            ps.setString(5, posMapping);
            if (errorText != null) {
                ps.setString(6, errorText);
            } else {
                ps.setNull(6, 12);
            }
            if (pendingId != null) {
                ps.setString(7, pendingId);
            } else {
                ps.setNull(7, 12);
            }
            if (contractId > 0) {
                ps.setInt(8, contractId);
            } else {
                ps.setNull(8, 4);
            }
            if (fiscalData != null) {
                ps.setString(9, fiscalData);
            } else {
                ps.setNull(9, 12);
            }
            if (logId != null) {
                ps.setInt(10, logId);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updatePaymentLog(int paymentId, int posId, String checkData, Check.Type checkType, String posMapping, String errorText, String pendingId, int contractId, String fiscalData, Integer logId) throws BGException {
        this._updateLog("payment", paymentId, posId, checkData, checkType, posMapping, errorText, pendingId, contractId, fiscalData, logId);
    }

    public void updateChargeLog(int chargeId, int posId, String checkData, Check.Type checkType, String posMapping, String errorText, String pendingId, int contractId, String fiscalData, Integer logId) throws BGException {
        this._updateLog("charge", chargeId, posId, checkData, checkType, posMapping, errorText, pendingId, contractId, fiscalData, logId);
    }

    @Deprecated
    public void updatePaymentLog(int paymentId, int posId) throws BGException {
        this.updatePaymentLog(paymentId, posId, null, null, "?", null, null, -1, null, null);
    }

    public Result<Payment> getPaymentLog(int printerId, Period period, Page page) throws BGException {
        return this.getPaymentLog(null, printerId, null, null, period, page, null);
    }

    private Result<Payment> _getLog(String _table, boolean _isPayment, Set<Integer> cids, int printerId, Boolean erroredType, String posMapping, Period period, Page page, Collection<Integer> logIds) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            Object query = "";
            query = (String)query + "SELECT SQL_CALC_FOUND_ROWS log.id, log." + _table + "_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ";
            query = (String)query + "FROM cashcheck_" + _table + "_log AS log ";
            query = (String)query + "LEFT JOIN contract_" + _table + " AS contract_payment ON log." + _table + "_id=contract_payment.id ";
            query = (String)query + "LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ";
            query = (String)query + "LEFT JOIN contract_" + _table + "_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ";
            query = (String)query + "WHERE ( " + printerId + "=0 OR log.pos_id=" + printerId + " ) ";
            if (erroredType == Boolean.TRUE) {
                query = (String)query + " AND log.last_error IS NOT NULL";
            } else if (erroredType == Boolean.FALSE) {
                query = (String)query + " AND log.last_error IS NULL";
            }
            if (posMapping != null) {
                query = !"".equals(posMapping) ? (String)query + " AND log.pos_mapping = '" + posMapping + "'" : (String)query + " AND (log.pos_mapping = '' OR log.pos_mapping IS NULL)";
            }
            if (period != null && period.getDateFrom() != null) {
                query = (String)query + " AND log.dt>='" + TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd") + "'";
            }
            if (period != null && period.getDateTo() != null) {
                query = (String)query + " AND log.dt<=DATE_ADD('" + TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd") + "', INTERVAL 1 DAY )";
            }
            if (Utils.notEmptyCollection(cids)) {
                String c = Utils.toString(cids);
                query = (String)query + " AND (cid IN (" + c + ") OR contract.id IN (" + c + "))";
            }
            if (logIds != null) {
                query = (String)query + " AND log.id IN (" + String.valueOf(!logIds.isEmpty() ? Utils.toString(logIds) : Integer.valueOf(-1)) + ")";
            }
            query = (String)query + " ORDER BY log.dt DESC";
            if (page != null) {
                query = (String)query + page.sqlLimit();
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, _isPayment);
                result.add(payment);
            }
            rs.close();
            st.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public Result<Payment> getPaymentLog(Set<Integer> cids, int printerId, Boolean erroredType, String posMapping, Period period, Page page, Collection<Integer> logIds) throws BGException {
        return this._getLog("payment", true, cids, printerId, erroredType, posMapping, period, page, logIds);
    }

    public Result<Payment> getChargeLog(Set<Integer> cids, int printerId, Boolean erroredType, String posMapping, Period period, Page page, Collection<Integer> logIds) throws BGException {
        return this._getLog("charge", false, cids, printerId, erroredType, posMapping, period, page, logIds);
    }

    public Payment _getLogItem(String _table, boolean _isPayment, Integer paymentchargeId, Integer logId) throws BGException {
        if (paymentchargeId == null && logId == null) {
            throw new BGIllegalArgumentException();
        }
        Payment payment = null;
        try {
            Object query = "";
            query = (String)query + "SELECT log.id, log." + _table + "_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ";
            query = (String)query + "FROM cashcheck_" + _table + "_log AS log ";
            query = (String)query + "LEFT JOIN contract_" + _table + " AS contract_payment ON log." + _table + "_id=contract_payment.id ";
            query = (String)query + "LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ";
            query = (String)query + "LEFT JOIN contract_" + _table + "_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ";
            query = (String)query + "WHERE ( 1=1 ) ";
            if (paymentchargeId != null) {
                query = (String)query + " AND log." + _table + "_id=" + paymentchargeId;
            }
            if (logId != null) {
                query = (String)query + " AND log.id=" + logId;
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            while (rs.next()) {
                payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, _isPayment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return payment;
    }

    public Payment getPaymentLogItem(Integer paymentId, Integer logId) throws BGException {
        return this._getLogItem("payment", true, paymentId, logId);
    }

    public Payment getChargeLogItem(Integer chargeId, Integer logId) throws BGException {
        return this._getLogItem("charge", false, chargeId, logId);
    }

    public String _getLogItemFiscalData(String _table, Integer paymentchargeId, Integer logId) throws BGException {
        if (paymentchargeId == null && logId == null) {
            throw new BGIllegalArgumentException();
        }
        String fiscaldata = null;
        try {
            Statement st;
            ResultSet rs;
            Object query = "";
            query = (String)query + "SELECT log.id, log." + _table + "_id, log.fiscal_data ";
            query = (String)query + "FROM cashcheck_" + _table + "_log AS log ";
            query = (String)query + "WHERE ( 1=1 ) ";
            if (paymentchargeId != null) {
                query = (String)query + " AND log." + _table + "_id=" + paymentchargeId;
            }
            if (logId != null) {
                query = (String)query + " AND log.id=" + logId;
            }
            if ((rs = (st = this.con.createStatement()).executeQuery((String)query)).next()) {
                fiscaldata = rs.getString("log.fiscal_data");
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return fiscaldata;
    }

    public void _updateLastErrorForPendingId(String _table, String pendingId, String lastError) throws BGException {
        try {
            String query = "UPDATE cashcheck_" + _table + "_log SET last_error=? WHERE pending_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, lastError);
            ps.setString(2, pendingId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updatePaymentLastErrorForPendingId(String pendingId, String lastError) throws BGException {
        this._updateLastErrorForPendingId("payment", pendingId, lastError);
    }

    public void updateChargeLastErrorForPendingId(String pendingId, String lastError) throws BGException {
        this._updateLastErrorForPendingId("charge", pendingId, lastError);
    }

    public void _updateFiscalDataForPendingId(String _table, String pendingId, String fiscalData) throws BGException {
        try {
            String query = "UPDATE cashcheck_" + _table + "_log SET fiscal_data=? WHERE pending_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, fiscalData);
            ps.setString(2, pendingId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updatePaymentFiscalDataForPendingId(String pendingId, String fiscalData) throws BGException {
        this._updateFiscalDataForPendingId("payment", pendingId, fiscalData);
    }

    public void updateChargeFiscalDataForPendingId(String pendingId, String fiscalData) throws BGException {
        this._updateFiscalDataForPendingId("charge", pendingId, fiscalData);
    }

    public List<Payment> getNeedPendingIdLog(String _table, int printerId, Date fromDate, Date toDate, boolean isError) throws BGException {
        boolean _isPayment = _table.equals("payment");
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            Object query = "";
            query = (String)query + "SELECT log.id, log." + _table + "_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ";
            query = (String)query + "FROM cashcheck_" + _table + "_log AS log ";
            query = (String)query + "LEFT JOIN contract_" + _table + " AS contract_payment ON log." + _table + "_id=contract_payment.id ";
            query = (String)query + "LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ";
            query = (String)query + "LEFT JOIN contract_" + _table + "_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ";
            query = (String)query + "WHERE ( " + printerId + "<=0 OR log.pos_id=" + printerId + " ) AND log.pending_id IS NOT NULL AND log.fiscal_data IS NULL";
            query = isError ? (String)query + " AND log.last_error IS NOT NULL" : (String)query + " AND log.last_error IS NULL";
            if (fromDate != null) {
                query = (String)query + " AND log.dt>='" + TimeUtils.format((Date)fromDate, (String)"yyyy-MM-dd") + "'";
            }
            if (toDate != null) {
                query = (String)query + " AND log.dt<=DATE_ADD('" + TimeUtils.format((Date)toDate, (String)"yyyy-MM-dd") + "', INTERVAL 1 DAY )";
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, _isPayment);
                result.add(payment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Set<String> getExistingPosMapping() throws BGException {
        HashSet<String> result = new HashSet<String>();
        try {
            this._allPosMapping(result, "payment");
            this._allPosMapping(result, "charge");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private void _allPosMapping(Set<String> result, String _table) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT pos_mapping FROM cashcheck_" + _table + "_log");
        while (rs.next()) {
            result.add(rs.getString(1) != null ? rs.getString(1) : "");
        }
        rs.close();
        st.close();
    }
}

