/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Id;

public class TrafficTypeLinkRuleRuntime
extends Id {
    public final Date dateFrom;
    public final Date dateTo;
    public final long timeFrom;
    public final long timeTo;
    public final int type;
    public final Set<String> counterRealm;
    public final Pattern counterRealmPattern;
    public final Set<String> counterService;
    public final Pattern counterServicePattern;
    public final int counterVendor;
    public final int counterType;
    public final String counterPrefix;
    public final int sourceId;
    public final int interfaceId;
    public final int direction;
    public final IpAddress addressFrom;
    public final IpAddress addressTo;
    public final int portFrom;
    public final int portTo;
    public final int diffServ;
    public final int diffServMask;
    public final String diffServString;
    public final Integer trafficTypeId;
    private String comment;
    private static final Pattern patternPattern = Pattern.compile("^\\s*/(.+)/\\s*$");
    private static final Set<String> realmDefault = Collections.singleton("default");

    protected TrafficTypeLinkRuleRuntime() {
        this.dateFrom = null;
        this.dateTo = null;
        this.timeFrom = -1L;
        this.timeTo = -1L;
        this.type = -1;
        this.counterRealm = null;
        this.counterRealmPattern = null;
        this.counterService = null;
        this.counterServicePattern = null;
        this.counterVendor = -1;
        this.counterType = -1;
        this.counterPrefix = null;
        this.sourceId = -1;
        this.interfaceId = -1;
        this.direction = -1;
        this.addressFrom = null;
        this.addressTo = null;
        this.portFrom = -1;
        this.portTo = -1;
        this.diffServString = null;
        this.diffServ = -1;
        this.diffServMask = -1;
        this.trafficTypeId = -1;
        this.comment = null;
    }

    public static TrafficTypeLinkRuleRuntime newInstance(TrafficTypeLinkRule rule) {
        if (rule.type == 1) {
            return new TrafficTypeLinkRuleRuntime(rule.dateFrom, rule.dateTo, rule.counterRealm, rule.counterService, rule.counterVendor, rule.counterType, rule.counterPrefix, rule.trafficTypeId, rule.getComment());
        }
        return new TrafficTypeLinkRuleRuntime(rule.dateFrom, rule.dateTo, rule.sourceId, rule.interfaceId, rule.direction, rule.addressFrom, rule.addressTo, rule.portFrom, rule.portTo, rule.diffServString, rule.trafficTypeId, rule.getComment());
    }

    private TrafficTypeLinkRuleRuntime(Date dateFrom, Date dateTo, String counterRealm, String counterService, int counterVendor, int counterType, String counterPrefix, int trafficTypeId, String comment) {
        Matcher m;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)dateFrom);
        if (calendar == null) {
            this.timeFrom = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            this.timeFrom = calendar.getTimeInMillis();
        }
        calendar = TimeUtils.convertDateToCalendar((Date)dateTo);
        if (calendar == null) {
            this.timeTo = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.add(5, 1);
            calendar.add(14, -1);
            this.timeTo = calendar.getTimeInMillis();
        }
        this.type = 1;
        if (Utils.notBlankString((String)counterRealm)) {
            m = patternPattern.matcher(counterRealm);
            if (m.matches()) {
                this.counterRealm = null;
                this.counterRealmPattern = Pattern.compile(m.group(1));
            } else {
                this.counterRealm = new HashSet<String>(Utils.toList((String)counterRealm.trim()));
                this.counterRealmPattern = null;
            }
        } else {
            this.counterRealm = realmDefault;
            this.counterRealmPattern = null;
        }
        if (Utils.notBlankString((String)counterService)) {
            m = patternPattern.matcher(counterService);
            if (m.matches()) {
                this.counterService = null;
                this.counterServicePattern = Pattern.compile(m.group(1));
            } else {
                this.counterService = new HashSet<String>(Utils.toList((String)counterService.trim()));
                this.counterServicePattern = null;
            }
        } else {
            this.counterService = null;
            this.counterServicePattern = null;
        }
        this.counterVendor = counterVendor;
        this.counterType = counterType;
        this.counterPrefix = Utils.isBlankString((String)counterPrefix) ? null : counterPrefix;
        this.sourceId = -1;
        this.interfaceId = -1;
        this.direction = -1;
        this.addressFrom = null;
        this.addressTo = null;
        this.portFrom = -1;
        this.portTo = -1;
        this.diffServString = null;
        this.diffServ = -1;
        this.diffServMask = -1;
        this.trafficTypeId = trafficTypeId;
        this.comment = comment;
    }

    private TrafficTypeLinkRuleRuntime(Date dateFrom, Date dateTo, int sourceId, int interfaceId, int direction, IpAddress addressFrom, IpAddress addressTo, int portFrom, int portTo, String diffServString, int trafficTypeId, String comment) {
        int diffServMask;
        int diffServ;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)dateFrom);
        if (calendar == null) {
            this.timeFrom = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            this.timeFrom = calendar.getTimeInMillis();
        }
        calendar = TimeUtils.convertDateToCalendar((Date)dateTo);
        if (calendar == null) {
            this.timeTo = 0L;
        } else {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.add(5, 1);
            calendar.add(14, -1);
            this.timeTo = calendar.getTimeInMillis();
        }
        this.type = 2;
        this.counterRealm = null;
        this.counterRealmPattern = null;
        this.counterService = null;
        this.counterServicePattern = null;
        this.counterVendor = -1;
        this.counterType = -1;
        this.counterPrefix = null;
        this.sourceId = sourceId;
        this.interfaceId = interfaceId;
        this.direction = direction;
        this.addressFrom = addressFrom;
        this.addressTo = addressTo;
        this.portFrom = portFrom;
        this.portTo = portTo;
        this.diffServString = diffServString;
        try {
            String diffServProto = diffServString.replaceAll("\\.", "");
            diffServ = Integer.parseInt(diffServProto.replaceAll("x", "0"), 2);
            diffServMask = Integer.parseInt(diffServProto.replaceAll("[01]", "1").replaceAll("x", "0"), 2);
        }
        catch (Exception e) {
            diffServ = -1;
            diffServMask = 0;
        }
        this.diffServ = diffServ;
        this.diffServMask = diffServMask;
        this.trafficTypeId = trafficTypeId;
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 1: {
                sb.append("RADIUS: ").append(this.counterVendor).append(":").append(this.counterType);
                sb.append(" [").append(this.counterPrefix).append("]");
                sb.append(" => ").append(this.trafficTypeId);
                break;
            }
            case 2: {
                sb.append("Collector: ").append(this.sourceId).append(":").append(this.interfaceId);
                sb.append(" [").append(this.addressFrom).append("-").append(this.addressTo).append("]");
                sb.append(" [").append(this.portFrom).append("-").append(this.portTo).append("]");
                sb.append(" ").append(this.diffServ).append(" => ").append(this.trafficTypeId);
            }
        }
        return sb.toString();
    }
}

