/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import ru.bitel.common.Utils;

public class FlowAgentType {
    public static final int TYPE_NETFLOW = 1;
    public static final int TYPE_NETFLOW9 = 2;
    public static final int TYPE_SFLOW = 3;
    public static final int TYPE_SNMP = 4;
    public static final int TYPE_IPFIX = 5;

    public static final int nameToType(String type) {
        if ("netflow".equals(type)) {
            return 1;
        }
        if ("netflow9".equals(type)) {
            return 2;
        }
        if ("netflow10".equals(type) || "ipfix".equals(type)) {
            return 5;
        }
        if ("sflow".equals(type)) {
            return 3;
        }
        if ("snmp".equals(type)) {
            return 4;
        }
        return Utils.parseInt((String)type);
    }

    public static final String typeToName(int type) {
        switch (type) {
            case 1: {
                return "netflow";
            }
            case 2: {
                return "netflow9";
            }
            case 5: {
                return "ipfix";
            }
            case 3: {
                return "sflow";
            }
            case 4: {
                return "snmp";
            }
        }
        return "??? [" + type + "]";
    }

    public static final boolean checkSourceType(int type) {
        return type >= 1 && type <= 5;
    }

    public static final String typeToTitleString(int type) {
        switch (type) {
            case 1: {
                return "Netflow \u0432\u0435\u0440\u0441\u0438\u0439 1, 5, 7";
            }
            case 2: {
                return "Netflow \u0432\u0435\u0440\u0441\u0438\u0438 9";
            }
            case 5: {
                return "IPFIX \u0432\u0435\u0440\u0441\u0438\u0438 10";
            }
            case 3: {
                return "sFlow \u0432\u0435\u0440\u0441\u0438\u0438 5";
            }
            case 4: {
                return "SNMP";
            }
        }
        return null;
    }
}

