/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServForm;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;

public class InetServDeviceInterfaceForm
extends BGUPanel {
    private static final String INTERFACE_SELECT_ACTION = "interface.resource";
    private InetDeviceService deviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
    private DeviceInterfaceService deviceInterfaceService = (DeviceInterfaceService)((ClientContext)this.getContext()).getPort(DeviceInterfaceService.class);
    private final InetServForm inetServForm;
    private int interfaceId;
    private DeviceInterface initialDeviceInterface;
    private DeviceInterface deviceInterface;
    private DeviceInterfaceTableModel interfaceTableModel = new DeviceInterfaceTableModel();
    private BGUTable interfaceTable;
    private BGTextField interfaceNameTextField;
    private static final Comparator<DeviceInterface> COMPARATOR = new Comparator<DeviceInterface>(){

        @Override
        public int compare(DeviceInterface o1, DeviceInterface o2) {
            return o1.getPort() - o2.getPort();
        }
    };
    AbstractBGUPanel.AsyncAction<List<DeviceInterface>> interfaceSelect = new AbstractBGUPanel.AsyncAction<List<DeviceInterface>>("interface.resource", "\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b"){
        private volatile int invDeviceId;

        protected List<DeviceInterface> doInBackground() throws Exception {
            InetServType inetServType = (InetServType)InetServDeviceInterfaceForm.this.inetServForm.serviceType.getSelectedItem();
            boolean personalInterface = inetServType == null || inetServType.isPersonalInterface();
            InetDevice inetDevice = InetServDeviceInterfaceForm.this.deviceService.inetDeviceGet(InetServDeviceInterfaceForm.this.inetServForm.current.getDeviceId());
            if (inetDevice == null) {
                return null;
            }
            this.invDeviceId = inetDevice.getInvDeviceId();
            List list = InetServDeviceInterfaceForm.this.deviceInterfaceService.deviceInterfaceListFree(inetDevice.getInvDeviceId(), InetServDeviceInterfaceForm.this.inetServForm.period.getDateFrom(), InetServDeviceInterfaceForm.this.inetServForm.period.getDateTo(), InetServDeviceInterfaceForm.this.interfaceNameTextField.getText());
            if (!personalInterface) {
                int i;
                HashSet<DeviceInterface> freeInterfaces = new HashSet<DeviceInterface>();
                int size = list.size();
                for (i = 0; i < size; ++i) {
                    freeInterfaces.add((DeviceInterface)list.get(i));
                }
                list = InetServDeviceInterfaceForm.this.deviceInterfaceService.devicePortList(inetDevice.getInvDeviceId(), false);
                size = list.size();
                for (i = 0; i < size; ++i) {
                    DeviceInterface iface = (DeviceInterface)list.get(i);
                    if (freeInterfaces.contains(iface)) continue;
                    iface.setTitle(iface.getTitle() + " *");
                }
            }
            return list;
        }

        protected void done(List<DeviceInterface> result) throws Exception {
            if (result == null) {
                return;
            }
            if (InetServDeviceInterfaceForm.this.initialDeviceInterface != null && InetServDeviceInterfaceForm.this.initialDeviceInterface.getDeviceId() == this.invDeviceId) {
                int pos = 0;
                if (result.size() <= 100) {
                    int idx = Collections.binarySearch(result, InetServDeviceInterfaceForm.this.initialDeviceInterface, COMPARATOR);
                    if (idx < 0) {
                        pos = -idx - 1;
                        result.add(pos, InetServDeviceInterfaceForm.this.initialDeviceInterface);
                    } else {
                        pos = idx;
                    }
                } else {
                    result.add(pos, InetServDeviceInterfaceForm.this.initialDeviceInterface);
                }
                InetServDeviceInterfaceForm.this.interfaceTableModel.setData(result);
                if (InetServDeviceInterfaceForm.this.deviceInterface == null || InetServDeviceInterfaceForm.this.deviceInterface.equals((Object)InetServDeviceInterfaceForm.this.initialDeviceInterface)) {
                    InetServDeviceInterfaceForm.this.interfaceTableModel.setSelectedRow(InetServDeviceInterfaceForm.this.initialDeviceInterface);
                } else {
                    InetServDeviceInterfaceForm.this.interfaceTableModel.setSelectedRow(InetServDeviceInterfaceForm.this.deviceInterface);
                }
            } else {
                InetServDeviceInterfaceForm.this.interfaceTableModel.setData(result);
            }
            InetServDeviceInterfaceForm.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction ok = new AbstractBGUPanel.DefaultAction("ok", "Ok"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            DeviceInterface selected = (DeviceInterface)InetServDeviceInterfaceForm.this.interfaceTableModel.getSelectedRow();
            if (selected != null) {
                InetServDeviceInterfaceForm.this.interfaceId = selected.getPort();
                InetServDeviceInterfaceForm.this.deviceInterface = selected;
                InetServDeviceInterfaceForm.this.inetServForm.setIface(InetServDeviceInterfaceForm.this.deviceInterface.getTitle());
            } else {
                InetServDeviceInterfaceForm.this.interfaceId = 0;
                InetServDeviceInterfaceForm.this.deviceInterface = null;
                InetServDeviceInterfaceForm.this.inetServForm.setIface("");
            }
            InetServDeviceInterfaceForm.this.interfaceNameTextField.setText("");
            InetServDeviceInterfaceForm.this.performActionClose();
        }
    };

    public InetServDeviceInterfaceForm(InetServForm inetServForm, ActionListener actionListener) {
        super((LayoutManager)new GridBagLayout());
        this.inetServForm = inetServForm;
    }

    protected void jbInit() {
        this.interfaceNameTextField = new BGTextField();
        this.interfaceTable = new BGUTable((TableModel)((Object)this.interfaceTableModel));
        this.interfaceTable.setSelectionMode(0);
        this.interfaceTable.getDefaultEditor(String.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                try {
                    InetServDeviceInterfaceForm.this.deviceInterfaceService.devicePortCommentUpdate((DeviceInterface)InetServDeviceInterfaceForm.this.interfaceTableModel.getSelectedRow());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        filterPanel.add((Component)this.interfaceNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JPanel)filterPanel, (String)"\u0424\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 5, 3), 0, 0));
        this.add(new JScrollPane((Component)this.interfaceTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.interfaceNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InetServDeviceInterfaceForm.this.performAction(InetServDeviceInterfaceForm.INTERFACE_SELECT_ACTION);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InetServDeviceInterfaceForm.this.performAction(InetServDeviceInterfaceForm.INTERFACE_SELECT_ACTION);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InetServDeviceInterfaceForm.this.performAction(InetServDeviceInterfaceForm.INTERFACE_SELECT_ACTION);
            }
        });
    }

    public void setInterfaceId(int interfaceId) throws Exception {
        this.interfaceId = interfaceId;
        this.interfaceNameTextField.setText("");
        if (interfaceId == -1) {
            this.initialDeviceInterface = null;
            this.deviceInterface = null;
            return;
        }
        InetDevice inetDevice = this.deviceService.inetDeviceGet(this.inetServForm.current.getDeviceId());
        if (inetDevice == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0431\u0430\u0437\u0435");
            return;
        }
        this.deviceInterface = this.initialDeviceInterface = this.deviceInterfaceService.devicePort(inetDevice.getInvDeviceId(), interfaceId);
        if (this.initialDeviceInterface == null) {
            throw new BGException("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + interfaceId + "  \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442! \u0418\u0441\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430.");
        }
    }

    public int getInterfaceId() {
        return this.interfaceId;
    }

    public String getInterfaceTitle() {
        return this.deviceInterface.getTitle();
    }

    class DeviceInterfaceTableModel
    extends BGTableModel<DeviceInterface> {
        public DeviceInterfaceTableModel() {
            super(DeviceInterfaceTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", 100, 100, 100, "port", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 200, 200, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 250, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return "comment".equals(this.getIdentifier(columnIndex));
        }
    }
}

