package ru.bitel.bgbilling.modules.inet.dyn.access;

import java.math.BigDecimal;
import java.sql.ResultSet;

import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScriptBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;

/**
 * Синхронизация состояний сервисов после добавления платежей через БД, ошибке работы MQ и т.п.<br>
 * Посылает событие изменения баланса, заставляя BGBillingServer проверять состояние сервисов.
 * Сработает для всех договоров только, если выполнить после перезапуска BGBillingServer.<br>
 * Может потребовать много ресурсов.
 * @author amir
 *
 */
public class InetServStateSync
	extends GlobalScriptBase
{
	@Override
	public void execute( final Setup setup, final ConnectionSet connectionSet )
		throws Exception
	{
		final EventProcessor ep = EventProcessor.getInstance();

		ResultSet rs = connectionSet.getConnection().createStatement().executeQuery( "SELECT id FROM contract" );
		while( rs.next() )
		{
			ContractBalanceChangedEvent e = new ContractBalanceChangedEvent( rs.getInt( 1 ), ContractBalanceChangedEvent.TYPE_PAYMENT_CHANGE, BigDecimal.ZERO );
			ep.publish( e );
		}
		rs.close();
	}
}
