<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
<xsl:import href="layout.xsl"/>

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:variable name="mid" select="/data/@mid"/>
<xsl:variable name="activateType" select="/data/@activateType"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>

<xsl:template name="title">Превышен лимит обращений к серверу</xsl:template>

<xsl:template match="/data">
	<form method="post" action="{$WEBEXECUTER}?action=ResetLimit&amp;module=contract">	
		<table class="filter" align="center">
			<xsl:if test="error/@id='badCode'">
				<tr>
					<td><h2>Вы ввели неправильный код</h2></td>
				</tr>			
			</xsl:if>
				
			<tr>
				<td colspan="3">Для продолжения работы введите символы, показанные на картинке.<br/> Буквы вводятся без учета регистра.</td>
			</tr>
			<tr>
				<td valign="middle" style="height:50px;">
					<img src="{$WEBEXECUTER}?module=contract&amp;action=ResetLimit&amp;getcaptcha={/data/@rand}"/>
				</td>
				<td align="right">
					<input type="text" size="30" name="captcha" /><br/>		
				</td>
				<td colspan="2" align="right"><input type="submit" value="Продолжить" /></td>
			</tr>
		</table>
	</form>

</xsl:template>

</xsl:stylesheet>