/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog.hourly;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyLogFileUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;

public abstract class HourlyDataLogEntry<T extends DataLog<?>> {
    private static final Logger logger = LogManager.getLogger();
    public final T log;
    protected long lastModified = -1L;

    protected HourlyDataLogEntry(ParameterMap setup, String logDirParamName, int sourceId, String sourceConfig, String type, Calendar hour, Map<DataLog.Parameter<?>, Object> parameters) throws IOException {
        int[] idRef = new int[1];
        File file = HourlyLogFileUtils.getNextFileToWrite(setup, logDirParamName, sourceId, hour, idRef);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        Preferences params = new Preferences(setup, sourceConfig, "\r\n");
        logger.info("Create dataLog file: " + file.getAbsolutePath());
        this.log = this.create(idRef[0], file, raf, type, (ParameterMap)params);
        if (parameters != null) {
            for (Map.Entry<DataLog.Parameter<?>, Object> e : parameters.entrySet()) {
                ((DataLog)this.log).getParameterMap().put(e.getKey(), e.getValue());
            }
        }
        ((DataLog)this.log).asWriter();
    }

    protected T create(int id, File file, RandomAccessFile raf, String type, ParameterMap params) {
        return null;
    }

    public boolean wasModified() {
        logger.debug("Last modified: " + ((DataLog)this.log).getFile().lastModified() + " : " + this.lastModified);
        long m = ((DataLog)this.log).getFile().lastModified();
        boolean result = this.lastModified != m;
        this.lastModified = m;
        return result;
    }

    public void close() throws IOException {
        ((DataLog)this.log).close();
        try {
            if (((DataLog)this.log).getFile().getUsableSpace() < 0x40000000L) {
                String key = "data.log.freespace";
                AlarmSender.sendAlarm("data.log.freespace", 600000L, "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u043d\u0430 \u0434\u0438\u0441\u043a\u0435", String.format("\u041d\u0430 \u0434\u0438\u0441\u043a\u0435, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043f\u0438\u0448\u0443\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u044b \u043b\u043e\u0433\u043e\u0432 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c %.3f\u041c\u0411", (double)((DataLog)this.log).getFile().getUsableSpace() / 1024.0 / 1024.0));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setDefaultCompression(ParameterMap params, DataLog<?> dataLog, String key) {
        BGDataLog.Compression compression = new BGDataLog.Compression();
        compression.type = params.getInt("datalog.compression.type", 0);
        compression.level = params.getInt("datalog.compression.level", 1);
        compression.strategy = params.getInt("datalog.compression.strategy", 1);
        BGDataLog.Buffer buffer = new BGDataLog.Buffer();
        buffer.type = buffer.CHUNKED;
        buffer.size = params.getInt("datalog." + key + ".chunk.size", params.getInt("datalog.chunk.size", 262144));
        compression.type = params.getInt("datalog." + key + ".compression.type", compression.type);
        compression.level = params.getInt("datalog." + key + "compression.level", compression.level);
        compression.strategy = params.getInt("datalog." + key + ".compression.strategy", compression.strategy);
        dataLog.setParameter(BGDataLog.BUFFER, buffer);
        dataLog.setParameter(BGDataLog.COMPRESSION, compression);
        dataLog.setParameter(BGDataLog.DISTRIBUTED, new BGDataLog.Distributed());
    }
}

