/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class ListValuesPopupEditor
extends JPopupMenu {
    protected JTextField valueField = new JTextField();
    private BGUList<IdTitle> valuesList = new BGUList();
    protected JButton addButton = new JButton();
    protected JButton removeButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected String action = "List";
    protected String module;
    protected String paramId;
    protected String customValue;
    protected List<IdTitle> values = new ArrayList<IdTitle>();

    public ListValuesPopupEditor() {
        this.jbinit();
    }

    protected void jbinit() {
        this.valueField.setPreferredSize(new Dimension(150, 25));
        this.valuesList.setSelectionMode(0);
        this.addButton.setText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        this.addButton.setPreferredSize(new Dimension(110, 25));
        this.removeButton.setText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.removeButton.setPreferredSize(new Dimension(110, 25));
        this.removeButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0432\u043e\u0451 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.cancelButton.setPreferredSize(new Dimension(110, 25));
        this.cancelButton.setText("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.setTextButton();
        JScrollPane scroll = new JScrollPane(this.valuesList);
        scroll.setPreferredSize(new Dimension(300, 100));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 5), 0, 0));
        this.add((Component)this.valueField, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0418\u043b\u0438 \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430:"), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 5), 0, 0));
        this.add((Component)scroll, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addButton.addActionListener(e -> {
            if (Utils.isBlankString(this.valueField.getText()) && this.valuesList.isSelectionEmpty()) {
                return;
            }
            if (this.addButton.getActionCommand().equals("replace")) {
                this.updateValue();
            } else {
                this.addValue();
            }
            this.setVisible(false);
        });
        this.removeButton.addActionListener(e -> this.deleteValue());
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        this.valueField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ListValuesPopupEditor.this.autoCompleteJList();
            }
        });
        this.valuesList.addListSelectionListener(e -> this.setTextButton());
    }

    public void init(String module, String paramId) {
        this.module = module;
        this.paramId = paramId;
    }

    public void setText(String text) {
        this.valueField.setText(text);
    }

    public String getText() {
        return this.valueField.getText();
    }

    protected void autoCompleteJList() {
        String text = this.valueField.getText().toLowerCase().trim();
        this.valuesList.setData(this.values.stream().filter(a -> a.getTitle().toLowerCase().startsWith(text)).toList());
        this.valuesList.setSelectedValue(this.valuesList.getData().stream().filter(a -> a.getTitle().equals(text)).findFirst().orElse(null), true);
        this.setTextButton();
    }

    protected void setTextButton() {
        if (this.valuesList.isSelectionEmpty()) {
            this.addButton.setText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
            this.addButton.setActionCommand("add");
            this.addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0438 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
        } else {
            this.addButton.setText("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c");
            this.addButton.setActionCommand("replace");
            this.addButton.setToolTipText("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430");
        }
    }

    public void setData() {
        Request request = new Request().setModule(this.module).setAction(this.action + "Values").setAttribute("pid", this.paramId);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            try {
                this.values = new ArrayList<IdTitle>();
                XMLUtils.selectElements(doc, "//values/item").forEach(a -> this.values.add(new BGUListItem(Utils.parseInt(a.getAttribute("id")), a.getAttribute("title"))));
                this.valuesList.setData(this.values);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        this.autoCompleteJList();
    }

    protected void updateValue() {
        this.updateValue(this.getSelectedId(), this.valuesList.getSelectedValue() != null ? ((IdTitle)this.valuesList.getSelectedValue()).toString() : "");
    }

    protected void addValue() {
        this.updateValue(0, this.valueField.getText().trim());
    }

    protected void updateValue(int id, String title) {
        Request request = new Request().setModule(this.module).setAction("Update" + this.action + "CustomValue").setAttribute("id", id).setAttribute("pid", this.paramId).setAttribute("title", title).setAttribute("customValue", this.customValue);
        if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
            this.setData();
            this.firePropertyChange("UpdateListValue", null, null);
        }
    }

    protected void deleteValue() {
        Request request;
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0 && ClientUtils.checkStatus(TransferManager.getDocument(request = new Request().setModule(this.module).setAction("Delete" + this.action + "CustomValue").setAttribute("customValue", this.customValue).setAttribute("pid", this.paramId)))) {
            this.setData();
            this.firePropertyChange("UpdateListValue", null, null);
        }
    }

    protected int getSelectedId() {
        return this.valuesList.optSelectedValue().map(a -> a.getId()).orElse(-1);
    }

    public void setCustomValue(String customValue) {
        this.customValue = customValue;
    }
}

