/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import java.awt.GridLayout;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;

public class ContractPanelContainer
extends JPanel {
    private ContractEditor editor;
    private String className;
    private ContractPanel panel;
    private boolean setDataAfterBuild;

    public ContractPanelContainer(ContractEditor editor, String className) {
        this(editor, className, false);
    }

    public ContractPanelContainer(ContractEditor editor, String className, boolean setDataAfterBuild) {
        super(new GridLayout());
        this.editor = editor;
        this.className = className;
        this.setDataAfterBuild = setDataAfterBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        try {
            Class<?> clazz = Class.forName(this.className);
            String rb_name = clazz.getPackage().getName() + ".setup";
            ClientContext context = new ClientContext(this.editor.getModule(), 0, this.editor.getContractId(), rb_name);
            ClientContext.push(context);
            try {
                this.buildImpl();
            }
            finally {
                ClientContext.pop();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void buildImpl() {
        block8: {
            try {
                Class<?> clazz = Class.forName(this.className);
                Constructor<?> constructor = null;
                try {
                    constructor = clazz.getConstructor(ContractEditor.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (constructor != null) {
                    this.panel = (ContractPanel)constructor.newInstance(this.editor);
                    break block8;
                }
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.panel = (ContractPanel)constructor.newInstance(new Object[0]);
                this.panel.init(this.editor);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        if (this.setDataAfterBuild) {
            this.panel.trySetData();
        }
        this.add(this.panel);
    }

    public ContractPanel getPanel() {
        if (this.panel == null) {
            this.build();
        }
        return this.panel;
    }

    public String getClassName() {
        return this.className;
    }
}

