/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.directory;

import bitel.billing.module.tariff.util.TimeLimitPeriods;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.list.BGUList;

public class TimeTypesEditor
extends BGPanel {
    private static final String module = "tariff";
    private CardLayout editorLayout = new CardLayout();
    private JPanel editor = new JPanel(this.editorLayout);
    private BGTextField titleTf = new BGTextField();
    private BGUList<BGUListItem> typeList = new BGUList();
    private DefaultListModel<TimeLimitPeriods> periodListModel = new DefaultListModel();
    private JList<TimeLimitPeriods> periodList = new JList<TimeLimitPeriods>(this.periodListModel);

    public TimeTypesEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.setVisible(false);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JScrollPane listScroll = new JScrollPane(this.typeList);
        this.add((Component)listScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane limitsScroll = new JScrollPane(this.periodList);
        JPanel editorListPanel = new JPanel(new GridBagLayout());
        editorListPanel.add((Component)limitsScroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.toolBarAction(e));
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.setToolBar(new String[]{"newItem", "deleteItem", "editItem"});
        editorListPanel.add((Component)toolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        titlePanel.add((Component)this.titleTf, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        editorListPanel.add((Component)titlePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        editorListPanel.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.editor.add((Component)editorListPanel, "list");
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.periodList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeTypesEditor.this.editSelectedTl();
                }
            }
        });
        this.typeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeTypesEditor.this.editItem();
                }
            }
        });
    }

    @Override
    public void setData() throws Exception {
        Request request = new Request();
        request.setModule(module);
        request.setAction("TimeTypeList");
        Document doc = this.getDocument(request);
        ArrayList items = new ArrayList();
        XMLUtils.selectElements(doc, "//list/item").forEach(a -> items.add(new BGUListItem(Utils.parseInt(a.getAttribute("id")), a.getAttribute("title"))));
        this.typeList.setData(items);
    }

    private void startEdit() {
        if (this.id == 0) {
            this.titleTf.setText("");
            this.periodListModel.clear();
        } else {
            Request req = new Request();
            req.setModule(module);
            req.setAction("TimeTypeGet");
            req.setAttribute("id", this.id);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                Element type = XMLUtils.getElement(doc, "type");
                this.titleTf.setText(type.getAttribute("title"));
                this.loadData(type.getAttribute("data"));
            }
        }
        this.editor.setVisible(true);
    }

    private void loadData(String data) {
        this.periodListModel.clear();
        StringTokenizer st = new StringTokenizer(data, "#");
        while (st.hasMoreTokens()) {
            TimeLimitPeriods limit = new TimeLimitPeriods();
            limit.setData(st.nextToken());
            this.periodListModel.addElement(limit);
        }
    }

    @Override
    public void deleteItem() {
        Request request;
        this.id = Utils.parseInt(ClientUtils.getIdFromList(this.typeList));
        if (this.id == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0432\u0440\u0435\u043c\u0435\u043d\u0438?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0 && ClientUtils.checkStatus(this.getDocument(request = new Request().setModule(module).setAction("TimeTypeDelete").setAttribute("id", this.id)))) {
            this.trySetData();
        }
    }

    @Override
    public void editItem() {
        this.id = Utils.parseInt(ClientUtils.getIdFromList(this.typeList));
        if (this.id == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.startEdit();
        }
    }

    @Override
    public void newItem() {
        this.id = 0;
        this.startEdit();
    }

    private void stopEdit(boolean save) {
        if (save) {
            String title = this.titleTf.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return;
            }
            StringBuilder data = new StringBuilder(200);
            int size = this.periodListModel.getSize();
            for (int i = 0; i < size; ++i) {
                TimeLimitPeriods limits = this.periodListModel.get(i);
                if (data.length() != 0) {
                    data.append("#");
                }
                data.append(limits.getData());
            }
            Request req = new Request().setModule(module).setAction("TimeTypeUpdate").setAttribute("id", this.id).setAttribute("title", title).setAttribute("data", data.toString());
            if (ClientUtils.checkStatus(this.getDocument(req))) {
                this.editor.setVisible(false);
                this.trySetData();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void toolBarAction(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            int pos;
            if (command.equals("newItem")) {
                TimeLimitPeriods period = new TimeLimitPeriods();
                this.periodListModel.addElement(period);
                this.editTimeLimitPeriods(period);
            } else if (command.equals("editItem")) {
                this.editSelectedTl();
            } else if (command.equals("deleteItem") && (pos = this.periodList.getSelectedIndex()) >= 0) {
                this.periodListModel.remove(pos);
            }
        }
    }

    private void editSelectedTl() {
        TimeLimitPeriods period = this.periodList.getSelectedValue();
        if (period != null) {
            this.editTimeLimitPeriods(period);
        }
    }

    private void editTimeLimitPeriods(TimeLimitPeriods period) {
        period.startEdit();
        this.editor.add((Component)period, "edit");
        this.editorLayout.show(this.editor, "edit");
        period.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TimeTypesEditor.this.editorLayout.show(TimeTypesEditor.this.editor, "list");
            }
        });
    }
}

