/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;

public abstract class AbstractEntityDao<E extends Entity>
extends AbstractEntityAttrDao<E> {
    public AbstractEntityDao(Connection con, int moduleId, int userId, String tableName, String entityTableSuffix) {
        this(con, moduleId, userId, tableName, entityTableSuffix, ENTITY_SUPPORT);
    }

    public AbstractEntityDao(Connection con, int moduleId, int userId, String tableName, String entityTableSuffix, EntityAttrDaoSupport entityAttrDaoSupport) {
        super(con, moduleId, userId, tableName, entityTableSuffix, entityAttrDaoSupport);
    }

    protected void linkEntity(Entity entity) throws BGException {
        block26: {
            if (entity.getId() <= 0 || entity.getEntitySpecId() > 0 && entity.getEntityId() == 0) {
                String query = "INSERT INTO entity SET entitySpecId=?, title=?";
                try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                    ps.setInt(1, entity.getEntitySpecId());
                    ps.setString(2, "");
                    ps.executeUpdate();
                    entity.setEntityId(ServerUtils.lastInsertId(ps));
                    break block26;
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            if (entity.getEntitySpecId() > 0) {
                String query = "UPDATE entity SET entitySpecId=?, title=? WHERE id=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setInt(1, entity.getEntitySpecId());
                    ps.setString(2, "");
                    ps.setInt(3, entity.getEntityId());
                    ps.executeUpdate();
                    break block26;
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            String query = "UPDATE entity SET title=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, "");
                ps.setInt(2, entity.getEntityId());
                ps.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected void unlinkEntity(int entityId) throws SQLException {
        String query = "DELETE FROM entity WHERE entity.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, entityId);
            ps.executeUpdate();
        }
    }

    public void update(E b) throws BGException, SQLException {
        this.updateImpl(b);
        this.updateEntityAttributes(b.getId(), b.getEntityAttributes());
    }

    public int delete(int id) throws Exception {
        int result = 0;
        result = super.deleteImpl(id);
        this.deleteEntityAttributes(id);
        return result;
    }

    @Override
    protected List<E> list(boolean loadAttributes, Page page, String what, String join, List<FilterEntityAttr> entityFilter, String filter, String groupBy, String orderBy, Object ... params) throws BGException {
        try {
            what = what == null ? "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle" : "SQL_CALC_FOUND_ROWS " + (String)what + ", entity.entitySpecId, entity.title as entityTitle";
            List result = this.listImpl(loadAttributes, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", join, entityFilter, filter, groupBy, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return result;
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    @Override
    protected E getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException, BGException {
        E result = this.getFromRSImpl(rs);
        if (loadAttributes) {
            result.setEntityAttributes(this.getEntityAttributes(result.getEntitySpecId(), result.getId(), false));
        }
        return result;
    }

    protected abstract E getFromRSImpl(ResultSet var1) throws SQLException, BGException;

    protected Result<E> list(Page page, String filter, String orderBy, Object ... params) throws BGException {
        try {
            List result = this.listImpl(true, page, "SQL_CALC_FOUND_ROWS " + this.tableName + ".*, entity.entitySpecId, entity.title as entityTitle", "LEFT JOIN entity ON entity.id=" + this.tableName + ".entityId", null, null, filter, null, orderBy, params);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            return new Result(result, page);
        }
        catch (SQLException e) {
            this.processException(e);
            return new Result(Collections.emptyList());
        }
    }

    protected List<E> listImpl(Page page, String filter, String orderBy, Object ... params) throws BGException, SQLException {
        return this.listImpl(true, page, this.tableName + ".*", null, null, null, filter, null, orderBy, params);
    }

    @Override
    protected E getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true);
    }

    static {
        try {
            new AbstractEntityAttrDao.AddressItemModifiedEventListener(){

                @Override
                protected AbstractEntityAttrDao<?> newDao(ServerContext context) {
                    return new AbstractEntityDao<Entity>(this, context.getConnection(), context.getModuleId(), context.getUserId(), null, null){

                        @Override
                        protected Entity getFromRSImpl(ResultSet rs) throws SQLException, BGException {
                            return null;
                        }

                        protected void updateImpl(Entity b) throws BGException, SQLException {
                        }
                    };
                }
            };
        }
        catch (Throwable t) {
            BGLogger.error(t);
        }
    }
}

