/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.entity.client.model.EntitySpecAttrListItemTableModel;
import ru.bitel.oss.kernel.entity.client.model.EntitySpecAttrTableModel;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrListItem;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntitySpecAttrListPanel
extends BGUPanel {
    private EntitySpecAttrTableModel model = new EntitySpecAttrTableModel("EntitySpecAttrTable");
    private EntityService wsEntity;

    public EntitySpecAttrListPanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit(table, this);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> Async.of(() -> this.model.setData(this.getEntityService().entitySpecAttrListByType(EntitySpecAttrType.LIST.getCode()))));
        new AbstractBGUPanel.BGActionEdit(e -> this.model.optSelectedRow().ifPresent(a -> new ListItemsEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u043f\u0438\u0441\u043a\u0430", (EntitySpecAttr)a).open()));
    }

    private EntityService getEntityService() {
        if (this.wsEntity == null) {
            this.wsEntity = ((ClientContext)this.getContext()).getPort(EntityService.class, 0);
        }
        return this.wsEntity;
    }

    class ListItemsEditor
    extends BGEditorDialog<EntitySpecAttr> {
        private EntitySpecAttrListItemTableModel listModel;
        AbstractBGUPanel.DefaultAction refreshAction;
        AbstractBGUPanel.DefaultAction newAction;
        AbstractBGUPanel.DefaultAction editAction;
        AbstractBGUPanel.DefaultAction deleteAction;

        public ListItemsEditor(String title, EntitySpecAttr data) {
            super(title, data);
            this.listModel = new EntitySpecAttrListItemTableModel();
            this.refreshAction = new AbstractBGUPanel.DefaultAction("EntitySpecAttrListItemTable.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", AbstractBGUPanel.ICON_REFRESH){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ListItemsEditor.this.listModel.setData(EntitySpecAttrListPanel.this.getEntityService().entitySpecAttrListItemList(((EntitySpecAttr)ListItemsEditor.this.data).getId()));
                }
            };
            this.newAction = new AbstractBGUPanel.DefaultAction("EntitySpecAttrListItemTable.new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", AbstractBGUPanel.ICON_NEW){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    new ListItemEditor("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new EntitySpecAttrListItem(-1)).open();
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(true);
                }
            };
            this.editAction = new AbstractBGUPanel.DefaultAction("EntitySpecAttrListItemTable.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", AbstractBGUPanel.ICON_EDIT){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    EntitySpecAttrListItem current = (EntitySpecAttrListItem)ListItemsEditor.this.listModel.getSelectedRow();
                    if (current != null) {
                        new ListItemEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", current).open();
                    }
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(true);
                }
            };
            this.deleteAction = new AbstractBGUPanel.DefaultAction("EntitySpecAttrListItemTable.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", AbstractBGUPanel.ICON_DELETE){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    EntitySpecAttrListItem current = (EntitySpecAttrListItem)ListItemsEditor.this.listModel.getSelectedRow();
                    if (current != null && BGSwingUtilites.confirmDelete("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430", current)) {
                        EntitySpecAttrListPanel.this.getEntityService().entitySpecAttrListItemDelete(((EntitySpecAttr)ListItemsEditor.this.data).getId(), current.getId());
                        ListItemsEditor.this.refreshAction.perform();
                    }
                }

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(true);
                }
            };
        }

        @Override
        public void doDialogPanel() {
            BGUTable table = new BGUTable(this.listModel);
            BGDialogToolBar toolBar = new BGDialogToolBar();
            this.panel.add((Component)toolBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 700, 400), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.getActionMap().put("EntitySpecAttrListItemTable.new", this.newAction);
            this.panel.getActionMap().put("EntitySpecAttrListItemTable.edit", this.editAction);
            this.panel.getActionMap().put("EntitySpecAttrListItemTable.delete", this.deleteAction);
            BGSwingUtilites.buildToolBar(toolBar, (JComponent)this.panel, "EntitySpecAttrListItemTable.new", "EntitySpecAttrListItemTable.edit", "EntitySpecAttrListItemTable.delete");
            toolBar.compact();
            BGSwingUtilites.handleEdit((JTable)table, this.panel, "EntitySpecAttrListItemTable.edit");
            this.refreshAction.perform();
        }

        class ListItemEditor
        extends BGEditorDialog<EntitySpecAttrListItem> {
            private JTextField value;

            public ListItemEditor(String title, EntitySpecAttrListItem data) {
                super(title, data);
                this.value = new JTextField(40);
            }

            @Override
            public void doDialogPanel() {
                this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                this.panel.add((Component)this.value, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
                this.value.setText(((EntitySpecAttrListItem)this.data).getTitle());
            }

            @Override
            public boolean doApply() throws Exception {
                ((EntitySpecAttrListItem)this.data).setTitle(this.value.getText());
                int id = EntitySpecAttrListPanel.this.getEntityService().entitySpecAttrListItemUpdate(((EntitySpecAttr)ListItemsEditor.this.data).getId(), (EntitySpecAttrListItem)this.data);
                ListItemsEditor.this.refreshAction.perform();
                ListItemsEditor.this.listModel.setSelectedRow(id);
                return true;
            }
        }
    }
}

