/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.GeneratorOptions;
import ru.bitel.common.Utils;

public class CodeGenerator {
    private static final String DUMMY = "${package}${import}public class ${class}${deriving}{\n${methods}}";
    private Set<String> importSet;
    private GeneratorOptions options;
    private Class<?> superclass = null;
    private Map<String, Class<?>> ifaceMap;

    public CodeGenerator(GeneratorOptions options) {
        this.options = options;
    }

    public String generateCode() throws BGException {
        if (!DynamicClass.isJavaSource(this.options.getFullClassName())) {
            return this.options.getRawResourceData() != null ? this.options.getRawResourceData() : "";
        }
        this.importSet = new HashSet<String>();
        StringBuilder packageSb = new StringBuilder();
        StringBuilder classSb = new StringBuilder();
        StringBuilder derivingSb = new StringBuilder();
        StringBuilder methodsSb = new StringBuilder();
        this.generatePackageAndClass(packageSb, classSb);
        try {
            this.generateDeriving(derivingSb);
            this.generateMethods(methodsSb);
        }
        catch (ClassNotFoundException ex) {
            throw new BGException((Throwable)ex);
        }
        return DUMMY.replace("${package}", packageSb).replace("${class}", classSb).replace("${deriving}", derivingSb).replace("${import}", CodeGenerator.importsToString(this.importSet)).replace("${methods}", methodsSb);
    }

    private void generatePackageAndClass(StringBuilder packageSb, StringBuilder classSb) throws BGMessageException {
        if (Utils.isBlankString((String)this.options.getFullClassName())) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430!");
        }
        classSb.append(this.options.getSimpleClassName());
        classSb.append("\n");
        packageSb.append((String)(Utils.notBlankString((String)this.options.getPackageName()) ? "package " + this.options.getPackageName() + ";\n\n" : ""));
    }

    private void generateDeriving(StringBuilder derivingSb) throws ClassNotFoundException {
        Class<?> iface;
        if (Utils.notBlankString((String)this.options.getSuperclassName())) {
            this.superclass = Class.forName(this.options.getSuperclassName());
            this.checkForImport(this.superclass);
            derivingSb.append("\textends ");
            derivingSb.append(CodeGenerator.checkEquals(this.options.getSimpleClassName(), this.superclass));
            derivingSb.append("\n");
        }
        this.ifaceMap = new HashMap();
        for (String ifaceName : this.options.getInterfaceNames()) {
            iface = Class.forName(ifaceName);
            this.ifaceMap.put(ifaceName, iface);
        }
        for (String ifaceName : this.options.getDerivingInterfaceNames()) {
            iface = Class.forName(ifaceName);
            this.ifaceMap.put(ifaceName, iface);
        }
        boolean first = true;
        if (this.ifaceMap.size() > 0) {
            for (Map.Entry<String, Class<?>> entry : this.ifaceMap.entrySet()) {
                if (this.superclass != null && entry.getValue().isAssignableFrom(this.superclass) && !this.options.getDerivingInterfaceNames().contains(entry.getKey())) continue;
                if (!first) {
                    derivingSb.append(", ");
                } else {
                    derivingSb.append("\timplements ");
                    first = false;
                }
                this.checkForImport(entry.getValue());
                derivingSb.append(CodeGenerator.checkEquals(this.options.getSimpleClassName(), entry.getValue()));
            }
        }
        if (!first) {
            derivingSb.append("\n");
        }
    }

    private void generateMethods(StringBuilder methodsSb) {
        HashSet<Method> methodsToImplement = new HashSet<Method>();
        HashSet superClassMethods = new HashSet();
        if (this.superclass != null) {
            Collections.addAll(superClassMethods, this.superclass.getMethods());
            Collections.addAll(superClassMethods, this.superclass.getDeclaredMethods());
            for (Method m : superClassMethods) {
                if (!Modifier.isAbstract(m.getModifiers())) continue;
                methodsToImplement.add(m);
            }
        }
        for (Map.Entry<String, Class<?>> entry : this.ifaceMap.entrySet()) {
            boolean mandatory = this.options.getDerivingInterfaceNames().contains(entry.getKey());
            HashSet ifaceMethods = new HashSet();
            Collections.addAll(ifaceMethods, entry.getValue().getMethods());
            Collections.addAll(ifaceMethods, entry.getValue().getDeclaredMethods());
            for (Method m : ifaceMethods) {
                if (!mandatory && superClassMethods.contains(m)) continue;
                methodsToImplement.add(m);
            }
        }
        for (Method m : methodsToImplement) {
            Type returnType = m.getGenericReturnType();
            StringBuilder returnTypeStringBuilder = new StringBuilder();
            Class<?> returnTypeClass = this.generateTypeClass(returnTypeStringBuilder, this.importSet, returnType);
            this.checkForImport(returnTypeClass);
            methodsSb.append("\t@Override\n\t");
            methodsSb.append(CodeGenerator.generateModifiers(m.getModifiers()));
            methodsSb.append((CharSequence)returnTypeStringBuilder);
            methodsSb.append(" ");
            methodsSb.append(m.getName());
            methodsSb.append("(");
            int count = 1;
            Type[] types = m.getGenericParameterTypes();
            Class<?>[] classTypes = m.getParameterTypes();
            Parameter[] parameters = m.getParameters();
            for (int i = 0; i < types.length; ++i) {
                methodsSb.append(count == 1 ? " " : ", ");
                Type type = types[i] instanceof TypeVariable ? classTypes[i] : types[i];
                Class<?> clazz = this.generateTypeClass(methodsSb, this.importSet, type);
                methodsSb.append(" ");
                Parameter p = parameters[i];
                if (p.isNamePresent()) {
                    methodsSb.append(p.getName());
                } else {
                    methodsSb.append(CodeGenerator.classNameToVariable(clazz.getSimpleName(), count));
                }
                ++count;
            }
            if (count > 1) {
                methodsSb.append(" ");
            }
            methodsSb.append(")\n");
            count = 1;
            for (Class<?> ex : m.getExceptionTypes()) {
                this.checkForImport(ex);
                methodsSb.append(count++ == 1 ? "\t\tthrows " : ", ");
                methodsSb.append(ex.getSimpleName());
            }
            if (count > 1) {
                methodsSb.append("\n");
            }
            methodsSb.append("\t{");
            if (!"void".equals(returnTypeClass.getName())) {
                methodsSb.append("\n\t\treturn ");
                if (returnTypeClass.isPrimitive()) {
                    if ("boolean".equals(returnTypeClass.getName())) {
                        methodsSb.append("false");
                    } else {
                        methodsSb.append("0");
                    }
                } else {
                    methodsSb.append("null");
                }
                methodsSb.append(";");
            }
            methodsSb.append("\n\t}\n\n");
        }
    }

    private static String checkEquals(String newClass, Class<?> clazz) {
        return newClass.equals(clazz.getSimpleName()) ? clazz.getName() : clazz.getSimpleName();
    }

    private static String importsToString(Set<String> importSet) {
        ArrayList<String> imports = new ArrayList<String>(importSet);
        Collections.sort(imports);
        StringBuilder importBuilder = new StringBuilder(imports.size() * 10);
        for (String single : imports) {
            importBuilder.append(single);
            importBuilder.append("\n");
        }
        importBuilder.append("\n");
        return importBuilder.toString();
    }

    private Class<?> generateTypeClass(StringBuilder methodsReplace, Set<String> importSet, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Class clazz = (Class)pType.getRawType();
            methodsReplace.append(clazz.getSimpleName());
            this.checkForImport(clazz);
            Type[] parameterArgTypes = pType.getActualTypeArguments();
            methodsReplace.append("<");
            boolean first = true;
            for (Type parameterArgType : parameterArgTypes) {
                if (!first) {
                    methodsReplace.append(", ");
                }
                this.generateTypeClass(methodsReplace, importSet, parameterArgType);
                first = false;
            }
            methodsReplace.append(">");
            return clazz;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            methodsReplace.append(clazz.getSimpleName());
            this.checkForImport(clazz);
            return clazz;
        }
        return null;
    }

    private static String classNameToVariable(String simpleName, int count) {
        if (Utils.isBlankString((String)simpleName)) {
            return "p" + count;
        }
        return Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1) + count;
    }

    private static String generateModifiers(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return "public ";
        }
        if (Modifier.isProtected(modifiers)) {
            return "protected ";
        }
        return "";
    }

    private void checkForImport(Class<?> clazz) {
        String className = clazz.getName();
        boolean isPrimitive = false;
        Pattern primitiveTypePattern = Pattern.compile("^\\[+[ICJZBDFS]|byte|short|int|long|float|double|boolean|char");
        Matcher matcher = primitiveTypePattern.matcher(className);
        if (matcher.matches()) {
            isPrimitive = true;
        }
        className = className.replaceAll("\\[L|;", "");
        className = className.replace('$', '.');
        if (!(isPrimitive || className.startsWith("java.lang") || className.equals("void"))) {
            this.importSet.add("import " + className + ";");
        }
    }
}

