/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.function.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.ContractPasswordOnce;
import ru.bitel.common.TimeUtils;

public class PasswordManager {
    private Random random;
    private Connection con;
    private static final String TABLE_NAME = "contract_password_once";

    public PasswordManager(Connection con) {
        this.con = con;
    }

    public String findContractTitle(String passwordOnce) throws SQLException {
        String contractTitle = null;
        if (passwordOnce != null) {
            String query = "SELECT contract_title FROM contract_password_once WHERE password=? AND dt>?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, passwordOnce);
                ps.setTimestamp(index++, new Timestamp(System.currentTimeMillis()));
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        contractTitle = resultSet.getString(1);
                    }
                }
            }
        }
        return contractTitle;
    }

    public void addPassword(String contractTitle, long passwordExpireMinute, String password) throws SQLException {
        if (contractTitle != null && password != null) {
            Date now = new Date();
            String query = "INSERT INTO contract_password_once SET dt=?, contract_title=?, password=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setTimestamp(index++, new Timestamp(now.getTime() + passwordExpireMinute * 60000L));
                ps.setString(index++, contractTitle);
                ps.setString(index++, password);
                ps.executeUpdate();
            }
        }
    }

    public void deleteContractTitle(String passwordOnce) throws SQLException {
        if (passwordOnce != null) {
            String query = "DELETE FROM contract_password_once WHERE password=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, passwordOnce);
                ps.executeUpdate();
            }
        }
    }

    public void deleteByContract(String contractTitle) throws SQLException {
        if (contractTitle != null) {
            String query = "DELETE FROM contract_password_once WHERE contract_title=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, contractTitle);
                ps.executeUpdate();
            }
        }
    }

    public ContractPasswordOnce getContractPasswordOnceByContractTitle(String contractTitle) throws SQLException {
        ContractPasswordOnce contractPasswordOnce = null;
        if (contractTitle != null) {
            String query = "SELECT * FROM contract_password_once WHERE contract_title=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setString(index++, contractTitle);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        contractPasswordOnce = this.getFromRs(rs);
                    }
                }
            }
        }
        return contractPasswordOnce;
    }

    public void addVerificationCounter(String contractTitle) throws SQLException {
        String query = "UPDATE contract_password_once SET verification_counter=verification_counter+1 WHERE contract_title=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, contractTitle);
            ps.executeUpdate();
        }
    }

    private ContractPasswordOnce getFromRs(ResultSet rs) throws SQLException {
        return new ContractPasswordOnce().setLastUpdate(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("lu"))).setCreateTime(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("dt"))).setContractTitle(rs.getString("contract_title")).setCode(rs.getString("password")).setVerificationCounter(rs.getInt("verification_counter"));
    }

    public String getOncePassword(int len, String charArray) {
        if (this.random == null) {
            this.random = new Random();
        }
        StringBuilder builder = new StringBuilder();
        int l = charArray.length();
        for (int i = 0; i < len; ++i) {
            builder.append(charArray.charAt(this.random.nextInt(l)));
        }
        return builder.toString();
    }
}

