/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.common.Utils;
import ru.bitel.common.model.GuiTitlable;

public class ContractLabelTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final JCheckBox checkBox = new JCheckBox();
    private final DefaultTreeCellRenderer label = new DefaultTreeCellRenderer();
    private final JLabel id = new JLabel();
    private final JLabel comment = new JLabel();
    private final boolean withCheckBox;
    private final boolean withIdLabels;
    private final boolean isCommentVisible;
    private final Color inactiveColor = UIManager.getColor("TextField.inactiveForeground");
    private final Color activeColor = UIManager.getColor("Tree.foreground");

    public ContractLabelTreeCellRenderer(boolean withCheckBox, boolean withIdLabels, boolean withComment) {
        this.setLayout(new GridBagLayout());
        this.withCheckBox = withCheckBox;
        if (this.withCheckBox) {
            this.add((Component)this.checkBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.isCommentVisible = withComment;
        if (this.isCommentVisible) {
            this.comment.setFont(new Font("Dialog", 0, 11));
            this.add((Component)this.comment, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 40, 0, 0), 0, 0));
        }
        this.withIdLabels = withIdLabels;
        if (this.withIdLabels) {
            this.id.setFont(new Font("Dialog", 0, 11));
            this.add((Component)this.id, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 0, 0), 0, 0));
        }
        this.prepare();
        this.setOpaque(false);
        this.label.setOpenIcon(ClientUtils.getIcon("node.png"));
        this.label.setClosedIcon(ClientUtils.getIcon("node.png"));
        this.label.setLeafIcon(ClientUtils.getIcon("leaf.png"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.prepare();
        this.label.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode contractLabelTreeNode = (DefaultMutableTreeNode)node;
            this.setEnabled(tree.isEnabled());
            boolean visible = !contractLabelTreeNode.isRoot();
            Object userObject = contractLabelTreeNode.getUserObject();
            if (userObject instanceof ContractLabelItem) {
                ContractLabelItem labelItem = (ContractLabelItem)userObject;
                this.id.setText("[#" + labelItem.getId() + "]");
                this.checkBox.setSelected(labelItem.isSelected());
                this.checkBox.setEnabled(!labelItem.isForbiddenEdit());
                this.label.setText(((GuiTitlable)userObject).getGuiTitle());
                this.comment.setText((String)(Utils.notBlankString(labelItem.getComment()) ? "[ " + labelItem.getComment() + " ]" : ""));
                ContractLabelType contractLabelType = labelItem.getContractLabelType();
                if (contractLabelType != null) {
                    boolean bl = visible = contractLabelType.equals((Object)ContractLabelType.GROUP_ITEM) || contractLabelType.equals((Object)ContractLabelType.LABEL_ITEM);
                }
                if (!hasFocus) {
                    this.label.setForeground(labelItem.isForbiddenEdit() ? this.inactiveColor : this.activeColor);
                }
            }
            this.checkBox.setVisible(visible);
        }
        this.invalidate();
        return this;
    }

    private void prepare() {
        Color backgroundColor = UIManager.getColor("Tree.textBackground");
        this.setBackground(backgroundColor);
        this.label.setBackgroundNonSelectionColor(backgroundColor);
        this.label.setBackground(backgroundColor);
        this.checkBox.setBackground(backgroundColor);
    }

    public final DefaultTreeCellRenderer getTreeCellRenderer() {
        return this.label;
    }

    public boolean checkBoxVisibility() {
        return this.withCheckBox;
    }

    public boolean idLabelsVisibility() {
        return this.withIdLabels;
    }

    public boolean isCommentVisible() {
        return this.isCommentVisible;
    }
}

