/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class OptionTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private final Set<Integer> options;
    private final boolean modeOr;

    public OptionTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.options = new HashSet<Integer>(Utils.toIntegerList(parameterMap.get("options", "")));
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (this.options.size() == 0) {
            Set<Long> acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        ContractTariffOptionList options = ctx.getContractTariffOptionList(req.getConnectionSet(), req.contractId);
        if (options == null) {
            return 0;
        }
        if (this.modeOr ? !options.contains(TimeUtils.convertCalendarToDate(req.getTime()).getTime(), this.options) : !options.containsAll(TimeUtils.convertCalendarToDate(req.getTime()), this.options)) {
            return 0;
        }
        Set<Long> acceptedSet = req.getAcceptedSet(OptionTariffTreeNode.class);
        acceptedSet.add(parentTreeNodeId);
        return 1;
    }
}

