/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.bgsecure.ActionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.client.ContractParameterTableModel;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.PermissionKitItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.event.PermissionKitUpdateEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;

public class PermissionKitPanel
extends BGUPanel {
    private static final String TABLE_PANEL = "tablePanel";
    private static final String EDITOR_PANEL = "editorPanel";
    private KitTableModel tableModel;
    private KitEditor kitEditor;
    private final RoleService roleService;

    public PermissionKitPanel(RoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    protected void jbInit() throws Exception {
        this.kitEditor = new KitEditor();
        this.setLayout(new GridBagLayout());
        this.tableModel = new KitTableModel();
        BGUTable kitTable = new BGUTable(this.tableModel);
        kitTable.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)kitTable, this, "edit");
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 3, 3);
        this.add((Component)new JScrollPane(kitTable), constraints);
        this.add((Component)this.kitEditor, constraints);
        this.switchVisiblePanel(TABLE_PANEL);
    }

    private void switchVisiblePanel(String panel) {
        this.kitEditor.setVisible(EDITOR_PANEL.equals(panel));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.tableModel != null) {
                this.tableModel.setData(this.roleService.getPermissionKitItems());
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> this.kitEditor.openEditor(null));
        new AbstractBGUPanel.BGActionEdit(e -> this.tableModel.optSelectedRow().ifPresent(kit -> this.tryCall(() -> Optional.ofNullable(this.roleService.getByKitId(kit.getId())).ifPresent(pk -> this.kitEditor.openEditor((PermissionKit)pk)))));
        new AbstractBGUPanel.BGActionDelete(e -> {
            PermissionKitItem selectedKit = (PermissionKitItem)this.tableModel.getSelectedRow();
            if (selectedKit != null && ClientUtils.confirmDelete(selectedKit.getTitle())) {
                int rolesContainsThisKit = this.roleService.checkRoleContainsKit(selectedKit.getId());
                if (rolesContainsThisKit > 0 && !ClientUtils.confirm("\u0414\u0430\u043d\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0440\u043e\u043b\u044f\u0445 [" + rolesContainsThisKit + "]. \u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0433\u043e \u043d\u0430\u0431\u043e\u0440\u0430")) {
                    return;
                }
                this.roleService.deletePermissionKit(selectedKit.getId());
                this.performAction("refresh");
                EventBus.publish((Object)new PermissionKitUpdateEvent(selectedKit.getId(), 0, PermissionKitUpdateEvent.EventType.DELETE));
            }
        });
    }

    private final class KitEditor
    extends JPanel {
        JTextField title = new JTextField();
        JTextArea description = new JTextArea();
        ActionsPanel actionsPanel = new ActionsPanel();
        JPanel actionGroupPanel;
        BGControlPanelListSelect listGroupActions;
        ContractParameterTableModel objectParameterTableModel;
        ContractParameterTableModel contractParameterTableModel;
        ContractLabelTree contractLabelTree;
        BGUCheckTree<Domain> domains;
        List<BGSActionGroup> bgsActionGroups;
        JComboBox<String> cellEditorComboBox = new JComboBox();
        DefaultCellEditor cellEditor = new DefaultCellEditor(this.cellEditorComboBox){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                KitEditor.this.cellEditorComboBox.setSelectedIndex(Utils.parseInt(String.valueOf(value)));
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }

            @Override
            public Object getCellEditorValue() {
                return KitEditor.this.cellEditorComboBox.getSelectedIndex();
            }
        };
        private PermissionKit currentKit;
        private final Async<Void> editorAsyncLoader;

        KitEditor() {
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0439");
            this.editorAsyncLoader = Async.of(this::initAsync).thenAccept(t -> this.init());
        }

        private void initAsync() throws Exception {
            this.actionsPanel.init(((ClientContext)PermissionKitPanel.this.getContext()).getModule(), 0);
            this.actionsPanel.setData();
            this.objectParameterTableModel = new ContractParameterTableModel("userObjectParameterAccess");
            this.contractParameterTableModel = new ContractParameterTableModel("userContractParameterAccess");
            this.contractLabelTree = new ContractLabelTree();
            this.contractLabelTree.loadLabels(((ClientContext)PermissionKitPanel.this.getContext()).getPort(ContractLabelService.class, 0));
        }

        private void init() throws Exception {
            this.actionsPanel.repaintTree();
            this.actionGroupPanel = this.getActionGroupPanel();
            this.loadDomainTree();
            Domain root = ((ClientContext)PermissionKitPanel.this.getContext()).getPort(DomainService.class, 0).domainTree();
            if (root != null) {
                root.setTitle("\u0414\u043e\u043c\u0435\u043d\u044b");
            }
            this.domains.setData(root);
            this.domains.expand();
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.getButtonOk().addActionListener(e -> this.save());
            okCancel.getButton("cancel").addActionListener(e -> PermissionKitPanel.this.switchVisiblePanel(PermissionKitPanel.TABLE_PANEL));
            this.add((Component)this.getGeneralPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)this.getTabbedPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)okCancel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
            this.loadTableData();
        }

        private JPanel getGeneralPanel() {
            this.description.setLineWrap(true);
            this.description.setMargin(new Insets(3, 3, 3, 3));
            Dimension dimension = new Dimension(400, 150);
            JScrollPane descriptionScroll = new JScrollPane(this.description);
            descriptionScroll.setPreferredSize(dimension);
            descriptionScroll.setMinimumSize(dimension);
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430"), constraints);
            panel.add((Component)this.title, constraints);
            panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430"), constraints);
            panel.add((Component)descriptionScroll, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
            return panel;
        }

        private JPanel getTabbedPanel() {
            this.cellEditorComboBox.setModel(new DefaultComboBoxModel<String>(this.contractParameterTableModel.getUserEditerItems()));
            BGUTable contractParameterTable = new BGUTable(this.contractParameterTableModel);
            contractParameterTable.setSelectionMode(0);
            contractParameterTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
            contractParameterTable.getColumnModel().getColumn(2).setCellEditor(this.cellEditor);
            BGUTable objectParameterTable = new BGUTable(this.objectParameterTableModel);
            objectParameterTable.setSelectionMode(0);
            objectParameterTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
            objectParameterTable.getColumnModel().getColumn(2).setCellEditor(this.cellEditor);
            JTabbedPane tabbedPanel = new JTabbedPane();
            tabbedPanel.add((Component)this.actionsPanel, "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
            tabbedPanel.add((Component)this.actionGroupPanel, "\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
            tabbedPanel.add((Component)new JScrollPane(contractParameterTable), "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            tabbedPanel.add((Component)new JScrollPane(objectParameterTable), "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
            tabbedPanel.add((Component)new JScrollPane(this.contractLabelTree), "\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            tabbedPanel.add((Component)new JScrollPane(this.domains), "\u0414\u043e\u043c\u0435\u043d\u044b");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u043d\u0430 \u0432\u043a\u043b\u0430\u0434\u043a\u0430\u0445 \u043d\u0438\u0436\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
            panel.add((Component)tabbedPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 3), 0, 0));
            return panel;
        }

        void openEditor(PermissionKit kit) {
            this.editorAsyncLoader.get();
            this.currentKit = kit;
            if (this.currentKit == null) {
                this.currentKit = new PermissionKit();
            }
            if (kit == null) {
                this.title.setText("");
                this.description.setText("");
                this.contractLabelTree.setSelectedIds(Collections.emptyList());
                this.domains.setChecked(new HashSet<Integer>());
                this.actionsPanel.setSelectedActions(Collections.emptyList());
                this.contractParameterTableModel.setValues(Collections.emptyList());
                this.objectParameterTableModel.setValues(Collections.emptyList());
                this.listGroupActions.setListValues("");
            } else {
                this.title.setText(this.currentKit.getTitle());
                this.description.setText(this.currentKit.getDescription());
                this.contractLabelTree.setSelectedIds(this.currentKit.getContractLabels());
                this.domains.setChecked(new HashSet<Integer>(this.currentKit.getDomenIds()));
                this.actionsPanel.setSelectedActions(this.currentKit.getActions());
                this.contractParameterTableModel.setValues(this.currentKit.getPids());
                this.objectParameterTableModel.setValues(this.currentKit.getContractObjects());
                this.listGroupActions.setListValues(Utils.toString(this.currentKit.getActionGroups().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList())));
            }
            PermissionKitPanel.this.switchVisiblePanel(PermissionKitPanel.EDITOR_PANEL);
        }

        void save() {
            if (this.currentKit == null) {
                this.currentKit = new PermissionKit();
            }
            if (Utils.isBlankString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0438\u043c\u044f \u043d\u0430\u0431\u043e\u0440\u0430!");
                return;
            }
            this.currentKit.setTitle(this.title.getText());
            this.currentKit.setDescription(this.description.getText());
            this.currentKit.setContractLabels(this.contractLabelTree.getSelectedIds());
            this.currentKit.setDomenIds(new ArrayList<Integer>(this.domains.getChecked()));
            this.currentKit.setActions(this.actionsPanel.getSelectedActions());
            this.currentKit.setContractObjects(Utils.toList(this.objectParameterTableModel.getValues()));
            this.currentKit.setPids(Utils.toList(this.contractParameterTableModel.getValues()));
            List<Integer> items = Utils.toIntegerList(this.listGroupActions.getListValues());
            ArrayList<BGSActionGroup> selectedGroups = new ArrayList<BGSActionGroup>();
            for (Integer groupId : items) {
                for (BGSActionGroup group : this.bgsActionGroups) {
                    if (groupId.intValue() != group.getId()) continue;
                    selectedGroups.add(group);
                }
            }
            this.currentKit.setActionGroups(selectedGroups);
            PermissionKitPanel.this.tryCall(() -> this.currentKit.setId(PermissionKitPanel.this.roleService.updatePermissionKit(this.currentKit)));
            PermissionKitPanel.this.performAction("refresh");
            EventBus.publish((Object)new PermissionKitUpdateEvent(this.currentKit.getId(), 0, PermissionKitUpdateEvent.EventType.UPDATE));
            PermissionKitPanel.this.switchVisiblePanel(PermissionKitPanel.TABLE_PANEL);
        }

        private void loadDomainTree() {
            this.domains = new BGUCheckTree<Domain>(new BGCheckTreeModel<Domain>("domains", Domain.class){
                private final Icon folder;
                private final Icon leaf;
                {
                    this.folder = ClientUtils.getIcon("fugue/tree");
                    this.leaf = ClientUtils.getIcon("fugue/leaf");
                }

                @Override
                public Icon getIcon(Domain value) {
                    return this.isLeaf(value) ? this.leaf : this.folder;
                }
            });
        }

        private void loadTableData() {
            Async.of(() -> PermissionKitPanel.this.tryCall(() -> {
                JSONObject parameters = ((ClientContext)PermissionKitPanel.this.getContext()).getPort(UserService.class).contractParameters(0);
                this.contractParameterTableModel.setDefault(Utils.parseInteger(parameters.getString("userDefaultRead"), 1), Utils.parseInteger(parameters.getString("userDefaultWrite"), 1));
                this.contractParameterTableModel.setData(parameters.getJSONArray("contractParameters"));
            }));
            Async.of(() -> {
                Document doc = TransferManager.getDocument(new Request().setModule("contract.object").setAction("ParamTable"));
                if (ClientUtils.checkStatus(doc)) {
                    PermissionKitPanel.this.tryCall(() -> {
                        Element tableElement = XMLUtils.selectElement(doc, "//table");
                        this.objectParameterTableModel.setDefault(Utils.parseInteger(tableElement.getAttribute("groupDefaultRead"), 1), Utils.parseInteger(tableElement.getAttribute("groupDefaultWrite"), 1));
                        this.objectParameterTableModel.setData(XMLUtils.selectElements(tableElement, "data/row"));
                    });
                }
            });
        }

        private JPanel getActionGroupPanel() throws Exception {
            JPanel panel = new JPanel(new GridBagLayout());
            this.listGroupActions = new BGControlPanelListSelect();
            this.bgsActionGroups = PermissionKitPanel.this.roleService.getBGSActionGroups();
            ClientUtils.buildList(this.listGroupActions.getList(), this.bgsActionGroups);
            panel.add((Component)this.listGroupActions, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }
    }

    public final class KitTableModel
    extends BGTableModel<PermissionKitItem> {
        public KitTableModel() {
            super(KitTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 500, 800, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0439", 120, 120, 120, "actionCount", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0413\u0440\u0443\u043f\u043f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439", 120, 120, 120, "actionGroupCount", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0412 \u0440\u043e\u043b\u044f\u0445", 120, 120, 120, "roleCount", true, DecimalTableCellRenderer.INTEGER());
        }
    }
}

