/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import jakarta.xml.ws.Holder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScriptLog;
import ru.bitel.bgbilling.kernel.contract.script.common.service.ContractScriptService;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLog;
import ru.bitel.bgbilling.kernel.script.common.service.GlobalScriptService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;

public class ContractScriptLogPanel
extends BGUPanel {
    private BGTableModel<GlobalScriptLog> model;
    private BGUTable table;
    private JPanel tablePanel;
    private JPanel editorPanel;
    private JSplitPane splitPane;
    private JTextArea memo;
    private BGControlPanelMonthAndDays periodPanel;
    private BGUComboBox<IdTitle> comboBox;
    private BGControlPanelPages pagePanel;
    private JLabel totalLabel;
    private BGButton close;
    private String lastSelectTypeItem;
    private Pattern line;
    private IdTitle defaultItem;
    private boolean globalLog;

    public ContractScriptLogPanel(boolean isGlobalLog) {
        this.table = new BGUTable(this.model);
        this.tablePanel = new JPanel(new GridBagLayout());
        this.editorPanel = new JPanel(new GridBagLayout());
        this.splitPane = new BGSplitPane(0, new JScrollPane(this.table), this.editorPanel);
        this.memo = new JTextArea();
        this.periodPanel = new BGControlPanelMonthAndDays(true);
        this.comboBox = new BGUComboBox();
        this.pagePanel = new BGControlPanelPages();
        this.totalLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439:");
        this.close = new BGButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        this.line = Pattern.compile("u000A", 8);
        this.defaultItem = new IdTitle(-1, "-- \u0412\u0441\u0435 --");
        this.globalLog = isGlobalLog;
        this.model = new BGTableModel<GlobalScriptLog>("\u041b\u043e\u0433\u0438 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432"){

            @Override
            protected void initColumns() {
                this.addColumn("\u0414\u0430\u0442\u0430", -1, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            }
        };
        this.table.setModel(this.model);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractScriptLogPanel.this.editItem();
                }
            }
        });
        this.editorPanel.setVisible(false);
    }

    @Override
    protected void jbInit() throws Exception {
        this.periodPanel.setDate(LocalDate.now());
        JPanel filterPanel = new JPanel(new GridBagLayout());
        this.comboBox.setPreferredSize(new Dimension(200, this.comboBox.getPreferredSize().height));
        filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        filterPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add(this.comboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 5), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 10, new Insets(0, 10, 5, 5), 0, 0));
        filterPanel.add((Component)this.totalLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 1), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 0), 0, 0));
        JScrollPane memoScroll = new JScrollPane(this.memo);
        memoScroll.setMinimumSize(new Dimension(0, 180));
        this.memo.setEditable(false);
        this.editorPanel.add((Component)memoScroll, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.editorPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.editorPanel.add((Component)this.close, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.editorPanel.setMinimumSize(new Dimension(this.editorPanel.getMinimumSize().getSize().width, 70));
        this.splitPane.setDividerSize(0);
        this.tablePanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.tablePanel.add((Component)this.splitPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.close.addActionListener(e -> {
            this.editorPanel.setVisible(false);
            this.splitPane.setDividerSize(0);
            this.splitPane.setDividerLocation(1.0);
            this.splitPane.revalidate();
        });
        this.periodPanel.addActionListener(e -> this.performAction("refresh"));
        this.pagePanel.setKey(this.getClass().getName());
        this.pagePanel.addPropertyChangeListener(e -> this.performAction("refresh"));
        this.comboBox.addActionListener(e -> {
            if (this.comboBox.isFocusOwner() && this.comboBox.getSelectedIndex() > -1) {
                this.lastSelectTypeItem = ((IdTitle)this.comboBox.getSelectedItem()).getTitle();
            }
            this.setDataTable();
        });
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.globalLog) {
                this.buildComboBox(((ClientContext)this.getContext()).getPort(GlobalScriptService.class).getScriptLogTitleList(this.periodPanel.getPeriod()));
            } else {
                this.buildComboBox(((ClientContext)this.getContext()).getPort(ContractScriptService.class).getScriptLogTitleList(((ClientContext)this.getContext()).getContractId() != 0 ? ((ClientContext)this.getContext()).getContractId() : -1, this.periodPanel.getPeriod()));
            }
            this.setDataTable();
        });
    }

    public void setDataTable() {
        try {
            String title = this.comboBox.getSelectedItem() == null || ((IdTitle)this.comboBox.getSelectedItem()).getId() < 1 ? null : ((IdTitle)this.comboBox.getSelectedItem()).getTitle();
            Holder pageHolder = new Holder((Object)this.pagePanel.getPage());
            pageHolder.value = this.pagePanel.getPage();
            if (this.globalLog) {
                this.model.setData(((ClientContext)this.getContext()).getPort(GlobalScriptService.class).getGlobalScriptLogList(this.periodPanel.getPeriod(), title, (Holder<Page>)pageHolder));
            } else {
                ArrayList<ContractScriptLog> list = new ArrayList<ContractScriptLog>(((ClientContext)this.getContext()).getPort(ContractScriptService.class).getScriptLogList(((ClientContext)this.getContext()).getContractId() != 0 ? ((ClientContext)this.getContext()).getContractId() : -1, this.periodPanel.getPeriod(), title, (Holder<Page>)pageHolder));
                this.model.setData(list);
            }
            this.pagePanel.setPage((Page)pageHolder.value);
            this.totalLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + ((Page)pageHolder.value).getRecordCount());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    public void editItem() {
        GlobalScriptLog scriptLog = this.model.getSelectedRow();
        if (scriptLog != null && scriptLog.getData() != null) {
            this.memo.setText(this.line.matcher(scriptLog.getData()).replaceAll("\n"));
            if (!this.editorPanel.isVisible()) {
                this.splitPane.setDividerSize(7);
                this.editorPanel.setVisible(true);
                this.splitPane.setDividerLocation(0.7);
                this.splitPane.revalidate();
            }
        }
    }

    private void buildComboBox(List<String> listTitle) {
        int index = 1;
        int selectIndex = 0;
        ArrayList<IdTitle> data = new ArrayList<IdTitle>();
        data.add(this.defaultItem);
        for (String title : listTitle) {
            data.add(new IdTitle(index++, title));
            if (this.lastSelectTypeItem == null || !this.lastSelectTypeItem.equals(title)) continue;
            selectIndex = index - 1;
        }
        this.comboBox.setData(data);
        this.comboBox.setSelectedIndex(selectIndex);
    }
}

