/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import bitel.billing.module.tariff.TariffTreeEditor;
import bitel.billing.module.tariff.TariffTreeRenderer;
import bitel.billing.module.tariff.directory.DirectoriesManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.TreesManager;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.FlushableRootTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.ModuleRootTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class TariffTree {
    public static final int TARIFF_MODE = 1;
    public static final int CONTRACT_MODE = 2;
    private int treeId = -1;
    private ClientSetup _setup = ClientSetup.getInstance();
    private TransferData TD;
    private JScrollPane treeScroll;
    private JTree viewableTree;
    private DefaultMutableTreeNode _viewableRootNode;
    private JPanel viewablePanel = new JPanel(new GridBagLayout());
    private DefaultMutableTreeNode findContext;
    private String findText;
    private static final int CUT_MODE = 1;
    private static final int COPY_MODE = 2;
    private int bufferMode = 1;
    private int bufferMtree = -1;
    private TariffTreeNode _bufferValue;
    private BGComboBox<ComboBoxItem> module_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> parentTree_CB = new BGComboBox();
    private boolean needFlush;
    protected Component parent;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private JComponent treeScrollPanel;

    public TariffTree() {
        this.initTopPanel();
    }

    public void checkNeedFlush() {
        boolean needFlush = false;
        int count = this._viewableRootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode node = this._viewableRootNode.getChildAt(i);
            if (node instanceof DefaultMutableTreeNode) {
                Object o = ((DefaultMutableTreeNode)node).getUserObject();
                if (!(o instanceof FlushableRootTariffTreeNode) || !((FlushableRootTariffTreeNode)o).isNeedFlush()) continue;
                needFlush = true;
                break;
            }
            if (!(node instanceof FlushableRootTariffTreeNode) || !((FlushableRootTariffTreeNode)((Object)node)).isNeedFlush()) continue;
            needFlush = true;
            break;
        }
        if (needFlush == this.needFlush) {
            return;
        }
        boolean oldValue = this.needFlush;
        this.needFlush = needFlush;
        this.pcs.firePropertyChange("needFlush", oldValue, needFlush);
    }

    public void flush() {
        int count = this._viewableRootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeNode node = this._viewableRootNode.getChildAt(i);
            if (node instanceof DefaultMutableTreeNode) {
                Object o = ((DefaultMutableTreeNode)node).getUserObject();
                if (!(o instanceof FlushableRootTariffTreeNode) || !((FlushableRootTariffTreeNode)o).isNeedFlush()) continue;
                ((FlushableRootTariffTreeNode)o).flush();
                continue;
            }
            if (!(node instanceof FlushableRootTariffTreeNode) || !((FlushableRootTariffTreeNode)((Object)node)).isNeedFlush()) continue;
            ((FlushableRootTariffTreeNode)((Object)node)).flush();
        }
        boolean oldValue = this.needFlush;
        this.needFlush = false;
        this.pcs.firePropertyChange("needFlush", oldValue, false);
    }

    public boolean isNeedFlush() {
        return this.needFlush;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void init(Component parent, int id) {
        this.needFlush = false;
        this.parent = parent;
        this.treeId = id;
        DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
        this.TD = dbInfo != null ? dbInfo.getTransferData() : null;
        Element info = this.getTreeInfo(id);
        Object ref = info.getAttribute("ref");
        int parent_tree = Utils.parseInt(info.getAttribute("parent"), 0);
        if (parent_tree > 0) {
            Element parent_info = this.getTreeInfo(parent_tree);
            String parent_ref = parent_info.getAttribute("ref");
            ref = (String)ref + "[" + parent_ref + "]";
        }
        this._viewableRootNode = new DefaultMutableTreeNode(new JLabel((String)ref));
        this.viewableTree = new JTree(this._viewableRootNode);
        this.initViewPanel();
        this.initTreeAndListeners();
        this.initManagerCombos();
        parent.repaint();
    }

    private void initTreeAndListeners() {
        TariffTreeRenderer render = new TariffTreeRenderer();
        this.viewableTree.setCellRenderer(render);
        this.viewableTree.setCellEditor(new TariffTreeEditor());
        this.viewableTree.setEditable(true);
        this.loadModules();
        this.viewableTree.expandPath(new TreePath(this._viewableRootNode.getPath()));
        this.viewableTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    TariffTree.this.viewableTree.setSelectionPath(TariffTree.this.viewableTree.getPathForLocation(e.getX(), e.getY()));
                    TariffTree.this.showRightClickMenu(e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    TariffTree.this.enterEdit(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TariffTree.this.viewableTree.isEditing()) {
                    TariffTree.this.updateTree();
                }
            }
        });
        this.viewableTree.addTreeExpansionListener(new TreeExpansionListener(this){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                if (expandedNode.getUserObject() instanceof TariffTreeNode) {
                    ((TariffTreeNode)expandedNode.getUserObject()).loadChilds();
                }
            }
        });
        this.viewableTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73) {
                    TariffTreeNode node = TariffTree.this.getSelectedNode();
                    String message = "tree => " + TariffTree.this.treeId + "; mtree => " + node.getMTreeId() + "; node => " + node.getId();
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), message);
                }
            }
        });
    }

    private void initViewPanel() {
        if (this.treeScroll != null && this.treeScrollPanel != null) {
            this.viewablePanel.remove(this.treeScrollPanel);
        }
        this.viewableTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.treeScroll = new JScrollPane(this.viewableTree);
        this.treeScrollPanel = BGSwingUtilites.wrapBorder(this.treeScroll, "\u0414\u0435\u0440\u0435\u0432\u043e \u0442\u0430\u0440\u0438\u0444\u0430");
        this.viewablePanel.add((Component)this.treeScrollPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initTopPanel() {
        JPanel treeControlPanel = new JPanel(new GridBagLayout());
        JPanel searchPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder(treeControlPanel, "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u044c\u044f\u043c\u0438");
        BGSwingUtilites.wrapBorder(searchPanel, "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u0434\u0435\u0440\u0435\u0432\u0443 \u0442\u0430\u0440\u0438\u0444\u0430");
        this.viewablePanel.add((Component)treeControlPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        this.viewablePanel.add((Component)searchPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        BGTextField findText = new BGTextField();
        JButton findButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        findButton.setMargin(new Insets(2, 2, 2, 2));
        JButton findNext = new JButton("\u041d\u0430\u0439\u0442\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0435");
        findNext.setMargin(new Insets(2, 2, 2, 2));
        searchPanel.add((Component)findText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        searchPanel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        searchPanel.add((Component)findNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        ActionListener findF = e -> {
            this.findContext = this._viewableRootNode;
            this.resetFind(this._viewableRootNode);
            this.findText = findText.getText().toLowerCase();
            this.findText();
            this.updateTree();
        };
        findButton.addActionListener(findF);
        findText.addActionListener(findF);
        findNext.addActionListener(e -> {
            this.findText();
            this.updateTree();
        });
        JButton createButton = new JButton();
        createButton.setToolTipText("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e");
        createButton.setIcon(ClientUtils.getIcon("fugue/document.png"));
        createButton.setMargin(new Insets(2, 2, 2, 2));
        createButton.addActionListener(e -> this.createSubTree("0"));
        JButton deleteButton = new JButton();
        deleteButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e");
        deleteButton.setIcon(ClientUtils.getIcon("cancel"));
        deleteButton.setMargin(new Insets(2, 2, 2, 2));
        deleteButton.addActionListener(e -> this.deleteSubTree());
        JButton extendButton = new JButton();
        extendButton.setToolTipText("\u0420\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e");
        extendButton.setIcon(ClientUtils.getIcon("override"));
        extendButton.setMargin(new Insets(2, 2, 2, 2));
        extendButton.addActionListener(e -> {
            String parentTree = ClientUtils.getIdFromComboBox(this.parentTree_CB);
            if (parentTree == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444-\u043f\u0440\u0435\u0434\u043e\u043a!");
                return;
            }
            this.createSubTree(parentTree);
        });
        treeControlPanel.add(this.module_CB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        treeControlPanel.add((Component)createButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        treeControlPanel.add((Component)deleteButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        treeControlPanel.add(this.parentTree_CB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        treeControlPanel.add((Component)extendButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.module_CB.addActionListener(e -> this.moduleChanged());
    }

    private void initManagerCombos() {
        Request req = new Request();
        req.setModule("tariff");
        req.setAction("TariffModulesList");
        Document doc = this.sendRequestAndGetDoc(req);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildComboBox(this.module_CB, XMLUtils.getElement(doc, "list"), "");
        }
        this.moduleChanged();
    }

    private void deleteSubTree() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430", 0) != 0) {
            return;
        }
        String moduleId = ClientUtils.getIdFromComboBox(this.module_CB);
        if (Utils.isBlankString(moduleId)) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c!");
            return;
        }
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("DeleteMtree");
        request.setAttribute("tree", this.treeId);
        request.setModuleId(moduleId);
        ClientUtils.checkStatus(this.sendRequestAndGetDoc(request));
        this.loadModules();
    }

    private void createSubTree(String parentTree) {
        if (parentTree.equals("0") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f?", "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430", 0) != 0) {
            return;
        }
        if (!parentTree.equals("0") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0420\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u043e \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f?", "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430", 0) != 0) {
            return;
        }
        String moduleId = ClientUtils.getIdFromComboBox(this.module_CB);
        if (Utils.isBlankString(moduleId)) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c!");
            return;
        }
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("CreateMtree");
        request.setAttribute("tree", this.treeId);
        request.setModuleId(moduleId);
        request.setAttribute("parent_tree", parentTree);
        if (ClientUtils.checkStatus(this.sendRequestAndGetDoc(request))) {
            this.loadModules(Utils.parseInt(moduleId, -1));
            this.viewableTree.expandPath(new TreePath(this._viewableRootNode.getPath()));
        }
    }

    private void moduleChanged() {
        String moduleId = ClientUtils.getIdFromComboBox(this.module_CB);
        if (moduleId != null) {
            Request req = new Request();
            req.setModule("tariff");
            req.setAction("TreesWithModuleList");
            req.setModuleId(moduleId);
            Document doc = this.sendRequestAndGetDoc(req);
            if (ClientUtils.checkStatus(doc)) {
                ClientUtils.buildComboBox(this.parentTree_CB, XMLUtils.getElement(doc, "list"), "");
            }
            ClientUtils.removeFromComboBox(this.parentTree_CB, String.valueOf(this.treeId));
        }
    }

    private void nextFindContextNode() {
        if (this.findContext.getChildCount() > 0) {
            this.findContext = (DefaultMutableTreeNode)this.findContext.getFirstChild();
        } else {
            DefaultMutableTreeNode parent;
            for (parent = this.findContext; parent != this._viewableRootNode; parent = (DefaultMutableTreeNode)parent.getParent()) {
                DefaultMutableTreeNode nextAfterParent = parent.getNextSibling();
                if (nextAfterParent == null) continue;
                this.findContext = nextAfterParent;
                break;
            }
            if (parent == this._viewableRootNode) {
                this.findContext = null;
            }
        }
    }

    private void findText() {
        boolean cont = true;
        while (cont && this.findContext != null) {
            Object userObj = this.findContext.getUserObject();
            if (userObj instanceof TariffTreeNode) {
                TariffTreeNode ttn = (TariffTreeNode)userObj;
                ttn.loadChilds();
                try {
                    Component view = ttn.getView();
                    if (!(view instanceof JLabel)) continue;
                    String labelTxt = ((JLabel)view).getText();
                    if (labelTxt.toLowerCase().indexOf(this.findText) >= 0) {
                        ttn.setFind(true);
                        TreePath path = new TreePath(this.findContext.getPath());
                        this.viewableTree.expandPath(path);
                        this.viewableTree.scrollPathToVisible(path);
                        this.nextFindContextNode();
                        cont = false;
                        continue;
                    }
                    ttn.setFind(false);
                    this.nextFindContextNode();
                    cont = true;
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                continue;
            }
            this.nextFindContextNode();
            cont = true;
        }
    }

    private void resetFind(DefaultMutableTreeNode contextNode) {
        int childsCount = contextNode.getChildCount();
        for (int i = 0; i < childsCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)contextNode.getChildAt(i);
            this.resetFind(child);
        }
        TreePath path = new TreePath(contextNode.getPath());
        this.viewableTree.collapsePath(path);
        Object userObj = contextNode.getUserObject();
        if (userObj instanceof TariffTreeNode) {
            ((TariffTreeNode)userObj).setFind(false);
        }
    }

    private void loadModules() {
        this.loadModules(-1);
    }

    private void loadModules(int changedModuleId) {
        Request request = new Request();
        request.setModule("service");
        request.setAction("Modules");
        try {
            this._viewableRootNode.removeAllChildren();
            this.TD.postData(request);
            Document doc = this.TD.getDocument();
            for (Element item : XMLUtils.selectElements(doc.getDocumentElement(), "/data/modules/module")) {
                int mid = Integer.parseInt(item.getAttribute("id"));
                TreeData data = this.getTreeData(mid);
                if (data == null) continue;
                String name = item.getAttribute("name");
                Object title = item.getAttribute("title");
                ModuleTariffConfig mtc = TreesManager.getTreesManager(this.TD, this._setup).getConfig(name);
                if (mtc == null) continue;
                DirectoriesManager dm = new DirectoriesManager(mtc, mid);
                try {
                    Element info;
                    String ref;
                    int mtree = data.getId();
                    TariffTreeNode rootNode = mtc.getRootNode(mtree, data.getElementMap(), this);
                    rootNode.setDirManager(dm);
                    if (changedModuleId == mid && rootNode instanceof FlushableRootTariffTreeNode) {
                        ((FlushableRootTariffTreeNode)rootNode).markNeedFlush();
                    }
                    if (Utils.notBlankString(ref = (info = this.getMtreeInfo(mtree)).getAttribute("ref"))) {
                        title = (String)title + " [" + ref + "]";
                    }
                    ((ModuleRootTariffTreeNode)rootNode).setModuleId(mid);
                    ((ModuleRootTariffTreeNode)rootNode).setModuleTitle((String)title);
                    rootNode.setEditable(false);
                    rootNode.loadChilds();
                    this._viewableRootNode.add(rootNode.getViewableTreeNode());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            this.updateTree();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private TreeData getTreeData(int moduleId) {
        TreeData treeData = null;
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("GetMtree");
        request.setAttribute("tree_id", String.valueOf(this.treeId));
        request.setAttribute("mid", String.valueOf(moduleId));
        try {
            this.TD.postData(request);
            Document doc = this.TD.getDocument();
            int id = Utils.parseInt(doc.getDocumentElement().getAttribute("id"), 0);
            if (id > 0) {
                treeData = new TreeData(this);
                treeData.setId(id);
                treeData.setModuleId(moduleId);
                Map<Integer, List<Element>> elementMap = treeData.getElementMap();
                for (Element item : XMLUtils.selectElements(doc.getDocumentElement(), "/data/item")) {
                    Integer parent = Integer.valueOf(item.getAttribute("parent"));
                    List<Element> childs = elementMap.get(parent);
                    if (childs == null) {
                        childs = new ArrayList<Element>();
                    }
                    elementMap.put(parent, childs);
                    childs.add(item);
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return treeData;
    }

    public void updateTree() {
        this.viewableTree.updateUI();
        this.viewableTree.repaint();
    }

    public int createNode(int m_tree, String type, int parent) {
        int code = -1;
        Request request = new Request().setModule("tariff").setAction("ModifTariffNode").setAttribute("command", "create").setAttribute("mtree_id", String.valueOf(m_tree)).setAttribute("type", type).setAttribute("parent", String.valueOf(parent));
        try {
            this.TD.postData(request);
            Document doc = this.TD.getDocument();
            code = Integer.parseInt(doc.getDocumentElement().getAttribute("id"));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return code;
    }

    public void deleteNode(int id) {
        Request request = this.getRequest();
        request.setAttribute("command", "delete");
        request.setAttribute("id", String.valueOf(id));
        this.sendRequestAndGetDoc(request);
    }

    public void updateNode(int id, String data) {
        Request request = this.getRequest();
        request.setAttribute("command", "update");
        request.setAttribute("id", String.valueOf(id));
        request.setAttribute("data", data);
        this.sendRequestAndGetDoc(request);
    }

    public void setNodePos(int id, int pos) {
        Request req = this.getRequest();
        req.setAttribute("command", "setpos");
        req.setAttribute("id", String.valueOf(id));
        req.setAttribute("pos", String.valueOf(pos));
        this.sendRequestAndGetDoc(req);
    }

    public void changePos(int id1, int id2) {
        Request req = this.getRequest();
        req.setAttribute("command", "changepos");
        req.setAttribute("id", String.valueOf(id1));
        req.setAttribute("id2", String.valueOf(id2));
        this.sendRequestAndGetDoc(req);
    }

    public void mtreeChanged(int mtreeId) {
        Request req = this.getRequest();
        req.setAction("MtreeModified");
        req.setAttribute("mtreeId", mtreeId);
        this.sendRequestAndGetDoc(req);
    }

    public void cutNode(int mtreeID, TariffTreeNode node) {
        this.bufferMode = 1;
        this.addToBuffer(mtreeID, node);
    }

    public void copyNode(int mtreeID, TariffTreeNode node) {
        this.bufferMode = 2;
        this.addToBuffer(mtreeID, node);
    }

    private void addToBuffer(int mtreeID, TariffTreeNode node) {
        this.bufferMtree = mtreeID;
        this._bufferValue = node;
    }

    public boolean canPaste(int mtreeID, TariffTreeNode node) {
        boolean result = false;
        if (this._bufferValue != null && this.bufferMtree == mtreeID) {
            ModuleTariffConfig mtc = node.getModuleTreeConfig();
            Map<String, String> avaliableChilds = mtc.getType_TitleChilds(node.getType());
            result = avaliableChilds.keySet().contains(this._bufferValue.getType());
        }
        return result;
    }

    public void pasteNode(int mtreeID, TariffTreeNode node) {
        if (this._bufferValue != null && this.bufferMtree == mtreeID) {
            if (this.bufferMode == 1) {
                Request req = this.getRequest();
                req.setAttribute("command", "change_parent");
                req.setAttribute("id", String.valueOf(this._bufferValue.getId()));
                req.setAttribute("value", String.valueOf(node.getId()));
                this.sendRequestAndGetDoc(req);
                this._bufferValue.changeParent(node);
            } else {
                this._bufferValue.loadAllDescendant();
                this._bufferValue.clone(node);
            }
            this.updateTree();
        }
    }

    public boolean checkNode(int id, int treeId) throws Exception {
        Request req = this.getRequest();
        req.setAttribute("command", "check");
        req.setAttribute("id", String.valueOf(id));
        req.setAttribute("mtree_id", String.valueOf(treeId));
        Document doc = this.sendRequestAndGetDoc(req);
        String selectText = XMLUtils.selectText(doc, "/data/@result", "true");
        return selectText.equals("true");
    }

    public void fixNode(int id, int treeId) {
        Request req = this.getRequest();
        req.setAttribute("command", "fix");
        req.setAttribute("id", String.valueOf(id));
        req.setAttribute("mtree_id", String.valueOf(treeId));
        this.sendRequestAndGetDoc(req);
    }

    public boolean checkForSwap(int id1, int id2) throws Exception {
        Request req = this.getRequest();
        req.setAttribute("command", "checkForSwap");
        req.setAttribute("id", String.valueOf(id1));
        req.setAttribute("id2", String.valueOf(id2));
        Document doc = this.sendRequestAndGetDoc(req);
        String selectText = XMLUtils.selectText(doc, "/data/@result", "true");
        return selectText.equals("true");
    }

    private Request getRequest() {
        Request request = new Request();
        request.setModule("tariff");
        request.setAction("ModifTariffNode");
        return request;
    }

    private void enterEdit(MouseEvent e) {
        try {
            TariffTreeNode selected = this.getSelectedNode();
            if (selected == null) {
                return;
            }
            selected.loadChilds();
            if (!selected.getChilds().isEmpty()) {
                return;
            }
            DefaultTariffTreeNode defaultTariffTreeNode = (DefaultTariffTreeNode)selected;
            if (defaultTariffTreeNode.getEditable()) {
                e.consume();
                defaultTariffTreeNode.editAction();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void showRightClickMenu(int x, int y) {
        TariffTreeNode selected = this.getSelectedNode();
        if (selected != null) {
            selected.getRightClickMenu().show(this.viewableTree, x, y);
        }
    }

    private TariffTreeNode getSelectedNode() {
        DefaultMutableTreeNode node;
        Object userObject;
        TariffTreeNode result = null;
        TreePath path = this.viewableTree.getSelectionPath();
        if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof TariffTreeNode) {
            result = (TariffTreeNode)userObject;
        }
        return result;
    }

    public Component getViewable() {
        return this.viewablePanel;
    }

    public JTree getViewableTree() {
        return this.viewableTree;
    }

    private Document sendRequestAndGetDoc(Request req) {
        Document doc = null;
        try {
            this.TD.postData(req);
            doc = this.TD.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    public Element getTreeInfo(int tree_id) {
        Element result = null;
        Request req = new Request();
        req.setModule("tariff");
        req.setAction("TariffTreeInfo");
        req.setAttribute("tree_id", String.valueOf(tree_id));
        Document doc = this.sendRequestAndGetDoc(req);
        if (doc != null) {
            result = doc.getDocumentElement();
        }
        return result;
    }

    public Element getMtreeInfo(int mtreeId) {
        Element result = null;
        Request req = new Request();
        req.setModule("tariff");
        req.setAction("MtreeInfo");
        req.setAttribute("id", mtreeId);
        Document doc = this.sendRequestAndGetDoc(req);
        if (doc != null) {
            result = doc.getDocumentElement();
        }
        return result;
    }

    public int getTreeId() {
        return this.treeId;
    }

    public ClientSetup getSetup() {
        return this._setup;
    }

    public void close() {
        if (this._viewableRootNode == null) {
            return;
        }
        int size = this._viewableRootNode.getChildCount();
        for (int i = 0; i < size; ++i) {
            Object obj;
            TreeNode node = this._viewableRootNode.getChildAt(i);
            if (!(node instanceof DefaultMutableTreeNode) || !((obj = ((DefaultMutableTreeNode)node).getUserObject()) instanceof FlushableRootTariffTreeNode)) continue;
            ((FlushableRootTariffTreeNode)obj).flush();
        }
    }

    public Component getParent() {
        return this.parent;
    }

    class TreeData {
        private int id = -1;
        private int moduleId = 0;
        private Map<Integer, List<Element>> elementMap = new HashMap<Integer, List<Element>>();

        TreeData(TariffTree this$0) {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(int moduleId) {
            this.moduleId = moduleId;
        }

        public Map<Integer, List<Element>> getElementMap() {
            return this.elementMap;
        }

        public void setElementMap(Map<Integer, List<Element>> elementMap) {
            this.elementMap = elementMap;
        }
    }
}

