/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.tariff.voice.ServiceConfigZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;

public class ServiceConfigZoneMap
extends ServiceConfigTabbedPanel {
    private BGTable table = new BGTable();
    private JPanel edit = new JPanel(new GridBagLayout());
    private BGTextField title = new BGTextField();
    private int currentID = 0;
    private CardLayout cardLayout = new CardLayout();
    private ServiceConfigZone zone = new ServiceConfigZone();

    public ServiceConfigZoneMap() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "zone_map");
    }

    private void jbInit() {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.edit.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.edit.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.edit.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.edit.add((Component)okCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.edit.setVisible(false);
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tablePanel.add((Component)this.edit, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.edit.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ServiceConfigZoneMap.this.setData();
            }
        });
        this.setLayout(this.cardLayout);
        this.add((Component)tablePanel, "table");
        this.add((Component)this.zone, "zone");
        this.cardLayout.show(this, "table");
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.tableMouseClicked((MouseEvent)e));
    }

    private void tableMouseClicked(MouseEvent event) {
        this.zone.setId(ClientUtils.getRowId(this.table));
        if (this.zone.getId() > 0) {
            this.zone.setTitle(ClientUtils.getRowId(this.table, null, "title"));
            this.cardLayout.show(this, "zone");
            this.zone.setData();
        }
    }

    public void startEdit() {
        if (this.currentID > 0) {
            Request req = new Request();
            req.setModule("tariff.voice");
            req.setModuleId(this.getModuleId());
            req.setAction("MapGet");
            req.setAttribute("id", this.currentID);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus(doc)) {
                Element rule = XMLUtils.getElement(doc, "map");
                this.title.setText(rule.getAttribute("title"));
            }
        } else {
            this.title.setText("");
        }
        this.edit.setVisible(true);
    }

    public void stopEdit(boolean save) {
        if (save) {
            Request req = new Request();
            req.setModule("tariff.voice");
            req.setModuleId(this.getModuleId());
            req.setAction("MapUpdate");
            req.setAttribute("id", this.currentID);
            req.setAttribute("title", this.title.getText());
            if (ClientUtils.checkStatus(this.getDocument(req))) {
                this.edit.setVisible(false);
            }
        } else {
            this.edit.setVisible(false);
        }
    }

    @Override
    public void deleteItem() {
        if (this.zone.isVisible()) {
            this.zone.deleteItem();
        } else {
            this.currentID = ClientUtils.getRowId(this.table);
            if (this.currentID > 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request();
                request.setModule("tariff.voice");
                request.setModuleId(this.getModuleId());
                request.setAction("MapDelete");
                request.setAttribute("id", this.currentID);
                if (ClientUtils.checkStatus(this.getDocument(request))) {
                    this.setData();
                }
            }
        }
    }

    @Override
    public void newItem() {
        if (this.zone.isVisible()) {
            this.zone.newItem();
        } else {
            this.currentID = 0;
            this.startEdit();
        }
    }

    @Override
    public void editItem() {
        if (this.zone.isVisible()) {
            this.zone.editItem();
        } else {
            this.currentID = ClientUtils.getRowId(this.table);
            if (this.currentID > 0) {
                this.startEdit();
            }
        }
    }

    @Override
    public void setData() {
        if (!this.zone.isVisible()) {
            Request request = new Request();
            request.setModule("tariff.voice");
            request.setModuleId(this.getModuleId());
            request.setAction("Map");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.table.updateData(XMLUtils.getNode(doc, "table"));
            }
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.zone.init(module, mid);
    }
}

