/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.util.Config;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.ws.common.Distribution;
import ru.bitel.bgbilling.kernel.container.ws.server.WSClient;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.localize.Localizer;

public class Setup
extends DefaultServerSetup {
    private static final Logger log = LogManager.getLogger();
    private final ConcurrentHashMap<Integer, Map<Class<?>, Config>> configMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ModuleSetup> moduleSetupMap = new ConcurrentHashMap();
    private final Distribution distribution;
    private final WSClient wsClient;
    private Date initDate = new Date();
    private final Preferences bundlePreferences;
    private String applicationName;
    private final String dirName;
    private static final Class<?>[] getConfigClasses = new Class[]{Integer.TYPE, ParameterMap.class, Setup.class};
    protected static Setup instance;

    public Setup(String dirName, String confName) {
        super((String)(Utils.isEmptyString((String)dirName) ? "" : dirName + ".") + confName);
        this.dirName = dirName;
        this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)dirName) ? "" : dirName + ".") + "activemq"), "mq.");
        this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)dirName) ? "" : dirName + ".") + "database"), "db.");
        this.bundlePreferences = new Preferences(new HashMap(this.data));
        Localizer.initLocales((Preferences)this);
        this.initJNDI();
        this.initMQ();
        this.init();
        this.applicationName = SetupParam.getApplicationName(this);
        this.distribution = new Distribution((ParameterMap)this);
        this.wsClient = new WSClient((ParameterMap)this);
        this.addReloadListener();
    }

    public Setup(String bundleName) {
        super(bundleName);
        this.dirName = "";
        this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)this.dirName) ? "" : this.dirName + ".") + "activemq"), "mq.");
        this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)this.dirName) ? "" : this.dirName + ".") + "database"), "db.");
        this.bundlePreferences = new Preferences(new HashMap(this.data));
        Localizer.initLocales((Preferences)this);
        this.initJNDI();
        this.initMQ();
        this.init();
        this.applicationName = SetupParam.getApplicationName(this);
        this.distribution = new Distribution((ParameterMap)this);
        this.wsClient = new WSClient((ParameterMap)this);
        this.addReloadListener();
    }

    public Preferences getBundlePreferences() {
        return this.bundlePreferences;
    }

    public Date getInitDate() {
        return this.initDate;
    }

    public void addToConfig(Preferences preferences, String prefix) {
        for (Map.Entry entry : preferences.filter(prefix).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)this.data.get(key);
            if (value != null) continue;
            this.data.put(key, System.getProperty(key, (String)entry.getValue()));
        }
    }

    private void addReloadListener() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) {
                    log.info("Reload config, moduleId={}", (Object)e.getModuleId());
                    Connection con = Setup.this.getDBConnectionFromPool();
                    try {
                        Setup.this.reloadConfig(con, e.getModuleId());
                    }
                    catch (Exception ex) {
                        log.error("error reload config mid=" + e.getModuleId(), (Throwable)ex);
                    }
                    finally {
                        ServerUtils.closeConnection(con);
                    }
                }
            }, ModuleConfigModifiedEvent.class);
        }
        catch (Throwable e) {
            log.error("error add reload listener", e);
        }
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public WSClient getWSClient() {
        return this.wsClient;
    }

    private void init() {
        if (this.initConnectionPool()) {
            Connection con;
            try {
                con = this.getDBConnectionFromPool();
                try {
                    this.loadModuleSetup(con, 0, this.data);
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (SQLException ex) {
                log.error((Object)ex);
            }
            try {
                con = this.getDBConnection(true);
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                log.error((Object)ex);
            }
            this.initTrashPools();
        } else {
            log.error("error init connection pool!");
        }
    }

    public final <K extends Config> K getConfig(int moduleId, Class<K> clazz) {
        Config result;
        Map<Class<?>, Config> moduleMap = this.configMap.get(moduleId);
        if (moduleMap == null) {
            moduleMap = new ConcurrentHashMap(8);
            this.configMap.put(moduleId, moduleMap);
        }
        if ((result = moduleMap.get(clazz)) == null) {
            try {
                Constructor<K> constr = clazz.getConstructor(getConfigClasses);
                if ((clazz.getModifiers() & 1) == 0) {
                    constr.setAccessible(true);
                }
                result = (Config)constr.newInstance(new Object[]{moduleId, this.getModuleSetup(moduleId), this});
                moduleMap.put(clazz, result);
            }
            catch (InvocationTargetException e) {
                log.error("error get config mid=" + moduleId + ", InvocationTargetException caused by:", e.getCause());
            }
            catch (Exception e) {
                log.error("error get config mid=" + moduleId, (Throwable)e);
            }
        }
        return (K)result;
    }

    public ModuleSetup getModuleSetup(Integer moduleId) {
        if (moduleId > -1) {
            ModuleSetup moduleSetup = this.moduleSetupMap.get(moduleId);
            if (moduleSetup == null) {
                log.info("Load config for moduleId=" + moduleId);
                try (Connection con = this.getDBConnectionFromPool();){
                    moduleSetup = new ModuleSetup(con, moduleId);
                    this.moduleSetupMap.put(moduleId, moduleSetup);
                }
                catch (Exception e) {
                    log.error("error load config for moduleId=" + moduleId, (Throwable)e);
                }
            }
            return moduleSetup;
        }
        return null;
    }

    private synchronized void reloadConfig(Connection con, int mid) {
        if (mid > 0) {
            this.moduleSetupMap.remove(mid);
            this.configMap.remove(mid);
        } else {
            log.info("Reload kernel config...");
            HashMap data = new HashMap();
            this.loadBundle(data);
            this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)this.dirName) ? "" : this.dirName + ".") + "activemq"), "mq.");
            this.addToConfig(new Preferences((String)(Utils.isEmptyString((String)this.dirName) ? "" : this.dirName + ".") + "database"), "db.");
            this.loadModuleSetup(con, 0, data);
            this.updateData(data);
            this.moduleSetupMap.remove(0);
            this.configMap.remove(0);
            this.initDate = new Date();
            this.initTrashPools();
            this.throwActionEvent(new ActionEvent((Object)this, 0, "reload"));
        }
    }

    public String getFolderPathParam(String paramName, String defaultValue) {
        return Utils.checkPath((String)this.get(paramName, defaultValue));
    }

    public String getTempDirPath() {
        return this.get("temp.dir.path", new File("tmp").getAbsolutePath()) + File.separator;
    }

    public String getPathProperty(String what, String def) {
        return Utils.checkPath((String)System.getProperty(what, this.get(what, def)));
    }

    public static Setup getSetup() {
        return instance;
    }

    public static void setSetup(Setup setup) {
        instance = setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfig(int moduleId) {
        Connection con = null;
        try {
            con = this.getDBConnectionFromPool();
            HashMap data = new HashMap();
            this.loadBundle(data);
            this.loadModuleSetup(con, 0, data);
            this.loadModuleSetup(con, moduleId, data);
            this.updateData(data);
            this.initTrashPools();
            this.throwActionEvent(new ActionEvent((Object)this, 0, "reload"));
        }
        catch (Exception ex) {
            log.error("error reload setup+config moduleId=" + moduleId, (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    public String get(String key, String def) {
        String appKey;
        String result;
        if (this.applicationName != null && (result = super.get(appKey = this.applicationName + "." + key, null)) != null) {
            return result;
        }
        return super.get(key, def);
    }
}

