/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.editor.MultiSelectEditor;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;

public class StatusTariffTreeNode
extends DefaultTariffTreeNode {
    private List<Status> statusList = null;
    private MultiSelectEditor<Status> multiList;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        try {
            this.statusList = new ClientContext("kernel", 0, -1, null).getPort(ContractStatusService.class).getStatusList(false);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    public Component getView() {
        this.loadData();
        StringBuffer tx = new StringBuffer("\u0421\u0442\u0430\u0442\u0443\u0441: ");
        List<Integer> statusIds = Utils.toIntegerList(this.getDataInHash().getOrDefault("status", ""));
        for (Status listItem : this.statusList) {
            if (!statusIds.contains(listItem.getId())) continue;
            if (tx.length() > 10) {
                tx.append("; ");
            }
            tx.append(listItem.getTitle()).append(" [#").append(listItem.getId()).append("]");
        }
        JLabel view = new JLabel(tx.toString());
        view.setIcon(ClientUtils.getIcon("fugue/socket"));
        view.setText(tx.toString());
        return view;
    }

    public void extractData() {
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.multiList == null) {
            this.multiList = new MultiSelectEditor<Status>(this.statusList);
        }
        return this.multiList;
    }

    @Override
    protected void loadData() {
        ((MultiSelectEditor)this.getEditorPanel()).setSelect(this.getDataInHash().getOrDefault("status", ""));
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("status", this.multiList.getSelect());
        this.setDataInHash(data);
        this.extractData();
    }
}

