/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccount;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccountDetail;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class BalanceDao
extends AbstarctDaoConstant
implements AutoCloseable {
    private static final String TABLE_CONTRACT_ACCOUNT = "contract_account";
    private static final String TABLE_CONTRACT_ACCOUNT_DETAIL = "contract_account_detail";
    private final Connection con;
    private ReserveDao reserveDao;
    private PreparedStatement addAccountPS;
    private PreparedStatement setAccountPS;
    private PreparedStatement insertAccountPS;
    private PreparedStatement addBalanceAccountPS;
    private PreparedStatement insertBalanceAccountPS;
    private PreparedStatement updateBalanceAccountPS;
    private PreparedStatement getBalanceAccountPS;
    private PreparedStatement getIncomingSaldoPS;
    private PreparedStatement selectTransitBalanceToLastExistPS;
    private PreparedStatement updateTransitBalanceToLastExistPS;
    private PreparedStatement getContractBalancePS1 = null;
    private PreparedStatement getContractBalancePS2 = null;
    private PreparedStatement getBalancePS1 = null;
    private PreparedStatement getBalancePS2 = null;

    public BalanceDao(Connection con) {
        this.con = con;
    }

    private ReserveDao getReservDao() {
        if (this.reserveDao == null) {
            this.reserveDao = new ReserveDao(this.con);
        }
        return this.reserveDao;
    }

    public void addContractAccount(int contractId, int yy, int mm, int serviceId, BigDecimal account) throws BGException {
        try {
            if (account.scale() > 5) {
                throw new IllegalArgumentException("Only 5 scaled values!");
            }
            PreparedStatement addAccountPS = this.addAccountPS;
            if (addAccountPS == null) {
                addAccountPS = this.addAccountPS = this.con.prepareStatement("UPDATE contract_account SET summa=summa+? WHERE cid=? AND sid=? AND yy=? AND mm=?");
            }
            addAccountPS.setBigDecimal(1, account);
            addAccountPS.setInt(2, contractId);
            addAccountPS.setInt(3, serviceId);
            addAccountPS.setInt(4, yy);
            addAccountPS.setInt(5, mm);
            if (addAccountPS.executeUpdate() == 0) {
                this.insertContractAccount(contractId, yy, mm, serviceId, account);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void addContractAccount2(int contractId, int yy, int mm, int serviceId, BigDecimal account) throws BGException {
        try {
            if (account.scale() > 5) {
                throw new IllegalArgumentException("Only 5 scaled values!");
            }
            PreparedStatement addAccountPS = this.addAccountPS;
            if (addAccountPS == null) {
                addAccountPS = this.addAccountPS = this.con.prepareStatement("UPDATE contract_account SET summa=summa+? WHERE cid=? AND sid=? AND yy=? AND mm=?");
            }
            addAccountPS.setBigDecimal(1, account);
            addAccountPS.setInt(2, contractId);
            addAccountPS.setInt(3, serviceId);
            addAccountPS.setInt(4, yy);
            addAccountPS.setInt(5, mm);
            int i = 0;
            while (addAccountPS.executeUpdate() == 0) {
                try {
                    this.insertContractAccount(contractId, yy, mm, serviceId, account);
                    break;
                }
                catch (SQLException e) {
                    if (e.getSQLState() == null || !e.getSQLState().startsWith("23") || i > 10) {
                        throw e;
                    }
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void insertContractAccount(int contractId, int yy, int mm, int serviceId, BigDecimal account) throws BGException, SQLException {
        PreparedStatement insertAccountPS = this.insertAccountPS;
        if (insertAccountPS == null) {
            insertAccountPS = this.insertAccountPS = this.con.prepareStatement("INSERT INTO contract_account (cid, sid, yy, mm, summa) VALUES (?,?,?,?,?)");
        }
        insertAccountPS.setInt(1, contractId);
        insertAccountPS.setInt(2, serviceId);
        insertAccountPS.setInt(3, yy);
        insertAccountPS.setInt(4, mm);
        insertAccountPS.setBigDecimal(5, account);
        insertAccountPS.executeUpdate();
    }

    public void addBalanceAccount(int contractId, int superContractId, int yy, int mm, BigDecimal account) throws BGException {
        try {
            int needUpdateCount;
            if (account.scale() > 2) {
                throw new IllegalArgumentException("Scale must be <=2!");
            }
            PreparedStatement addBalanceAccountPS = this.addBalanceAccountPS;
            if (addBalanceAccountPS == null) {
                addBalanceAccountPS = this.addBalanceAccountPS = this.con.prepareStatement("UPDATE contract_balance SET summa3=summa3+? WHERE (cid=? OR cid=?) AND yy=? AND mm=?");
            }
            addBalanceAccountPS.setBigDecimal(1, account);
            addBalanceAccountPS.setInt(2, contractId);
            if (superContractId > 0) {
                addBalanceAccountPS.setInt(3, superContractId);
                needUpdateCount = 2;
            } else {
                addBalanceAccountPS.setInt(3, contractId);
                needUpdateCount = 1;
            }
            addBalanceAccountPS.setInt(4, yy);
            addBalanceAccountPS.setInt(5, mm);
            if (addBalanceAccountPS.executeUpdate() != needUpdateCount) {
                this.setBalanceAccount(contractId, superContractId, yy, mm);
            } else if (superContractId > 0) {
                this.transitBalanceToLastExist(superContractId, yy, mm);
            } else {
                this.transitBalanceToLastExist(contractId, yy, mm);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public BigDecimal setBalanceAccount(int contractId, int superContractId, int yy, int mm) throws BGException {
        try {
            BigDecimal account = this.getBalanceAccount(contractId, yy, mm);
            PreparedStatement ps = this.updateBalanceAccountPS;
            if (ps == null) {
                ps = this.updateBalanceAccountPS = this.con.prepareStatement("UPDATE contract_balance SET summa3=? WHERE yy=? AND mm=? AND cid=?");
            }
            ps.setBigDecimal(1, account);
            ps.setInt(2, yy);
            ps.setInt(3, mm);
            ps.setInt(4, contractId);
            if (ps.executeUpdate() == 0) {
                BigDecimal incomingSaldo = superContractId > 0 ? BigDecimal.ZERO : this.getIncomingSaldo(contractId, yy, mm);
                ps = this.insertBalanceAccountPS;
                if (ps == null) {
                    ps = this.insertBalanceAccountPS = this.con.prepareStatement("INSERT INTO contract_balance (yy, mm, cid, summa1, summa3) VALUES (?, ?, ?, ?, ?)");
                }
                ps.setInt(1, yy);
                ps.setInt(2, mm);
                ps.setInt(3, contractId);
                ps.setBigDecimal(4, incomingSaldo);
                ps.setBigDecimal(5, account);
                ps.executeUpdate();
            }
            if (superContractId > 0) {
                this.setBalanceAccount(superContractId, -1, yy, mm);
            } else {
                this.transitBalanceToLastExist(contractId, yy, mm);
            }
            return account;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private BigDecimal getBalanceAccount(int contractId, int yy, int mm) throws BGException, SQLException {
        BigDecimal result;
        PreparedStatement ps = this.getBalanceAccountPS;
        if (ps == null) {
            ps = this.getBalanceAccountPS = this.con.prepareStatement("SELECT SUM(ROUND(contract_account.summa, 2)) FROM contract LEFT JOIN contract_account ON contract_account.cid=contract.id AND contract_account.yy=? AND contract_account.mm=? WHERE contract.id=? OR (contract.scid=? AND contract.sub_mode=0)");
        }
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        ps.setInt(3, contractId);
        ps.setInt(4, contractId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getBigDecimal(1);
            if (result == null) {
                result = BigDecimal.ZERO;
            }
        } else {
            result = BigDecimal.ZERO;
        }
        rs.close();
        return result;
    }

    private BigDecimal getIncomingSaldo(int contractId, int yy, int mm) throws BGException, SQLException {
        PreparedStatement ps;
        if (yy <= 0 && mm <= 0) {
            throw new IllegalArgumentException();
        }
        if (--mm <= 0) {
            --yy;
            mm = 12;
        }
        if ((ps = this.getIncomingSaldoPS) == null) {
            ps = this.getIncomingSaldoPS = this.con.prepareStatement("SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? AND (yy*12 + mm)<=? ORDER BY (yy*12 + mm) DESC LIMIT 1");
        }
        ps.setInt(1, contractId);
        ps.setInt(2, yy * 12 + mm);
        ResultSet rs = ps.executeQuery();
        BigDecimal result = rs.next() ? rs.getBigDecimal(1) : BigDecimal.ZERO;
        rs.close();
        return result;
    }

    private void transitBalanceToLastExist(int contractId, int yy, int mm) throws SQLException {
        PreparedStatement ps = this.selectTransitBalanceToLastExistPS;
        if (ps == null) {
            ps = this.selectTransitBalanceToLastExistPS = this.con.prepareStatement("SELECT yy, mm, summa1, (summa2 - summa3 - summa4) FROM contract_balance WHERE cid=? AND ( (yy=? AND mm>=?) OR yy>? ) ORDER BY yy, mm");
        }
        ps.setInt(1, contractId);
        ps.setInt(2, yy);
        ps.setInt(3, mm);
        ps.setInt(4, yy);
        ResultSet rs = ps.executeQuery();
        BigDecimal incomingSaldo = null;
        PreparedStatement updatePS = this.updateTransitBalanceToLastExistPS;
        if (updatePS == null) {
            updatePS = this.updateTransitBalanceToLastExistPS = this.con.prepareStatement("UPDATE contract_balance SET summa1=? WHERE cid=? AND yy=? AND mm=?");
        }
        updatePS.setInt(2, contractId);
        while (rs.next()) {
            if (incomingSaldo != null) {
                updatePS.setBigDecimal(1, incomingSaldo);
                updatePS.setInt(3, rs.getInt(1));
                updatePS.setInt(4, rs.getInt(2));
                updatePS.executeUpdate();
                incomingSaldo = incomingSaldo.add(rs.getBigDecimal(4));
                continue;
            }
            incomingSaldo = rs.getBigDecimal(3).add(rs.getBigDecimal(4));
        }
        rs.close();
    }

    public ContractBalance getContractBalance(int contractId, int yy, int mm) throws BGException {
        try {
            Calendar cal;
            ContractBalance result = new ContractBalance();
            PreparedStatement ps = this.getContractBalancePS1;
            if (ps == null) {
                ps = this.getContractBalancePS1 = this.con.prepareStatement("SELECT summa1, summa2, summa3, summa4 FROM contract_balance WHERE cid=? AND yy=? AND mm=?");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, yy);
            ps.setInt(3, mm);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result.setIncomingSaldo(rs.getBigDecimal(1));
                result.setPayments(rs.getBigDecimal(2));
                result.setAccounts(rs.getBigDecimal(3));
                result.setCharges(rs.getBigDecimal(4));
                result.setYear(yy);
                result.setMonth(mm);
                rs.close();
            } else {
                rs.close();
                ps = this.getContractBalancePS2;
                if (ps == null) {
                    ps = this.getContractBalancePS2 = this.con.prepareStatement("SELECT summa1, summa2, summa3, summa4, yy, mm FROM contract_balance WHERE cid=? AND ((yy*12) + mm)<=((?*12) + ?) ORDER BY yy DESC, mm DESC LIMIT 1");
                }
                ps.setInt(1, contractId);
                ps.setInt(2, yy);
                ps.setInt(3, mm);
                rs = ps.executeQuery();
                if (rs.next()) {
                    result.setIncomingSaldo(rs.getBigDecimal(1));
                    result.setPayments(rs.getBigDecimal(2));
                    result.setAccounts(rs.getBigDecimal(3));
                    result.setCharges(rs.getBigDecimal(4));
                    result.setYear(rs.getInt(5));
                    result.setMonth(rs.getInt(6));
                } else {
                    result.setIncomingSaldo(BigDecimal.ZERO);
                    result.setPayments(BigDecimal.ZERO);
                    result.setAccounts(BigDecimal.ZERO);
                    result.setCharges(BigDecimal.ZERO);
                    result.setYear(yy);
                    result.setMonth(mm);
                }
                rs.close();
            }
            if (ReserveDao.flagReserve && (cal = Calendar.getInstance()).get(1) == yy && cal.get(2) + 1 == mm) {
                result.setReserve(this.getReservDao().getReserveSum(contractId));
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<ContractBalance> getContractBalanceList(int contractId, Period period) {
        ArrayList<ContractBalance> list = new ArrayList<ContractBalance>();
        if (contractId < 1) {
            return list;
        }
        Calendar d1 = null;
        Calendar d2 = null;
        GregorianCalendar d0 = new GregorianCalendar();
        if (period != null) {
            d1 = period.getDateFromCalendar();
            d2 = period.getDateToCalendar();
        }
        if (d1 == null) {
            d1 = (Calendar)((Calendar)d0).clone();
        }
        if (d2 == null) {
            d2 = (Calendar)((Calendar)d0).clone();
        }
        int index = 1;
        int y1 = d1.get(1);
        int y2 = d2.get(1);
        int m1 = d1.get(2) + 1;
        int m2 = d2.get(2) + 1;
        String query = "SELECT mm, yy, summa1, summa2, summa3, summa4 FROM contract_balance WHERE cid=?  AND ( ( yy>? AND yy<? ) OR ( yy=? AND yy<>? AND mm>=? ) OR ( yy<>? AND yy=? AND mm<=? ) OR ( yy=? AND yy=? AND mm>=? AND mm<=? ) ) ORDER BY yy, mm";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(index++, contractId);
            ps.setInt(index++, y1);
            ps.setInt(index++, y2);
            ps.setInt(index++, y1);
            ps.setInt(index++, y2);
            ps.setInt(index++, m1);
            ps.setInt(index++, y1);
            ps.setInt(index++, y2);
            ps.setInt(index++, m2);
            ps.setInt(index++, y1);
            ps.setInt(index++, y2);
            ps.setInt(index++, m1);
            ps.setInt(index++, m2);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ContractBalance balance = new ContractBalance();
                    balance.setIncomingSaldo(rs.getBigDecimal("summa1"));
                    balance.setPayments(rs.getBigDecimal("summa2"));
                    balance.setAccounts(rs.getBigDecimal("summa3"));
                    balance.setCharges(rs.getBigDecimal("summa4"));
                    balance.setYear(rs.getInt("yy"));
                    balance.setMonth(rs.getInt("mm"));
                    list.add(balance);
                }
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return list;
    }

    public BigDecimal getBalance(int contractId, int yy, int mm) throws BGException {
        try {
            Calendar cal;
            BigDecimal result = null;
            PreparedStatement ps = this.getBalancePS1;
            if (ps == null) {
                ps = this.getBalancePS1 = this.con.prepareStatement("SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? AND yy=? AND mm=?");
            }
            ps.setInt(1, contractId);
            ps.setInt(2, yy);
            ps.setInt(3, mm);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getBigDecimal(1);
                rs.close();
            } else {
                rs.close();
                ps = this.getBalancePS2;
                if (ps == null) {
                    ps = this.getBalancePS2 = this.con.prepareStatement("SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? AND ((yy*12) + mm)<=((?*12) + ?) ORDER BY yy DESC, mm DESC LIMIT 1");
                }
                ps.setInt(1, contractId);
                ps.setInt(2, yy);
                ps.setInt(3, mm);
                rs = ps.executeQuery();
                result = rs.next() ? rs.getBigDecimal(1) : BigDecimal.ZERO;
                rs.close();
            }
            if (ReserveDao.flagReserve && (cal = Calendar.getInstance()).get(1) == yy && cal.get(2) + 1 == mm) {
                return result.subtract(this.getReservDao().getReserveSum(contractId));
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void setContractAccount(int cid, int yy, int mm, int serviceId, BigDecimal summa) throws BGException {
        if (summa.scale() > 5) {
            throw new IllegalArgumentException("Only 5 scaled values!");
        }
        try {
            PreparedStatement setAccountPS = this.setAccountPS;
            if (setAccountPS == null) {
                setAccountPS = this.setAccountPS = this.con.prepareStatement("UPDATE contract_account SET summa=? WHERE cid=? AND sid=? AND yy=? AND mm=?");
            }
            setAccountPS.setBigDecimal(1, summa);
            setAccountPS.setInt(2, cid);
            setAccountPS.setInt(3, serviceId);
            setAccountPS.setInt(4, yy);
            setAccountPS.setInt(5, mm);
            if (setAccountPS.executeUpdate() == 0) {
                this.insertContractAccount(cid, yy, mm, serviceId, summa);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.addAccountPS != null) {
                this.addAccountPS.close();
                this.addAccountPS = null;
            }
            if (this.setAccountPS != null) {
                this.setAccountPS.close();
                this.setAccountPS = null;
            }
            if (this.insertAccountPS != null) {
                this.insertAccountPS.close();
                this.insertAccountPS = null;
            }
            if (this.addBalanceAccountPS != null) {
                this.addBalanceAccountPS.close();
                this.addBalanceAccountPS = null;
            }
            if (this.getBalanceAccountPS != null) {
                this.getBalanceAccountPS.close();
                this.getBalanceAccountPS = null;
            }
            if (this.getBalancePS1 != null) {
                this.getBalancePS1.close();
                this.getBalancePS1 = null;
            }
            if (this.getBalancePS2 != null) {
                this.getBalancePS2.close();
                this.getBalancePS2 = null;
            }
            if (this.getContractBalancePS1 != null) {
                this.getContractBalancePS1.close();
                this.getContractBalancePS1 = null;
            }
            if (this.getContractBalancePS2 != null) {
                this.getContractBalancePS2.close();
                this.getContractBalancePS2 = null;
            }
            if (this.getIncomingSaldoPS != null) {
                this.getIncomingSaldoPS.close();
                this.getIncomingSaldoPS = null;
            }
            if (this.insertBalanceAccountPS != null) {
                this.insertBalanceAccountPS.close();
                this.insertBalanceAccountPS = null;
            }
            if (this.selectTransitBalanceToLastExistPS != null) {
                this.selectTransitBalanceToLastExistPS.close();
                this.selectTransitBalanceToLastExistPS = null;
            }
            if (this.updateBalanceAccountPS != null) {
                this.updateBalanceAccountPS.close();
                this.updateBalanceAccountPS = null;
            }
            if (this.updateTransitBalanceToLastExistPS != null) {
                this.updateTransitBalanceToLastExistPS.close();
                this.updateTransitBalanceToLastExistPS = null;
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
    }

    public SearchResult<ContractAccount> getContractAccountList(int contractId, Period period, int members) throws BGException {
        String cids;
        SearchResult searchResult = new SearchResult();
        List list = searchResult.getList();
        try {
            cids = ContractUtils.getCidsStringForQuery(contractId, members, this.con);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        Object whereBalanceAccount = "";
        Calendar baseDate = Calendar.getInstance();
        baseDate.set(5, 1);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)baseDate);
        if (cids == null) {
            searchResult.setSum(BigDecimal.ZERO);
            return searchResult;
        }
        if (period != null) {
            Calendar date1 = period.getDateFromCalendar() != null ? period.getDateFromCalendar() : Calendar.getInstance();
            Calendar date2 = period.getDateToCalendar() != null ? period.getDateToCalendar() : Calendar.getInstance();
            Object mmyy = "";
            if (date1.equals(date2) || date1.after(date2)) {
                mmyy = (String)mmyy + " ( yy=" + date1.get(1) + " AND mm=" + (date1.get(2) + 1) + " ) ";
            } else {
                while (date1.before(date2)) {
                    mmyy = (String)mmyy + (((String)mmyy).equals("") ? "" : " OR ");
                    mmyy = (String)mmyy + " ( yy=" + date1.get(1) + " AND mm=" + (date1.get(2) + 1) + " ) ";
                    date1.add(2, 1);
                }
            }
            if (Utils.notEmptyString((String)mmyy)) {
                whereBalanceAccount = " AND ( " + (String)mmyy + " )";
            }
        }
        String query = "SELECT * FROM contract_account AS ac WHERE cid IN (" + cids + ")" + (String)whereBalanceAccount + " ORDER BY yy, mm";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            BigDecimal all = BigDecimal.ZERO;
            while (rs.next()) {
                BigDecimal sum = rs.getBigDecimal("summa");
                Calendar date = (Calendar)baseDate.clone();
                date.set(2, rs.getInt("mm") - 1);
                date.set(1, rs.getInt("yy"));
                list.add(new ContractAccount(rs.getInt("cid"), date.getTime(), sum, rs.getInt("sid")));
                all = all.add(sum);
            }
            searchResult.setSum(all);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public void getContractAccountDetailList(SearchResult<ContractAccountDetail> searchResult, int contractId, int serviceId) throws BGException {
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        String query = "SELECT * FROM contract_account_detail AS ac WHERE contract_id=? AND service_id=? AND ( date_from IS NULL OR date_from<=? ) AND ( date_to IS NULL OR date_to>? ) ORDER BY date_from, date_to";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, serviceId);
            ps.setTimestamp(3, TimeUtils.convertLocalDateToTimestamp((LocalDate)(period != null ? period.getLocalDateTo() : null)));
            ps.setTimestamp(4, TimeUtils.convertLocalDateToTimestamp((LocalDate)(period != null ? period.getLocalDateFrom() : null)));
            BigDecimal sum = BigDecimal.ZERO;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ContractAccountDetail contractAccountDetail = ContractAccountDetail.builder().setContractId(contractId).setObjectId(rs.getInt("object_id")).setServiceId(serviceId).setEntityModuleId(rs.getInt("entity_module_id")).setEntityId(rs.getInt("entity_id")).setEntityTitle(rs.getString("entity_title")).setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setComment(rs.getString("comment")).setCost(rs.getBigDecimal("cost")).setAmount(rs.getBigDecimal("amount")).setSum(rs.getBigDecimal("sum")).build();
                    list.add(contractAccountDetail);
                    sum = sum.add(contractAccountDetail.getSum());
                }
                searchResult.setSum(sum);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void addContractAccountDetail(List<ContractAccountDetail> accountDetails) throws BGException {
        String sql = "INSERT INTO contract_account_detail SET contract_id=?, object_id=?, service_id=?, entity_module_id=?, entity_id=?, entity_title=?, date_from=?, date_to=?, comment=?, cost=?, amount=?, sum=?";
        try (PreparedStatement psInsert = this.con.prepareStatement(sql);){
            for (ContractAccountDetail contractAccountDetail : accountDetails) {
                if (contractAccountDetail.getSum() == null || contractAccountDetail.getSum().compareTo(BigDecimal.ZERO) == 0) continue;
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("Save accountDetail: {}", (Object)contractAccountDetail);
                }
                Period period = contractAccountDetail.getPeriod();
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, contractAccountDetail.getContractId());
                psInsert.setInt(parameterIndex++, contractAccountDetail.getObjectId());
                psInsert.setInt(parameterIndex++, contractAccountDetail.getServiceId());
                psInsert.setInt(parameterIndex++, contractAccountDetail.getEntityModuleId());
                psInsert.setInt(parameterIndex++, contractAccountDetail.getEntityId());
                psInsert.setString(parameterIndex++, contractAccountDetail.getEntityTitle());
                psInsert.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                psInsert.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                psInsert.setString(parameterIndex++, contractAccountDetail.getComment() != null ? contractAccountDetail.getComment() : "");
                psInsert.setBigDecimal(parameterIndex++, contractAccountDetail.getCost() != null ? contractAccountDetail.getCost() : BigDecimal.ZERO);
                psInsert.setBigDecimal(parameterIndex++, contractAccountDetail.getAmount() != null ? contractAccountDetail.getAmount() : BigDecimal.ONE);
                psInsert.setBigDecimal(parameterIndex++, contractAccountDetail.getSum() != null ? contractAccountDetail.getSum() : BigDecimal.ZERO);
                psInsert.executeUpdate();
            }
        }
        catch (Exception ex) {
            this.logError("addContractAccountDetail", ex);
            throw new BGException((Throwable)ex);
        }
    }

    public void removeContractAccountDetail(int contractId, int year, int month, Set<Integer> serviceIds) throws SQLException {
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plusMonths(1L);
        String queryDelete = "DELETE FROM contract_account_detail WHERE contract_id=? AND date_from>=? AND date_from<? AND service_id IN ( " + Utils.toString(serviceIds) + " )";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            psDelete.setInt(1, contractId);
            psDelete.setTimestamp(2, TimeUtils.convertLocalDateToTimestamp((LocalDate)startDate));
            psDelete.setTimestamp(3, TimeUtils.convertLocalDateToTimestamp((LocalDate)endDate));
            psDelete.executeUpdate();
        }
    }

    public void cleanContractAccountDetail() throws BGException {
        int days = Setup.getSetup().getInt("contract.account.detail.remove.day", 365);
        String queryDelete = "DELETE FROM contract_account_detail WHERE date_from<DATE_SUB( CURDATE(), INTERVAL ? DAY)";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            psDelete.setInt(1, days);
            psDelete.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void removeContractAccount(int cid, int yy, int mm, String sids) throws SQLException {
        String query = "DELETE FROM contract_account WHERE cid=? AND yy=? AND mm=? AND sid IN (" + sids + ") ";
        try (PreparedStatement delAccountPS = this.con.prepareStatement(query);){
            delAccountPS.setInt(1, cid);
            delAccountPS.setInt(2, yy);
            delAccountPS.setInt(3, mm);
            delAccountPS.executeUpdate();
        }
    }

    public void removeContractAccount(int yy, int mm, Set<Integer> cids, String sids, long groupMask) throws BGException {
        if (Utils.isBlankString((String)sids)) {
            throw new BGException(" sids is empty ");
        }
        Object sql = "DELETE FROM contract_account";
        if (groupMask > 0L) {
            sql = (String)sql + " USING contract_account LEFT JOIN contract ON contract.id = contract_account.cid";
        }
        sql = (String)sql + " WHERE yy=? AND mm=? AND sid IN (" + sids + ") ";
        if (Utils.notEmptyCollection(cids)) {
            sql = (String)sql + " AND cid IN (" + Utils.toString(cids) + ")";
        }
        if (groupMask > 0L) {
            sql = (String)sql + " AND contract.gr & " + groupMask + " > 0  ";
        }
        try (PreparedStatement delAccountPS = this.con.prepareStatement((String)sql);){
            delAccountPS.setInt(1, yy);
            delAccountPS.setInt(2, mm);
            delAccountPS.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void accountClear(int yy, int mm, List<Integer> contractIds, List<Integer> contractLabelIds, String sidList) throws BGException {
        String queryDelete = "DELETE FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
        if (!contractIds.isEmpty()) {
            queryDelete = queryDelete + " AND cid IN ( " + Utils.toString(contractIds) + " )";
        }
        if (!contractLabelIds.isEmpty()) {
            queryDelete = queryDelete + " AND cid IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(contractLabelIds) + " ))";
        }
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            psDelete.setInt(1, yy);
            psDelete.setInt(2, mm);
            psDelete.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void accountDetailClear(int yy, int mm, List<Integer> contractIds, List<Integer> contractLabelIds, String sidList) throws BGException {
        String queryDelete = "DELETE FROM `contract_account_detail` WHERE service_id IN ( " + sidList + " ) AND date_from>=? AND date_to<=? ";
        if (!contractIds.isEmpty()) {
            queryDelete = queryDelete + " AND contract_id IN ( " + Utils.toString(contractIds) + " )";
        }
        if (!contractLabelIds.isEmpty()) {
            queryDelete = queryDelete + " AND contract_id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(contractLabelIds) + " ))";
        }
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
            LocalDate localDate = LocalDate.of(yy, mm, 1);
            psDelete.setTimestamp(1, TimeUtils.convertLocalDateToTimestamp((LocalDate)localDate));
            localDate = localDate.withDayOfMonth(localDate.lengthOfMonth());
            psDelete.setTimestamp(2, TimeUtils.convertLocalDateToTimestamp((LocalDate)localDate));
            psDelete.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

