/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class PswdGen {
    public static final int DEFAULT_PASSWORD_LENGTH_MIN = 5;
    public static final int DEFAULT_PASSWORD_LENGTH_MAX = 10;
    public static final String LOGIN_CHARS_AUTO = "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGIT_PASSWORD_CHARS = "0123456789";
    public static final String EXTENDED_PASSWORD_CHARS = "01234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String EXTENDED_PASSWORD_CHARS_AUTO = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    public static final String DEFAULT_PASSWORD_CHARS = "0123456789";

    public static String generatePassword(int length, String passwordChars) {
        StringBuffer result = new StringBuffer();
        char[] array = Utils.notBlankString((String)passwordChars) ? passwordChars.toCharArray() : "0123456789".toCharArray();
        int arrayLength = array.length;
        long time = System.currentTimeMillis();
        time %= 10000L;
        int[] offsets = new int[4];
        for (int i = 3; i >= 0; --i) {
            offsets[i] = (int)time % 10;
            time /= 10L;
        }
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int pos = (offsets[i % 4] + random.nextInt(arrayLength)) % arrayLength;
            result.append(array[pos]);
        }
        return result.toString();
    }

    public static String generatePassword(ParameterMap setup) {
        return PswdGen.generatePassword(PswdGen.getPasswordLengthAuto(setup), PswdGen.getPasswordCharsAuto(setup));
    }

    public static final int getPasswordLengthMin(ParameterMap setup) {
        return setup != null ? setup.getInt("password.length.min", 5) : 5;
    }

    public static final int getPasswordLengthMax(ParameterMap setup) {
        return setup != null ? setup.getInt("password.length.max", 10) : 10;
    }

    public static final int getPasswordLengthAuto(ParameterMap setup) {
        int passwordLengthMax = PswdGen.getPasswordLengthMax(setup);
        return setup != null ? setup.getInt("password.length.auto", passwordLengthMax) : passwordLengthMax;
    }

    public static final String getPasswordChars(ParameterMap setup) {
        String chars = setup != null ? setup.get("password.chars", "0123456789") : "0123456789";
        return Utils.isBlankString((String)chars) ? "0123456789" : chars;
    }

    public static final String getPasswordCharsAuto(ParameterMap setup) {
        String chars = setup != null ? setup.get("password.chars.auto", PswdGen.getPasswordChars(setup)) : PswdGen.getPasswordChars(setup);
        return Utils.isBlankString((String)chars) ? PswdGen.getPasswordChars(setup) : chars;
    }

    public static String generatePasswordRTU(ParameterMap setup) {
        return PswdGen.generatePasswordRTU(PswdGen.getPasswordLengthAuto(setup), PswdGen.getPasswordCharsAuto(setup));
    }

    public static String generatePasswordRTU(int length, String passwordChars) {
        String seq = PswdGen.generatePassword(length, passwordChars);
        if (length < 3) {
            return seq;
        }
        try {
            char ch;
            StringBuffer result = new StringBuffer(seq);
            char[] array = passwordChars.toCharArray();
            int bigLetter = -1;
            int smallLetter = -1;
            int digit = -1;
            ArrayList<Character> numbers = new ArrayList<Character>();
            ArrayList<Character> small = new ArrayList<Character>();
            ArrayList<Character> big = new ArrayList<Character>();
            Random random = new Random();
            int index = 0;
            BitSet generated = new BitSet(length);
            for (char ch2 : array) {
                if (Character.isUpperCase(ch2)) {
                    big.add(Character.valueOf(ch2));
                    continue;
                }
                if (Character.isLowerCase(ch2)) {
                    small.add(Character.valueOf(ch2));
                    continue;
                }
                if (!Character.isDigit(ch2)) continue;
                numbers.add(Character.valueOf(ch2));
            }
            for (int i = 0; i < result.length(); ++i) {
                if (bigLetter == -1 && Character.isUpperCase(result.charAt(i))) {
                    bigLetter = i;
                    generated.set(i);
                    continue;
                }
                if (smallLetter == -1 && Character.isLowerCase(result.charAt(i))) {
                    smallLetter = i;
                    generated.set(i);
                    continue;
                }
                if (digit != -1 || !Character.isDigit(result.charAt(i))) continue;
                digit = i;
                generated.set(i);
            }
            if (digit == -1 && numbers.size() > 0) {
                while (generated.get(index = random.nextInt(length))) {
                }
                generated.set(index);
                ch = ((Character)numbers.get(random.nextInt(numbers.size() - 1))).charValue();
                result.setCharAt(index, ch);
            }
            if (bigLetter == -1 && big.size() > 0) {
                while (generated.get(index = random.nextInt(length))) {
                }
                generated.set(index);
                ch = ((Character)big.get(random.nextInt(big.size() - 1))).charValue();
                result.setCharAt(index, ch);
            }
            if (smallLetter == -1 && small.size() > 0) {
                while (generated.get(index = random.nextInt(length))) {
                }
                generated.set(index);
                ch = ((Character)small.get(random.nextInt(small.size() - 1))).charValue();
                result.setCharAt(index, ch);
            }
            return result.toString();
        }
        catch (Exception e) {
            System.out.println(e);
            return seq;
        }
    }

    public static boolean checkChars(String checkString, String chars) {
        if (checkString != null && chars != null) {
            for (int index = 0; index < checkString.length(); ++index) {
                if (chars.indexOf(checkString.charAt(index)) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String generateCode(String codePattern) {
        StringBuffer result = new StringBuffer();
        int pos = codePattern.indexOf(91);
        result.append(codePattern.substring(0, pos));
        String chars = "";
        Pattern pattern = Pattern.compile(".*\\[(.+)\\].*");
        Matcher matcher = pattern.matcher(codePattern);
        if (matcher.matches()) {
            chars = matcher.group(1);
        }
        int len = 0;
        pattern = Pattern.compile(".*\\{([0-9]+)\\}");
        matcher = pattern.matcher(codePattern);
        if (matcher.matches()) {
            len = Integer.valueOf(matcher.group(1));
        }
        int charsLen = chars.length();
        for (int index = 0; index < len; ++index) {
            result.append(chars.charAt((int)(Math.random() * (double)charsLen)));
        }
        return result.toString();
    }
}

