/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;

public class TableTariffVars
extends BGTableInfoBase {
    public TableTariffVars() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnBoolean("\u041d\u0430\u0441\u043b\u0435\u0434.", "child", 80), BGUTableColumn.buildColumnTextCenter("\u041c\u043e\u0434\u0443\u043b\u044c", "moduleName").setWidth(200), BGUTableColumn.buildColumnTextCenter("\u0422\u0438\u043f", "typeTitle").setWidth(200), BGUTableColumn.buildColumnTextLeft("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title").setMinWidth(150).setMaxWidth(-1), BGUTableColumn.buildColumnTextLeft("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e", "value").setMinWidth(150).setMaxWidth(-1), BGUTableColumn.buildColumnId()};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        int tariffPlanId = Utils.parseInt((String)tableParams.get("tariffPlanId"));
        List<TariffVar> tariffVars = this.getContext().getService(TariffService.class, 0).tariffVars(null, Arrays.asList(tariffPlanId));
        List<BGModule> modules = this.getContext().getService(ModuleService.class, 0).moduleList();
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (TariffVar tariffVar : tariffVars) {
            String value = tariffVar.getDefaultValue();
            if (tariffVar.getUpId() > 0 && value.isEmpty()) {
                value = "<\u0437\u043d\u0430\u0447. \u0438\u0437 \u0440\u043e\u0434\u0438\u0442. \u0442\u0430\u0440\u0438\u0444\u0430>";
            }
            value = tariffVar.getType() != null && "list".equals(tariffVar.getType().getType()) ? value.replaceFirst("^(\\d+):(.*)", "$2 [#$1]") : value;
            BGUTableRowData rowData = new BGUTableRowData().addValue("id", String.valueOf(tariffVar.getId())).addValue("child", String.valueOf(tariffVar.getUpId() > 0)).addValue("upId", String.valueOf(tariffVar.getUpId())).addValue("moduleId", String.valueOf(tariffVar.getModuleId())).addValue("moduleName", modules.stream().filter(a -> a.getId() == tariffVar.getModuleId()).findAny().map(a -> a.getTitle()).orElse("\u043b\u044e\u0431\u043e\u0439")).addValue("type", tariffVar.getType().name()).addValue("typeTitle", tariffVar.getType() != null ? tariffVar.getType().getTitle() : "").addValue("title", tariffVar.getTitle()).addValue("value", value).addValue("defaultValue", tariffVar.getDefaultValue());
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

