/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ChangeContractLimitEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractLimitUserLow;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.common.Utils;

public class ActionLimit
extends AbstractAction {
    private static final Map<Integer, String> dMap = new HashMap<Integer, String>();

    public ActionLimit() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.setResultParam("jspPage", "contract/limit.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../contract/limit");
        }
    }

    public void log() throws BGException {
        GregorianCalendar dateFrom = new GregorianCalendar();
        ((Calendar)dateFrom).add(2, -3);
        this.setResultParam("moveList", new LimitManager(this.con).getUserLimitMove(this.contractId, dateFrom, null));
        this.requestDispatcher(this.moduleName, "limit_log");
    }

    public void limit() throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, -1);){
            LimitManager limitManager = new LimitManager(this.con);
            Contract contract = (Contract)contractDao.get(this.contractId);
            this.setResultParam("limit", contract.getBalanceLimit());
            this.setResultParam("dMap", dMap);
            ContractLimitParameters contractLimitParameters = limitManager.getContractLimitParameters(this.setup, contract);
            if (contractLimitParameters != null) {
                this.setResultParam("contractLimitParameters", contractLimitParameters);
            }
            this.setResultParam("rand", Utils.guid());
            if (this.context.getRequest().getParameter("sum") != null) {
                String requestRand = this.req.get("rand");
                String sessionRand = (String)this.context.getRequest().getSession().getAttribute("rand");
                if (!Utils.notBlankString(sessionRand) || !requestRand.equals(sessionRand)) {
                    this.context.getRequest().getSession().setAttribute("rand", (Object)requestRand);
                    int days = contractLimitParameters.getMaxDays();
                    BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).abs();
                    ChangeContractLimitEvent event = new ChangeContractLimitEvent(this.contractId, -1);
                    event = EventProcessor.getInstance().request(event);
                    if (Utils.notBlankString(event.getMessage())) {
                        throw new BGMessageException(event.getMessage());
                    }
                    if (!event.isProcessed() && contractLimitParameters != null && sum.compareTo(BigDecimal.ZERO) > 0 && days > 0 && contract.getBalanceMode() == 1) {
                        if (sum.compareTo(contractLimitParameters.getMinSumm()) < 0 || sum.compareTo(contractLimitParameters.getMaxSumm()) > 0) {
                            throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + Utils.formatBigDecimalSumm(contractLimitParameters.getMinSumm()) + " \u0434\u043e " + Utils.formatBigDecimalSumm(contractLimitParameters.getMaxSumm()));
                        }
                        if (contract.getBalanceLimit().subtract(sum).compareTo(contractLimitParameters.getMinLimit()) < 0) {
                            throw new BGMessageException("\u041f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0438\u0436\u0435 " + Utils.formatBigDecimalSumm(contractLimitParameters.getMinLimit()) + " \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
                        }
                        limitManager.lowLimit(this.contractId, sum, days);
                        this.context.publishAfterCommit(new ContractLimitUserLow(this.userId, this.contractId, sum, days));
                        this.context.publishAfterCommit(new SystemLimitChangedEvent(this.contractId, contract.getBalanceLimit()));
                        this.context.publishAfterCommit(new LimitChangedEvent(this.contractId, contract.getBalanceLimit()));
                    }
                }
            }
            contract = (Contract)contractDao.get(this.contractId);
            this.setResultParam("limit", contract.getBalanceLimit());
        }
        catch (BGMessageException ex) {
            this.setResultParam("error", ex.getMessage());
        }
        this.requestDispatcher(this.moduleName, "limit_form");
    }

    static {
        dMap.put(1, " \u0434\u0435\u043d\u044c");
        dMap.put(2, " \u0434\u043d\u044f");
        dMap.put(3, " \u0434\u043d\u044f");
        dMap.put(4, " \u0434\u043d\u044f");
        dMap.put(5, " \u0434\u043d\u0435\u0439");
        dMap.put(6, " \u0434\u043d\u0435\u0439");
        dMap.put(7, " \u0434\u043d\u0435\u0439");
        dMap.put(8, " \u0434\u043d\u0435\u0439");
        dMap.put(9, " \u0434\u043d\u0435\u0439");
        dMap.put(10, " \u0434\u043d\u0435\u0439");
    }
}

