/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class JabberSender {
    private String accServ = null;
    private String accLogi = null;
    private String accPass = null;
    private String accReso = null;
    private XMPPConnection connection = null;

    public JabberSender(String jid, String password) {
        this(jid, password, null);
    }

    public JabberSender(String jid, String password, String connectServer) {
        this.accPass = password;
        int pi = jid.indexOf("/");
        if (pi != -1) {
            this.accReso = jid.substring(pi + 1);
            jid = jid.substring(0, pi);
        }
        if ((pi = jid.indexOf("@")) != -1) {
            this.accServ = jid.substring(pi + 1);
            this.accLogi = jid.substring(0, pi);
        }
        if (connectServer != null) {
            this.accServ = connectServer;
        }
    }

    public void connect() throws Exception {
        try {
            this.connection = new XMPPConnection(this.accServ);
            this.connection.connect();
            this.connection.login(this.accLogi, this.accPass, this.accReso);
        }
        catch (XMPPException e) {
            this.disconnect();
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043b\u043e\u0433\u0438\u043d\u0430: " + e.getMessage());
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = null;
    }

    public void send(String jid, String subject, String body) throws Exception {
        if (this.connection == null) {
            throw new Exception("\u041d\u0435\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u0430");
        }
        Message msg = new Message();
        msg.setSubject(subject);
        msg.setBody(body);
        msg.setTo(jid);
        msg.setType(Message.Type.chat);
        this.connection.sendPacket((Packet)msg);
    }
}

