/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ConverterRegisterItemTables
extends AbstractBGConverter {
    private static final String NEED_CONVERT_KEY = "add_column_to_payment_register_item";

    @Override
    public void runConverter(Connection connection) {
        boolean alreadyWasRunned = Utils.maskBlank((String)ServerUtils.getSetupValue(connection, NEED_CONVERT_KEY), (String)"0").equals("1");
        if (alreadyWasRunned) {
            return;
        }
        this.getLogger().info("\u0417\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0435\u0440\u0430 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 payment_register_item");
        try {
            for (String tableName : this.findAllTables(connection)) {
                if (ServerUtils.columnExist(connection, tableName, "extra_params")) continue;
                this.getLogger().info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u043e\u043d\u043a\u0438 extra_params \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443: " + tableName);
                this.createColumnToTable(connection, tableName);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        ServerUtils.setSetupValue(connection, NEED_CONVERT_KEY, "1");
        this.getLogger().info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0435\u0440 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043e\u0442\u0440\u0430\u0431\u043e\u0442\u0430\u043b.");
    }

    private List<String> findAllTables(Connection connection) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        String query = "SHOW TABLES LIKE 'payment_register_item%'";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        return result;
    }

    private void createColumnToTable(Connection connection, String tableName) throws SQLException {
        String query = "ALTER TABLE " + tableName + " ADD COLUMN extra_params TEXT";
        try (Statement st = connection.createStatement();){
            st.executeUpdate(query);
        }
    }
}

