/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ParamPhoneTableCellEditor
implements TableCellEditor {
    JTextField tf = new JTextField();
    DefaultCellEditor textFieldEditor;
    DocumentListener documentListener;

    public ParamPhoneTableCellEditor(BGUTable table, int FONT_SIZE, final int customLengthNumber, final String formats) {
        this.tf.setBorder(new LineBorder(Color.darkGray));
        this.textFieldEditor = new DefaultCellEditor(this.tf);
        this.tf.setFont(new Font("Dialog", 0, FONT_SIZE));
        this.documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setTextPhoneField();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setTextPhoneField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setTextPhoneField();
            }

            private void setTextPhoneField() {
                String phoneText = ParamPhoneTableCellEditor.this.tf.getText().replaceAll("[^\\d]", "");
                if (phoneText.length() > 11 && phoneText.length() > customLengthNumber) {
                    phoneText = phoneText.substring(0, Math.max(11, customLengthNumber));
                }
                if (phoneText.length() > 14) {
                    phoneText = phoneText.substring(0, 14);
                }
                phoneText = PhoneUtils.getPhones(new EntityAttrPhone(0, 0, phoneText, ""), formats);
                if (ParamPhoneTableCellEditor.this.tf.getText().equals(phoneText)) {
                    return;
                }
                SwingUtilities.invokeLater(new UpdatePhoneField(ParamPhoneTableCellEditor.this, ParamPhoneTableCellEditor.this.tf, phoneText));
            }
        };
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.textFieldEditor.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.textFieldEditor.cancelCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.textFieldEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.textFieldEditor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.textFieldEditor.isCellEditable(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.textFieldEditor.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.tf.getDocument().removeDocumentListener(this.documentListener);
        if (table.convertColumnIndexToModel(column) == 0) {
            this.tf.getDocument().addDocumentListener(this.documentListener);
        }
        return this.textFieldEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    class UpdatePhoneField
    implements Runnable {
        private JTextField phoneField;
        private String text;

        public UpdatePhoneField(ParamPhoneTableCellEditor this$0, JTextField phoneField, String text) {
            this.phoneField = phoneField;
            this.text = text;
        }

        @Override
        public void run() {
            this.phoneField.setText(this.text);
        }
    }
}

