/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import bitel.billing.server.admin.bgsecure.bean.MenuRestrictManager;
import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.BGSQueryLogParam;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.GroupRight;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserRightRule;
import ru.bitel.bgbilling.kernel.bgsecure.common.event.UserInfoModifiedEvent;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.GroupRightDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserMenuDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserPermitionsManager;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserRightRuleDao;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService")
public class UserServiceImpl
extends AbstractService
implements UserService {
    private UserMenuDao userMenuDao;
    private UserRightRuleDao userRightRuleDao;

    @PostConstruct
    private void init() {
        this.userMenuDao = new UserMenuDao(this.getConnection());
        this.userRightRuleDao = new UserRightRuleDao(this.getConnection());
    }

    @Override
    public String getCurrentUserEmail() throws Exception {
        String email = null;
        UserManager userManager = new UserManager(this.getConnection());
        User user = (User)userManager.get(this.userId);
        if (user != null) {
            email = user.getEmail();
        }
        return email;
    }

    @Override
    public SearchResult<User> findUsers(String field, String value, int status, int groupId, Page page, int roleId) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setAttribute("field", field);
        searchResult.setAttribute("value", value);
        searchResult.setAttribute("status", String.valueOf(status));
        searchResult.setAttribute("groupId", String.valueOf(groupId));
        searchResult.setAttribute("roleId", String.valueOf(roleId));
        UserManager userManager = new UserManager(this.getConnection());
        userManager.findSearchResult((SearchResult<User>)searchResult);
        ContractUtils contractUtils = new ContractUtils(this.getConnection());
        for (User user : searchResult.getList()) {
            user.setContractTitle(contractUtils.getContractTitle(user.getContractCid(), false, null));
        }
        return searchResult;
    }

    @Override
    public void deleteUser(int userId) throws Exception {
        new UserManager(this.getConnection()).delete(userId);
    }

    @Override
    public User getUser(int userId) throws Exception {
        User user = (User)new UserManager(this.getConnection()).get(userId);
        ContractUtils cu = new ContractUtils(this.getConnection());
        user.setContractTitle(cu.getContractTitle(user.getContractCid(), false, null));
        return user;
    }

    @Override
    public void updateUser(User user, List<Integer> groups) throws Exception {
        if (user.getId() < -1 || user.getLogin() == null || user.getName() == null || user.getDescription() == null) {
            throw new BGIllegalArgumentException();
        }
        UserManager userManager = new UserManager(this.getConnection());
        if (userManager.checkLogin(user.getLogin(), user.getId())) {
            throw new BGMessageException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + user.getLogin() + "\" - \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        userManager.update((Object)user);
        this.getConnection().commit();
        UserMap.initUserMap(this.getConnection());
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId(), true));
        this.context.publishAfterCommit(new UserInfoModifiedEvent());
    }

    @Override
    public List<User> listUsers() throws Exception {
        return new UserManager(this.getConnection()).list();
    }

    @Override
    public UserInfo userInfoGet(int userId) throws Exception {
        return this.context.getDirectory(UserInfo.class, 0).get(userId);
    }

    @Override
    public List<UserInfo> userInfoList() throws Exception {
        return this.context.getDirectory(UserInfo.class, 0).list();
    }

    @Override
    public List<BGSAction> loadUserActions(int userId) throws Exception {
        return new UserPermitionsManager(this.getConnection()).getUserActions(userId);
    }

    @Override
    public String userMenuRestriction(int userId) throws Exception {
        if (userId < -1) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 userId");
        }
        MenuRestrictManager menuRestrictManager = new MenuRestrictManager(this.getConnection());
        return this.menuRestriction(menuRestrictManager.menuBarList(), menuRestrictManager.getUserMenuRestrictions(userId));
    }

    @Override
    public String groupMenuRestriction(int groupId) throws Exception {
        if (groupId < 0) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 groupId");
        }
        MenuRestrictManager menuRestrictManager = new MenuRestrictManager(this.getConnection());
        return this.menuRestriction(menuRestrictManager.menuBarList(), menuRestrictManager.getGroupMenuRestrictions(groupId));
    }

    private String menuRestriction(List<String[]> menuBarList, Map<String, Boolean> restrictions) {
        JSONArray data = new JSONArray();
        for (String[] menuItem : menuBarList) {
            String id = menuItem[0];
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("id", (Object)id);
            jsonItem.put("title", (Object)menuItem[1]);
            jsonItem.put("hidden", restrictions.getOrDefault(id, Boolean.FALSE).booleanValue());
            data.put((Object)jsonItem);
        }
        JSONObject jsonData = new JSONObject();
        jsonData.put("menu", (Object)data);
        return jsonData.toString();
    }

    @Override
    public void userMenuRestrictionSet(int userId, List<String> menuIds) throws Exception {
        if (userId < -1) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 userId");
        }
        if (menuIds == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 (menuIds==null)");
        }
        MenuRestrictManager menuRestrictManager = new MenuRestrictManager(this.getConnection());
        Map<String, Boolean> currentIds = menuRestrictManager.getUserMenuRestrictions(userId);
        for (String menuId : menuIds) {
            if (currentIds.containsKey(menuId)) {
                currentIds.remove(menuId);
                continue;
            }
            menuRestrictManager.addUserMenuRestriction(userId, menuId, true);
        }
        for (String menuId : currentIds.keySet()) {
            menuRestrictManager.deleteUserMenuRestriction(userId, menuId);
        }
    }

    @Override
    public void groupMenuRestrictionSet(int groupId, List<String> menuIds) throws Exception {
        if (groupId < 0 || menuIds == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 groupId \u0438\u043b\u0438 menuIds==null");
        }
        MenuRestrictManager menuRestrictManager = new MenuRestrictManager(this.getConnection());
        Map<String, Boolean> currentIds = menuRestrictManager.getGroupMenuRestrictions(groupId);
        for (String menuId : menuIds) {
            if (currentIds.containsKey(menuId)) {
                currentIds.remove(menuId);
                continue;
            }
            menuRestrictManager.addGroupMenuRestriction(groupId, menuId, true);
        }
        for (String menuId : currentIds.keySet()) {
            menuRestrictManager.deleteGroupMenuRestriction(groupId, menuId);
        }
    }

    @Override
    public List<MenuItem> userMenuList(boolean addDefault) throws Exception {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        if (addDefault) {
            list.add(new MenuItem(-1, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
        }
        list.addAll(this.userMenuDao.list());
        this.userMenuDao.setRoleCount(list);
        return list;
    }

    @Override
    public MenuItem userMenuUpdate(MenuItem menuItem) throws Exception {
        boolean newMenu = menuItem.getId() < 1;
        this.userMenuDao.update((Object)menuItem);
        if (newMenu) {
            try {
                this.userMenuDataUpdate(menuItem.getId(), Files.readString(Paths.get("data", Setup.getSetup().get("file.menu", "menu.xml"))));
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
        return menuItem;
    }

    @Override
    public void userMenuDelete(int userMenuId) throws Exception {
        this.userMenuDao.delete(userMenuId);
    }

    @Override
    public String userMenuDataGet(int userMenuId) throws Exception {
        return this.userMenuDao.getData(userMenuId);
    }

    @Override
    public void userMenuDataUpdate(int userMenuId, String data) throws Exception {
        this.userMenuDao.updateData(userMenuId, data);
    }

    @Override
    public String userMenuDataDefault() throws Exception {
        return Files.readString(Paths.get("data", Setup.getSetup().get("file.menu", "menu.xml")));
    }

    @Override
    public JSONObject contractParameters(int parameterTypeId) throws Exception {
        JSONObject json = new JSONObject();
        JSONArray parameters = new JSONArray();
        json.put("contractParameters", (Object)parameters);
        json.put("groupDefaultRead", (Object)this.getSetup().get("contract.parameter.rule.read.group", ""));
        json.put("userDefaultRead", (Object)this.getSetup().get("contract.parameter.rule.read.user", ""));
        json.put("groupDefaultWrite", (Object)this.getSetup().get("contract.parameter.rule.write.group", ""));
        json.put("userDefaultWrite", (Object)this.getSetup().get("contract.parameter.rule.write.user", ""));
        ContractParameterPrefDao dao = new ContractParameterPrefDao(this.getConnection());
        for (ContractParameterPref parameterPref : dao.getContractParameterPrefList(ContractParameterPrefType.getType(parameterTypeId))) {
            JSONObject row = new JSONObject().put("id", (Object)String.valueOf(parameterPref.getId())).put("type", (Object)(switch (parameterPref.getType().getId()) {
                case 1 -> "\u0422\u0435\u043a\u0441\u0442";
                case 2 -> "\u0410\u0434\u0440\u0435\u0441";
                case 3 -> "E-mail";
                case 4 -> "\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
                case 5 -> "\u0424\u043b\u0430\u0433";
                case 6 -> "\u0414\u0430\u0442\u0430";
                case 7 -> "\u0421\u043f\u0438\u0441\u043e\u043a";
                case 8 -> "\u0414\u043e\u0433\u043e\u0432\u043e\u0440";
                case 9 -> "\u0422\u0435\u043b\u0435\u0444\u043e\u043d";
                case 10 -> "\u0420\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c";
                case 11 -> "\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a";
                default -> "???";
            })).put("title", (Object)parameterPref.getTitle()).put("read", parameterPref.isRead()).put("write", parameterPref.isWrite()).put("history", parameterPref.isHistory()).put("alwaysVisible", parameterPref.isAlwaysVisible());
            parameters.put((Object)row);
        }
        return json;
    }

    @Override
    public GroupRight groupRightTree() throws Exception {
        Connection con = this.getConnection();
        try (GroupRightDao groupRightDao = new GroupRightDao(con);){
            ModuleManager moduleManager = new ModuleManager(con);
            Map<Integer, BGModule> modulesMap = moduleManager.getModulesMap();
            GroupRight rootGroupRight = new GroupRight();
            rootGroupRight.setTitle("\u0413\u0440\u0443\u043f\u043f\u044b \u043f\u0440\u0430\u0432");
            List<GroupRight> list = groupRightDao.list();
            for (GroupRight groupRight : list) {
                BGModule bgModule = modulesMap.get(groupRight.getModuleId());
                if (bgModule == null) continue;
                groupRight.setModule(bgModule.getName());
            }
            Object object = (GroupRight)TreeUtils.tree(list, (Node)rootGroupRight);
            return object;
        }
    }

    @Override
    public List<UserRightRule> getUserRightRules(int rightGroupId) throws Exception {
        return this.userRightRuleDao.getUserRightRules(rightGroupId);
    }

    @Override
    public UserRightRule updateUserRightRule(UserRightRule userRightRule) throws Exception {
        this.userRightRuleDao.update(userRightRule);
        return userRightRule;
    }

    @Override
    public SearchResult<BGSQueryLogEntry> bgsQueryLog(BGSQueryLogParam bgsQueryLogParam, Period period, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page);
        new BGSQueryLogDao(this.getConnection()).getLogTable(bgsQueryLogParam, (SearchResult<BGSQueryLogEntry>)searchResult);
        return searchResult;
    }
}

