/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.ActionContractBalanceBase;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionContractBalanceAll
extends ActionContractBalanceBase {
    @Override
    public void doAction() throws Exception {
        String date1 = this.getParameter("date1");
        String date2 = this.getParameter("date2");
        this.balance(TimeUtils.parseCalendar((String)date1, (String)"dd.MM.yyyy"), TimeUtils.parseCalendar((String)date2, (String)"dd.MM.yyyy"));
    }

    public void balance(Calendar d1, Calendar d2) {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            ContractDao contractDao;
            Contract contract;
            if (this.cid < 0 || d1 == null || d2 == null) {
                this.getLogger().error("Error in params ActionContractBalanceAll::balance()");
                return;
            }
            String xslUrl = this.setup.getPathProperty("contract.xslt", null);
            String output = this.getParameter("output", "html");
            if ("csv".equals(output)) {
                xslUrl = this.setup.getPathProperty("contract.csv.xslt", "contract_balance_print_csv.xsl");
            }
            if (xslUrl != null) {
                this.rootNode.setAttribute("xslt", xslUrl);
            }
            if ((contract = (Contract)(contractDao = new ContractDao(this.con, 0)).get(this.cid)) != null) {
                this.rootNode.setAttribute("contractTitle", contract.getTitle());
                this.rootNode.setAttribute("comment", contract.getComment());
            }
            this.rootNode.setAttribute("date1", TimeUtils.format((Calendar)d1, (String)"dd.MM.yyyy"));
            this.rootNode.setAttribute("date2", TimeUtils.format((Calendar)d2, (String)"dd.MM.yyyy"));
            Date lastMonth = bu.getLastBalanceMonth(contract);
            String lastOutBalance = Utils.formatBigDecimalSumm((BigDecimal)bu.getBalance(lastMonth, this.cid));
            while (d1.before(d2) || d1.equals(d2)) {
                Element balance;
                Element month = this.createElement(this.rootNode, "month");
                String mmyy = TimeUtils.monthNames[d1.get(2)] + "  " + d1.get(1);
                month.setAttribute("title", mmyy);
                GregorianCalendar date1 = new GregorianCalendar(d1.get(1), d1.get(2), 1);
                d1.set(5, 1);
                Calendar date2 = (Calendar)d1.clone();
                date2.add(2, 1);
                date2.set(5, 1);
                date2.add(6, -1);
                d1.add(2, 1);
                Period period = new Period();
                period.setDateFrom(date1.getTime());
                period.setDateTo(date2.getTime());
                if (lastMonth != null && lastMonth.compareTo(date1.getTime()) < 0) {
                    balance = this.createElement(month, "balance");
                    Element table = this.createElement(balance, "table");
                    table.setAttribute("summa1", lastOutBalance);
                    table.setAttribute("summa2", "0.00");
                    table.setAttribute("summa3", "0.00");
                    table.setAttribute("summa4", "0.00");
                    table.setAttribute("summa5", lastOutBalance);
                    Element account = this.createElement(month, "account");
                    Element table1 = this.createElement(account, "table");
                    table1.setAttribute("summa", "0.00");
                    Element charge = this.createElement(month, "charge");
                    Element table2 = this.createElement(charge, "table");
                    table2.setAttribute("summa", "0.00");
                    Element payment = this.createElement(month, "payment");
                    Element table3 = this.createElement(payment, "table");
                    table3.setAttribute("summa", "0.00");
                    continue;
                }
                balance = this.createElement(month, "balance");
                this.balance(balance, period);
                Element account = this.createElement(month, "account");
                this.balanceAccount(account, period, contractDao);
                Element charge = this.createElement(month, "charge");
                this.balanceCharges(charge, period, contractDao);
                Element payment = this.createElement(month, "payment");
                this.balancePayments(payment, period);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

