/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.ToolBarButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class BGDialogToolBar
extends JToolBar
implements ActionListener {
    private Map<String, ToolBarButton> buttons = new HashMap<String, ToolBarButton>();
    private ActionListener actionListener = null;

    public BGDialogToolBar() {
        this.setOpaque(false);
        this.setBorder(null);
    }

    public void setButtons(Map<String, ToolBarButton> buttons) {
        this.buttons = buttons;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setDefaultButtons(ActionListener actionListener, ButtonData ... buttons) {
        this.actionListener = actionListener;
        for (ButtonData b : buttons) {
            this.addButton(b.name, b.img, b.tipText);
        }
        this.setToolBar(Stream.of(buttons).map(ButtonData::getName).toList());
    }

    public void setDefaultButtons(ActionListener actionListener) {
        this.setDefaultButtons(actionListener, ButtonData.values());
    }

    public void addButton(String name, String img, String tipText) {
        ToolBarButton button = new ToolBarButton(name, img != null ? ClientUtils.getIcon(img) : null, tipText);
        button.addActionListener(this);
        this.buttons.put(button.getActionCommand(), button);
    }

    public JButton addButton(Action action) {
        ToolBarButton button = new ToolBarButton(action);
        if (Utils.isEmptyString(button.getToolTipText())) {
            button.setToolTipText((String)action.getValue("Name"));
        }
        button.setHideActionText(true);
        this.add(button);
        return button;
    }

    public void setToolBar(List<String> data) {
        this.setToolBar(data.toArray(new String[0]));
    }

    public void setToolBar(String[] data) {
        this.removeAll();
        if (data == null || data.length == 0) {
            return;
        }
        for (String buttonName : data) {
            this.add(buttonName);
        }
        this.repaint();
    }

    private void add(String buttonName) {
        if (buttonName == null) {
            return;
        }
        if ("separator".equals(buttonName)) {
            this.addSeparator();
        } else if (this.buttons.containsKey(buttonName)) {
            this.add(this.buttons.get(buttonName));
        }
    }

    public void setButtonsEnabled(Map<String, ?> buttonsEnabled) {
        if (buttonsEnabled == null || buttonsEnabled.size() == 0) {
            return;
        }
        if (buttonsEnabled.containsKey("all")) {
            boolean enabled = (Boolean)buttonsEnabled.get("all");
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof ToolBarButton)) continue;
                comp.setEnabled(enabled);
            }
            return;
        }
        for (String buttonName : buttonsEnabled.keySet()) {
            if (!this.buttons.containsKey(buttonName)) continue;
            boolean enabled = (Boolean)buttonsEnabled.get(buttonName);
            ToolBarButton button = this.buttons.get(buttonName);
            button.setEnabled(enabled);
        }
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (!(comp instanceof ToolBarButton)) continue;
            comp.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        e.setSource(this);
        this.actionListener.actionPerformed(e);
    }

    public void compact() {
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            AbstractButton abstractbutton;
            Component component = this.getComponentAtIndex(i);
            if (!(component instanceof AbstractButton) || (abstractbutton = (AbstractButton)component).getIcon() == null) continue;
            abstractbutton.setMargin(new Insets(0, 0, 0, 0));
            abstractbutton.setRequestFocusEnabled(false);
        }
    }

    public static enum ButtonData {
        NEW_ITEM("newItem", "add", "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"),
        COPY_ITEM("copyItem", "item_copy", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"),
        EDIT_ITEM("editItem", "edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"),
        DELETE_ITEM("deleteItem", "delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"),
        DELETE_ALL_ITEM("deleteAllItem", "item_delete_all", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b"),
        UP_ITEM("upItem", "arrow_up", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445 \u043d\u0430 \u043e\u0434\u043d\u0443 \u0441\u0442\u0440\u043e\u043a\u0443"),
        DOWN_ITEM("downItem", "arrow_down", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437 \u043d\u0430 \u043e\u0434\u043d\u0443 \u0441\u0442\u0440\u043e\u043a\u0443"),
        REFRESH("refresh", "refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"),
        PROPERTIES("properties", "item_properties", "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430"),
        REPORT("report", "report", "\u041e\u0442\u0447\u0435\u0442"),
        FILTER("filter", "filter", "\u0424\u0438\u043b\u044c\u0442\u0440"),
        SPLIT2("split2", "split2", "\u0420\u0430\u0437\u0431\u0438\u0442\u044c \u043d\u0430 \u0434\u0432\u0430 \u043f\u043e\u0434\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430"),
        SPLIT3("split3", "split3", "\u0420\u0430\u0437\u0431\u0438\u0442\u044c \u043d\u0430 \u0442\u0440\u0438 \u043f\u043e\u0434\u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430"),
        IMPORT("import", "import", "\u0418\u043c\u043f\u043e\u0440\u0442"),
        EXPORT("export", "export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442"),
        SEPARATOR("separator", "", "");

        String name;
        String img;
        String tipText;

        private ButtonData(String name, String img, String tipText) {
            this.name = name;
            this.img = img;
            this.tipText = tipText;
        }

        public String getName() {
            return this.name;
        }

        public String getImg() {
            return this.img;
        }

        public String getTipText() {
            return this.tipText;
        }

        public static ButtonData of(String name) {
            return Stream.of(ButtonData.values()).filter(a -> a.getName().equals(name)).findFirst().orElseThrow();
        }
    }
}

