/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E> {
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition notEmpty = this.lock.newCondition();
    protected final Condition notFull = this.lock.newCondition();
    protected final int capacity;
    protected int count;

    public AbstractBlockingDeque(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.linkFirst(e, true);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract boolean linkFirst(E var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.linkLast(e, true);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract boolean linkLast(E var1, boolean var2);

    @Override
    public void putFirst(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (!this.linkFirst(e, true)) {
                this.notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (!this.linkLast(e, true)) {
                this.notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (!this.linkFirst(e, true)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (!this.linkLast(e, true)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.unlinkFirst();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract E unlinkFirst();

    @Override
    public E pollLast() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.unlinkLast();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract E unlinkLast();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkFirst()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            E x;
            while ((x = this.unlinkLast()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E getFirst() {
        Object x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        Object x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = Math.min(maxElements, this.count);
            for (int i = 0; i < n; ++i) {
                c.add(this.first());
                this.unlinkFirst();
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract E first();

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }
}

