/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.api;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;
import org.json.XML;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPayment;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MegafonKassaApiClient
extends BGLogger {
    private final ModuleSetup moduleSetup;

    public MegafonKassaApiClient(ModuleSetup moduleSetup) {
        this.moduleSetup = moduleSetup;
    }

    public MegafonKassaApiClient(int moduleId) {
        this(Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)));
    }

    public boolean addPayment(int contractId, String msisdn, BigDecimal amount, String comment) {
        if (Utils.isBlankString((String)msisdn)) {
            throw new RuntimeException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d MSISDN!");
        }
        String kassaLogin = this.moduleSetup.get("megafon.kassa.login");
        String kassaPass = this.moduleSetup.get("megafon.kassa.password");
        if (Utils.isBlankString((String)kassaLogin) || Utils.isBlankString((String)kassaPass)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043a\u0430\u0441\u0441\u044b!");
        }
        LocalDateTime paymentTime = LocalDateTime.now();
        JSONObject parameters = new JSONObject();
        parameters.put("P_LOGIN_NAME", (Object)kassaLogin);
        parameters.put("P_LOGIN_PASSWD", (Object)kassaPass);
        parameters.put("P_MSISDN", (Object)msisdn);
        parameters.put("P_PAY_AMOUNT", (Object)amount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        parameters.put("P_DATE", (Object)TimeUtils.format((LocalDateTime)paymentTime, (String)"dd.MM.yyyy HH:mm:ss"));
        if (Utils.notBlankString((String)comment)) {
            parameters.put("P_COMMENT", (Object)comment);
        }
        String receiptNum = "PAY_" + paymentTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "_" + contractId;
        parameters.put("P_RECEIPT_NUM", (Object)receiptNum);
        try {
            JSONObject response = this.sendMegafonKassaRequest(msisdn, parameters);
            JSONObject error = response.getJSONObject("KKM_PG_GATE").getJSONObject("ERROR");
            int sqlCode = error.getInt("SQLCODE");
            if (sqlCode > 0) {
                String errMsg = error.optString("SQLERRM", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                throw new RuntimeException(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. SQLCODE=%d, SQLERRM=%s, MSISDN=%s", sqlCode, errMsg, msisdn));
            }
            this.saveMegafonPaymentInfo(contractId, msisdn, amount, paymentTime, this.getCheckNumber(response));
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean accountExists(String msisdn) {
        if (Utils.isBlankString((String)msisdn)) {
            throw new RuntimeException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d MSISDN!");
        }
        String kassaLogin = this.moduleSetup.get("megafon.kassa.login");
        String kassaPass = this.moduleSetup.get("megafon.kassa.password");
        if (Utils.isBlankString((String)kassaLogin) || Utils.isBlankString((String)kassaPass)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043a\u0430\u0441\u0441\u044b!");
        }
        JSONObject parameters = new JSONObject();
        parameters.put("P_LOGIN_NAME", (Object)kassaLogin);
        parameters.put("P_LOGIN_PASSWD", (Object)kassaPass);
        parameters.put("P_MSISDN", (Object)msisdn);
        JSONObject response = this.sendMegafonKassaRequest(msisdn, parameters);
        JSONObject error = response.getJSONObject("KKM_PG_GATE").getJSONObject("ERROR");
        return error.getInt("SQLCODE") == 0;
    }

    private JSONObject sendMegafonKassaRequest(String msisdn, JSONObject parameters) {
        HttpRequest request = HttpRequest.newBuilder().timeout(Duration.ofSeconds(3L)).uri(this.createURI("/HTTP_ADD_PAYMENT", parameters)).GET().build();
        HttpClient client = HttpClient.newBuilder().sslContext(MegafonSSLContext.getSSLContext(this.moduleSetup)).connectTimeout(Duration.ofSeconds(3L)).build();
        this.getLogger().debug("\u041c\u0435\u0433\u0430\u0444\u043e\u043d-\u041a\u0430\u0441\u0441\u0430 \u0437\u0430\u043f\u0440\u043e\u0441: {}", (Object)request.toString());
        try {
            HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
            JSONObject response = XML.toJSONObject((String)httpResponse.body());
            this.getLogger().debug("\u041c\u0435\u0433\u0430\u0444\u043e\u043d-\u041a\u0430\u0441\u0441\u0430 \u043e\u0442\u0432\u0435\u0442: {}", (Object)response);
            if (httpResponse.statusCode() != 200) {
                throw new RuntimeException(String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0432\u0435\u0437\u0442\u0438 \u043f\u043b\u0430\u0442\u0435\u0436 \u0432 \u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041a\u043e\u0434=%s, \u041e\u0442\u0432\u0435\u0442=%s, MSISDN=%s", httpResponse.statusCode(), response, msisdn));
            }
            return response;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String getCheckNumber(JSONObject megafonKassaResponse) {
        String fullReceipt = megafonKassaResponse.getJSONObject("KKM_PG_GATE").getJSONObject("RECEIPTS").getString("RECEIPT");
        String[] parts = fullReceipt.split("-");
        return parts[0];
    }

    private void saveMegafonPaymentInfo(int contractId, String msisdn, BigDecimal amount, LocalDateTime time, String checkNumber) throws Exception {
        MegafonPayment payment = new MegafonPayment();
        payment.setContractId(contractId);
        payment.setMsisdn(msisdn);
        payment.setAmount(amount);
        payment.setPaymentDate(time);
        payment.setCheckNumber(checkNumber);
        ServerContext serverContext = (ServerContext)ServerContext.get();
        ((MegafonService)serverContext.getService(MegafonService.class, serverContext.getModuleId())).updateMegafonPayment(payment);
        serverContext.commit();
    }

    public void sendReport(Path xmlReport, LocalDate date) {
        if (xmlReport == null || !Files.exists(xmlReport, new LinkOption[0])) {
            throw new RuntimeException("\u0424\u0430\u0439\u043b \u0438\u0442\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u0440\u0435\u0435\u0441\u0442\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + String.valueOf(xmlReport));
        }
        if (date == null) {
            throw new RuntimeException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u0440\u0435\u0435\u0441\u0442\u0440\u0430!");
        }
        String kassaLogin = this.moduleSetup.get("megafon.kassa.login");
        String kassaPass = this.moduleSetup.get("megafon.kassa.password");
        if (Utils.isBlankString((String)kassaLogin) || Utils.isBlankString((String)kassaPass)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043a\u0430\u0441\u0441\u044b!");
        }
        String host = this.moduleSetup.get("megafon.kassa.host");
        if (Utils.isBlankString((String)host)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0445\u043e\u0441\u0442 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f!");
        }
        try {
            String boundary = "----Boundary" + System.currentTimeMillis();
            StringBuilder multipartBody = new StringBuilder();
            multipartBody.append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"P_DATE\"\r\n\r\n").append(TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy")).append("\r\n").append("--").append(boundary).append("\r\n").append("Content-Disposition: form-data; name=\"FILE_DATA\"; filename=\"").append(xmlReport.getFileName().toString()).append("\"\r\n").append("Content-Type: text/xml\r\n\r\n").append(Files.readString(xmlReport)).append("\r\n").append("--").append(boundary).append("--\r\n");
            HttpRequest request = HttpRequest.newBuilder().uri(this.createURI("/HTTP_LOAD_REESTR", null)).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("Authorization", "Basic " + Base64.getEncoder().encodeToString((kassaLogin + ":" + kassaPass).getBytes())).timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(multipartBody.toString())).build();
            this.getLogger().debug("\u041c\u0435\u0433\u0430\u0444\u043e\u043d HTTP_LOAD_REESTR \u0437\u0430\u043f\u0440\u043e\u0441: {}", (Object)request);
            HttpResponse<String> response = HttpClient.newBuilder().sslContext(MegafonSSLContext.getSSLContext(this.moduleSetup)).build().send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = response.body();
            this.getLogger().debug("\u041c\u0435\u0433\u0430\u0444\u043e\u043d HTTP_LOAD_REESTR \u043e\u0442\u0432\u0435\u0442: {}", (Object)responseBody);
            if (response.statusCode() != 200) {
                throw new BGException(String.format("Megafon request error. StatusCode=%s", response.statusCode()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0438\u0442\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u0440\u0435\u0435\u0441\u0442\u0440\u0430. \u0414\u0430\u0442\u0430=" + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy"), e);
        }
    }

    private URI createURI(String method, JSONObject requestParameters) {
        String host = this.moduleSetup.get("megafon.kassa.host");
        if (Utils.isBlankString((String)host)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0445\u043e\u0441\u0442 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f!");
        }
        return URI.create(host + method + this.requestParametersToString(requestParameters));
    }

    private String requestParametersToString(JSONObject requestParameters) {
        StringBuilder sb = new StringBuilder("?");
        boolean first = true;
        if (requestParameters == null || requestParameters.isEmpty()) {
            return "";
        }
        for (String key : requestParameters.keySet()) {
            if (!first) {
                sb.append("&");
            }
            first = false;
            String value = String.valueOf(requestParameters.get(key));
            sb.append(key).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    private static final class MegafonSSLContext
    extends BGLogger {
        private static SSLContext sslContext;

        private MegafonSSLContext() {
        }

        private static SSLContext getSSLContext(ModuleSetup moduleSetup) {
            if (sslContext != null) {
                return sslContext;
            }
            String certPath = moduleSetup.get("megafon.kassa.cert.path", "");
            String certPassword = moduleSetup.get("megafon.kassa.cert.password", "");
            if (Utils.isBlankString((String)certPath)) {
                throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443!");
            }
            if (Utils.isBlankString((String)certPassword)) {
                throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u043e\u043b\u044c \u043a \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0443!");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try (InputStream is = Files.newInputStream(Path.of(certPath, new String[0]), new OpenOption[0]);){
                    keyStore.load(is, certPassword.toCharArray());
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, certPassword.toCharArray());
                TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(keyManagerFactory.getKeyManagers(), trustAllCertificates, new SecureRandom());
                return sslContext;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

