/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPayment;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonPaymentStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class MegafonPaymentDao
extends AbstractIdDao<MegafonPayment> {
    public MegafonPaymentDao(Connection con, int moduleId) {
        super(con, moduleId, "megafon_payment");
    }

    protected MegafonPayment getFromRS(ResultSet rs) throws SQLException, BGException {
        MegafonPayment payment = new MegafonPayment();
        payment.setId(rs.getInt("id"));
        payment.setContractId(rs.getInt("contract_id"));
        payment.setMsisdn(rs.getString("msisdn"));
        payment.setAmount(rs.getBigDecimal("amount"));
        payment.setPaymentDate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("payment_date")));
        payment.setCheckNumber(rs.getString("check_number"));
        payment.setStatus(MegafonPaymentStatus.valueOf((int)rs.getInt("payment_status")));
        return payment;
    }

    protected void updateImpl(MegafonPayment megafonPayment) throws BGException, SQLException {
        String query = (megafonPayment.getId() > 0 ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET contract_id=?, msisdn=?, amount=?, payment_date=?, check_number=?, payment_status=?" + (megafonPayment.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, megafonPayment.getId() > 0 ? 2 : 1);){
            int index = 1;
            ps.setInt(index++, megafonPayment.getContractId());
            ps.setString(index++, megafonPayment.getMsisdn());
            ps.setBigDecimal(index++, megafonPayment.getAmount());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)megafonPayment.getPaymentDate()));
            ps.setString(index++, megafonPayment.getCheckNumber());
            ps.setInt(index++, megafonPayment.getStatus() != null ? megafonPayment.getStatus().ordinal() : -1);
            super.executeUpdate((Id)megafonPayment, index, ps);
        }
    }

    public List<MegafonPayment> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(filter, orderBy, params);
    }

    public void list(SearchResult<MegafonPayment> searchResult) throws BGException {
        List payments = searchResult.getList() != null ? searchResult.getList() : new ArrayList();
        searchResult.setList(payments);
        Page page = searchResult.getPage() != null ? searchResult.getPage() : new Page();
        Period period = searchResult.getPeriod();
        ArrayList<String> filters = new ArrayList<String>();
        ArrayList<Date> paramList = new ArrayList<Date>();
        if (period != null) {
            LocalDate localDate;
            if (period.getDateFrom() != null) {
                filters.add(" payment_date >= ? ");
                localDate = period.getDateFrom().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDateTime startOfDay = localDate.atStartOfDay();
                paramList.add(Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant()));
            }
            if (period.getDateTo() != null) {
                filters.add(" payment_date <= ? ");
                localDate = period.getDateTo().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDateTime endOfDay = localDate.atTime(23, 59, 59, 999999999);
                paramList.add(Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant()));
            }
        }
        String filter = String.join((CharSequence)"AND", filters);
        Result result = super.list(page, filter, "payment_date DESC", paramList.toArray());
        searchResult.setPage(result.getPage());
        payments.addAll(result.getList());
    }
}

