/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.common.Utils;

public class FireMessage
extends BGLogger {
    private Map<String, Object> root;
    private String serverKey;
    private String url;

    public FireMessage(String serverKey, String url, String title, MobileContractNotification notification, int type) throws JSONException {
        this.serverKey = serverKey;
        this.url = url;
        this.root = new HashMap<String, Object>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", title);
        data.put("notificationN", (String)notification);
        this.root.put("data", data);
        if (type == 3) {
            this.root.put("content_available", true);
            boolean donShow = false;
            boolean withoutSound = false;
            if (notification.getParams() != null) {
                donShow = Utils.parseBoolean((String)((String)notification.getParams().get("doNotShow")), (boolean)false);
                withoutSound = Utils.parseBoolean((String)((String)notification.getParams().get("withoutSound")), (boolean)false);
            }
            if (!donShow) {
                HashMap<String, String> notificationd = new HashMap<String, String>();
                notificationd.put("title", title);
                notificationd.put("body", notification.getText());
                if (!withoutSound) {
                    notificationd.put("sound", "default");
                }
                this.root.put("notification", notificationd);
            }
        }
    }

    public String sendToTopic(String topic) {
        System.out.println("Send to Topic");
        this.root.put("condition", "'" + topic + "' in topics");
        return this.sendPushNotification(true);
    }

    public String sendToGroup(JSONArray mobileTokens) {
        this.root.put("registration_ids", mobileTokens);
        return this.sendPushNotification(false);
    }

    public String sendToToken(String token) {
        this.root.put("to", token);
        return this.sendPushNotification(false);
    }

    private String sendPushNotification(boolean toTopic) {
        try {
            int success;
            String output;
            URL url = new URL(this.url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Authorization", "key=" + this.serverKey);
            ObjectMapper mapper = new ObjectMapper();
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(mapper.writeValueAsString(this.root));
            wr.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder builder = new StringBuilder();
            while ((output = br.readLine()) != null) {
                builder.append(output);
            }
            String result = builder.toString();
            JSONObject obj = new JSONObject(result);
            if (toTopic ? obj.has("message_id") : (success = obj.optInt("success", -1)) > 0) {
                return "SUCCESS";
            }
            return builder.toString();
        }
        catch (Exception ex) {
            this.logError(ex);
            return ex.getMessage();
        }
    }
}

