/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.XmlAdapters;

public class ServiceObject
extends Id
implements Serializable {
    private int contractId;
    private int objectId;
    private int serviceId;
    private int userId;
    private BigDecimal cost = null;
    private BigDecimal col = BigDecimal.ONE;
    private String serviceTitle;
    private int entityModuleId;
    private int entityId;
    private Date date1;
    private Date date2;
    public String objTitle;
    private String comment = "";
    private LocalDateTime lastUpdate;

    @XmlAttribute
    public String getObjectTitle() {
        return this.objTitle;
    }

    public void setObjectTitle(String objectTitle) {
        this.objTitle = objectTitle;
    }

    @XmlAttribute
    public Date getDate1() {
        return this.date1;
    }

    public void setDate1(Date serviceDate1) {
        this.date1 = serviceDate1;
    }

    @XmlAttribute
    public Date getDate2() {
        return this.date2;
    }

    public void setDate2(Date serviceDate2) {
        this.date2 = serviceDate2;
    }

    @XmlAttribute
    public String getServiceTitle() {
        return this.serviceTitle;
    }

    public void setServiceTitle(String serviceTitle) {
        this.serviceTitle = serviceTitle;
    }

    @XmlAttribute
    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    @XmlAttribute
    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @XmlAttribute
    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    @XmlAttribute
    public BigDecimal getCol() {
        if (this.col.compareTo(BigDecimal.ZERO) <= 0) {
            this.col = BigDecimal.ONE;
        }
        return this.col;
    }

    public void setCol(BigDecimal col) {
        this.col = col;
    }

    @XmlAttribute
    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @XmlAttribute
    public int getEntityMid() {
        return this.entityModuleId;
    }

    public void setEntityMid(int entityMid) {
        this.entityModuleId = entityMid;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public ServiceObject clone() {
        return ServiceObject.builder().setId(this.id).setContractId(this.contractId).setObjectId(this.objectId).setServiceId(this.serviceId).setUserId(this.userId).setCost(this.cost).setCol(this.col).setEntityModuleId(this.entityModuleId).setEntityId(this.entityId).setDate1(this.date1).setDate2(this.date2).setComment(this.comment).setLastUpdate(this.lastUpdate).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder copy(ServiceObject serviceObject) {
        return new Builder().setId(serviceObject.id).setContractId(serviceObject.contractId).setObjectId(serviceObject.objectId).setServiceId(serviceObject.serviceId).setUserId(serviceObject.userId).setCost(serviceObject.cost).setCol(serviceObject.col).setEntityModuleId(serviceObject.entityModuleId).setEntityId(serviceObject.entityId).setDate1(serviceObject.date1 != null ? (Date)serviceObject.date1.clone() : null).setDate2(serviceObject.date2 != null ? (Date)serviceObject.date2.clone() : null).setComment(serviceObject.comment).setLastUpdate(serviceObject.lastUpdate);
    }

    public static class Builder {
        private ServiceObject serviceObject = new ServiceObject();

        private Builder() {
        }

        public Builder setId(int id) {
            this.serviceObject.id = id;
            return this;
        }

        public Builder setObjectTitle(String objectTitle) {
            this.serviceObject.objTitle = objectTitle;
            return this;
        }

        public Builder setDate1(Date serviceDate1) {
            this.serviceObject.date1 = serviceDate1;
            return this;
        }

        public Builder setDate2(Date serviceDate2) {
            this.serviceObject.date2 = serviceDate2;
            return this;
        }

        public Builder setServiceTitle(String serviceTitle) {
            this.serviceObject.serviceTitle = serviceTitle;
            return this;
        }

        public Builder setObjectId(int objectId) {
            this.serviceObject.objectId = objectId;
            return this;
        }

        public Builder setServiceId(int serviceId) {
            this.serviceObject.serviceId = serviceId;
            return this;
        }

        public Builder setUserId(int userId) {
            this.serviceObject.userId = userId;
            return this;
        }

        public Builder setCost(BigDecimal cost) {
            this.serviceObject.cost = cost;
            return this;
        }

        public Builder setCol(BigDecimal col) {
            this.serviceObject.col = col;
            return this;
        }

        public Builder setEntityId(int entityId) {
            this.serviceObject.entityId = entityId;
            return this;
        }

        public Builder setEntityModuleId(int entityModuleId) {
            this.serviceObject.entityModuleId = entityModuleId;
            return this;
        }

        public Builder setContractId(int contractId) {
            this.serviceObject.contractId = contractId;
            return this;
        }

        public Builder setComment(String comment) {
            this.serviceObject.comment = comment;
            return this;
        }

        public Builder setLastUpdate(LocalDateTime lastUpdate) {
            this.serviceObject.lastUpdate = lastUpdate;
            return this;
        }

        public ServiceObject build() {
            try {
                ServiceObject serviceObject = this.serviceObject;
                return serviceObject;
            }
            finally {
                this.serviceObject = null;
            }
        }
    }
}

