/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelDateWithTime;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseData;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class AddStockItemDialog
extends BGEditorDialog<Warehouse> {
    protected final BGUComboBox<StockItemType> selectType = new BGUComboBox();
    protected JPanel editorPanel;
    private final WarehouseService warehouseService;
    protected final List<AttributePanel> attributePanels = new ArrayList<AttributePanel>();
    private final StockItemType selectedStockItemType;

    public AddStockItemDialog(Warehouse data, StockItemType selectedStockItemType, ClientContext context) {
        super("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u043a\u043b\u0430\u0434", (Object)data);
        this.clientContext = context;
        this.warehouseService = (WarehouseService)context.getPort(WarehouseService.class, context.getModuleId());
        this.selectedStockItemType = selectedStockItemType;
    }

    public void doDialogPanel() {
        this.editorPanel = new JPanel(new BorderLayout());
        this.selectType.setRenderer((ListCellRenderer)new TypeComboboxRenderer(this));
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel selectTypePanel = new JPanel(new GridBagLayout());
        selectTypePanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f"), constraints);
        selectTypePanel.add((Component)this.selectType, constraints);
        selectTypePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.editorPanel.add((Component)selectTypePanel, "North");
        this.init();
        this.panel.setPreferredSize(new Dimension(500, 400));
        this.panel.add((Component)this.editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void init() {
        try {
            this.selectType.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    for (int i = 0; i < this.editorPanel.getComponentCount(); ++i) {
                        if (!(this.editorPanel.getComponent(i) instanceof JScrollPane)) continue;
                        this.editorPanel.remove(i);
                    }
                    this.attributePanels.clear();
                    try {
                        StockItemType type = (StockItemType)this.selectType.getSelectedItem();
                        if (type == null || type.getId() <= 0) {
                            return;
                        }
                        this.loadPanelByStockItemType(type);
                        this.panel.revalidate();
                        this.panel.repaint();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
            ArrayList<StockItemType> types = new ArrayList<StockItemType>();
            types.add(new StockItemType(-1, "\u0422\u0438\u043f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u0430"));
            types.addAll(this.warehouseService.stockItemTypeList());
            this.selectType.setData(types);
            if (this.selectedStockItemType != null) {
                this.selectType.setSelectedItem((Object)this.selectedStockItemType);
            }
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private void loadPanelByStockItemType(StockItemType type) throws Exception {
        StockItemAttributeKit attributeKit = this.defineAttributeKit(type);
        if (attributeKit == null || Utils.isEmptyCollection((Collection)attributeKit.getAttributes())) {
            ClientUtils.showErrorMessageDialog((String)"\u0414\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432");
            return;
        }
        JPanel attributesPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)attributesPanel, (String)"\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
        for (StockItemAttribute attribute : attributeKit.getAttributes()) {
            AttributePanel attributePanel = new AttributePanel(attribute);
            attributesPanel.add((Component)attributePanel, constraints);
            this.attributePanels.add(attributePanel);
        }
        this.editorPanel.add((Component)new JScrollPane(attributesPanel), "Center");
    }

    private StockItemAttributeKit defineAttributeKit(StockItemType stockItemType) throws Exception {
        if (stockItemType.getAttributeKit() != null) {
            return stockItemType.getAttributeKit();
        }
        if (stockItemType.getParentTypeId() > 0) {
            return this.defineAttributeKit(this.warehouseService.getStockItemType(stockItemType.getParentTypeId()));
        }
        return null;
    }

    public boolean doApply() throws Exception {
        StockItemType type = (StockItemType)this.selectType.getSelectedItem();
        if (type == null || type.getId() <= 0) {
            return false;
        }
        ArrayList<StockItemAttributeValue> stockItemAttributeValues = new ArrayList<StockItemAttributeValue>(this.attributePanels.size());
        for (AttributePanel attributePanel : this.attributePanels) {
            String data = attributePanel.getData();
            if (attributePanel.attribute.isRequired() && Utils.isBlankString((String)data)) {
                BGToolTip.showErrorMessage((JComponent)attributePanel, (String)"\u0414\u0430\u043d\u043d\u044b\u0439 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u043a \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e!");
                return false;
            }
            StockItemAttributeValue attributeValue = new StockItemAttributeValue();
            attributeValue.setAttribute(attributePanel.attribute);
            attributeValue.setValue(Utils.maskNull((String)data));
            stockItemAttributeValues.add(attributeValue);
        }
        StockItem stockItem = new StockItem();
        stockItem.setWarehouseId(((Warehouse)this.data).getId());
        stockItem.setType(type);
        stockItem.setTitle(type.getTitle());
        stockItem.setAttributeValues(stockItemAttributeValues);
        this.warehouseService.updateStockItem(stockItem);
        return true;
    }

    private final class TypeComboboxRenderer
    implements ListCellRenderer<StockItemType> {
        private TypeComboboxRenderer(AddStockItemDialog addStockItemDialog) {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends StockItemType> list, StockItemType value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel(value.getTitle());
            if (Utils.notEmptyCollection((Collection)value.getChildren())) {
                label.setBackground(Color.BLACK);
                label.setForeground(Color.WHITE);
            } else {
                label.setBackground(list.getBackground());
                label.setForeground(list.getForeground());
            }
            if (isSelected) {
                label.setBackground(list.getSelectionBackground());
                label.setForeground(list.getForeground());
            }
            label.setOpaque(true);
            return label;
        }
    }

    protected final class AttributePanel
    extends JPanel {
        private final GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
        private final StockItemAttribute attribute;
        private Component component = null;

        AttributePanel(StockItemAttribute attribute) {
            this.attribute = attribute;
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)this, (String)(this.attribute.getTitle() + " (" + attribute.getAttributeType().getName() + ")"));
            this.buildPanel();
        }

        private void buildPanel() {
            switch (this.attribute.getAttributeType()) {
                case TEXT: 
                case NUMERIC: {
                    this.component = new JTextField();
                    break;
                }
                case DATE: {
                    this.component = new BGControlPanelDateNoB();
                    break;
                }
                case DATETIME: {
                    this.component = new BGControlPanelDateWithTime();
                    break;
                }
                case USER: {
                    this.component = new SelectUserPanel(AddStockItemDialog.this.clientContext);
                    break;
                }
                case ADDRESS: {
                    this.component = new SelectAddressPanel();
                }
            }
            if (this.component != null) {
                this.add(this.component, this.constraints);
            }
        }

        private String getData() {
            Component component = this.getComponent(0);
            switch (this.attribute.getAttributeType()) {
                case DATE: {
                    Date date = ((BGControlPanelDateNoB)component).getDate();
                    return date == null ? "" : String.valueOf(date.getTime());
                }
                case DATETIME: {
                    Date date = ((BGControlPanelDateWithTime)component).getDate();
                    return date == null ? "" : String.valueOf(date.getTime());
                }
                case USER: {
                    UserInfo user = (UserInfo)((SelectUserPanel)component).userComboBox.getSelectedItem();
                    return String.valueOf(user == null ? 0 : user.getId());
                }
                case ADDRESS: {
                    EntityAttrAddress address = ((SelectAddressPanel)component).getAddress();
                    int selectedHouseId = address != null ? address.getHouseId() : 0;
                    return selectedHouseId > 0 ? String.valueOf(selectedHouseId) : "";
                }
            }
            return ((JTextField)component).getText();
        }

        public StockItemAttribute getAttribute() {
            return this.attribute;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    private final class SelectAddressPanel
    extends JPanel {
        private final JTextField address = new JTextField();
        private EntityAttrAddress selectedAddress;

        SelectAddressPanel() {
            this.setLayout(new GridBagLayout());
            this.address.setEnabled(false);
            this.address.setEditable(false);
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.add((Component)this.address, constraints);
            JButton selectAddress = new JButton("\u0423\u043a\u0430\u0437\u0430\u0442\u044c \u0430\u0434\u0440\u0435\u0441");
            constraints.gridwidth = 2;
            this.add((Component)selectAddress, constraints);
            JButton clear = new JButton("X");
            this.add((Component)clear, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 0, 3), 0, 0));
            selectAddress.addActionListener(e -> {
                ContractParamEditorData contractParamEditorData = new ContractParamEditorData();
                contractParamEditorData.setClientContext(AddStockItemDialog.this.clientContext);
                contractParamEditorData.setEntityType(EntityType.NEW_CONTRACT_PARAMETER);
                contractParamEditorData.setValue((EntityAttr)this.selectedAddress);
                new ContractParamAddressEditorDialog("\u0412\u044b\u0431\u043e\u0440 \u0430\u0434\u0440\u0435\u0441\u0430", contractParamEditorData).open();
                this.selectedAddress = (EntityAttrAddress)contractParamEditorData.getValue();
                if (this.selectedAddress.getHouseId() > 0) {
                    try {
                        HouseData selectedHouse = ((AddressService)AddStockItemDialog.this.clientContext.getPort(AddressService.class, 0)).houseDataGet(this.selectedAddress.getHouseId());
                        if (selectedHouse != null) {
                            this.address.setText(this.getFullAddress(selectedHouse));
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
            clear.addActionListener(e -> {
                this.selectedAddress = null;
                this.address.setText("");
            });
        }

        EntityAttrAddress getAddress() {
            return this.selectedAddress;
        }

        private String getFullAddress(HouseData house) {
            return house.getCityTitle() + ", " + house.getStreetTitle() + ", " + house.getHouse();
        }
    }

    private final class SelectUserPanel
    extends JPanel {
        private final BGUComboBox<UserInfo> userComboBox = new BGUComboBox();

        SelectUserPanel(ClientContext context) {
            this.setLayout(new GridBagLayout());
            this.userComboBox.setEnabled(false);
            this.userComboBox.setEditable(false);
            try {
                UserInfo userInfo = (UserInfo)context.getDirectory(UserInfo.class, 0).get(((WarehouseService)context.getPort(WarehouseService.class, context.getModuleId())).getCurrentUserId());
                this.userComboBox.setData(List.of(userInfo));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.add((Component)this.userComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 0, 3), 0, 0));
        }
    }
}

