/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.service;

import bitel.billing.server.admin.resource.bean.NumberResourceCategoryManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParamType;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamTypeDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.ClosedSormContract;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.ContractWithClosedServices;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormProjectDao;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormStatisticDao;
import ru.bitel.bgbilling.modules.sorm.server.event.AddContractToUploadEvent;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormProjectUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.sorm.common.service.SormService")
public class SormServiceImpl
extends AbstractService
implements SormService {
    private SormProjectDao sormProjectDao;

    @PostConstruct
    public void init() {
        this.sormProjectDao = new SormProjectDao(this.getConnection(), this.moduleId);
    }

    public List<InstalledInstanceModule> getInstalledSormModules() {
        ArrayList<InstalledInstanceModule> uploadModules = new ArrayList<InstalledInstanceModule>();
        for (UploadModulesTitle uploadModule : UploadModulesTitle.values()) {
            for (BGModule module : this.getModulesList()) {
                if (!module.getName().equals(uploadModule.getTitleModule())) continue;
                uploadModules.add(new InstalledInstanceModule(module.getName(), module.getTitle(), module.getId()));
            }
        }
        return uploadModules;
    }

    public List<InstalledInstanceModule> getInstalledEthernetModules() {
        ArrayList<InstalledInstanceModule> modules = new ArrayList<InstalledInstanceModule>(this.getInstalledSormModules());
        modules.removeIf(i -> i.getTitleModule().equals(UploadModulesTitle.VOICE_IP.getTitleModule()) || i.getTitleModule().equals(UploadModulesTitle.VOICE.getTitleModule()));
        return modules;
    }

    public List<InstalledInstanceModule> getInstalledPhoneModules() {
        ArrayList<InstalledInstanceModule> modules = new ArrayList<InstalledInstanceModule>(this.getInstalledSormModules());
        modules.removeIf(i -> i.getTitleModule().equals(UploadModulesTitle.INET.getTitleModule()) || i.getTitleModule().equals(UploadModulesTitle.DIAL_UP.getTitleModule()));
        return modules;
    }

    public List<InstalledInstanceModule> getInstanceModules(String moduleName) {
        return this.getModulesList().stream().filter(module -> module.getName().equals(moduleName)).map(module -> new InstalledInstanceModule(module.getName(), module.getTitle(), module.getId())).collect(Collectors.toList());
    }

    public List<IdTitle> getBillAttributeTypeList(int billModuleId) throws BGException {
        try {
            Class<?> attrService = Class.forName("ru.bitel.bgbilling.modules.bill.common.service.BillService");
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Object attributeService = serverContext.getService(attrService, billModuleId);
            Method method = attributeService.getClass().getMethod("attributeTypeList", new Class[0]);
            List billAttributes = (List)method.invoke(attributeService, new Object[0]);
            if (Utils.notEmptyCollection((Collection)billAttributes)) {
                ArrayList<IdTitle> result = new ArrayList<IdTitle>();
                for (Object attr : billAttributes) {
                    try {
                        Field nameField = attr.getClass().getDeclaredField("name");
                        nameField.setAccessible(true);
                        String name = (String)nameField.get(attr);
                        Class<?> idClazz = attr.getClass().getSuperclass().getSuperclass();
                        Field idField = idClazz.getDeclaredField("id");
                        idField.setAccessible(true);
                        int id = (Integer)idField.get(attr);
                        result.add(new IdTitle(id, name));
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                return result;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new BGException((Throwable)e);
        }
        return Collections.emptyList();
    }

    public List<InstalledInstanceModule> getInetInstanceModules() {
        return this.getModulesList().stream().filter(m -> m.getName().equals(UploadModulesTitle.INET.getTitleModule())).map(m -> new InstalledInstanceModule(m.getName(), m.getTitle(), m.getId())).collect(Collectors.toList());
    }

    public List<Integer> getIdsInetModules() {
        return this.getInetInstanceModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
    }

    private List<BGModule> getModulesList() {
        return ModuleCache.getInstance().getModulesList();
    }

    public List<SormProject> getSormProjects() throws Exception {
        return this.sormProjectDao.getList();
    }

    public SormProject getSormProject(int id) throws Exception {
        return (SormProject)this.sormProjectDao.get(id);
    }

    public Integer updateSormProject(SormProject sormProject) throws Exception {
        try {
            sormProject.setUserId(this.userId);
            this.sormProjectDao.update(sormProject);
            return sormProject.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteSormProject(int id) throws Exception {
        new SormStatisticDao(this.getConnection(), this.moduleId).deleteStatisticForSormProject(id, null);
        SormUtils.clearContractLogTable(this.getConnection(), id, this.moduleId);
        this.sormProjectDao.delete(id);
    }

    public List<IdTitle> getNumberResourceCategoryList(int moduleId) {
        return new NumberResourceCategoryManager(this.getConnection(), moduleId).getNumberResourceCategoryList().stream().map(r -> new IdTitle(r.getId(), r.getTitle())).collect(Collectors.toList());
    }

    public List<SormProject> getActiveSormProject() throws Exception {
        return this.sormProjectDao.getActiveSormProject();
    }

    public void startUpload(SormProject sormProject, boolean withPayments) throws BGException {
        SormProjectUpload.Builder uploadBuilder = SormProjectUpload.newUploadBuilder(this.moduleId, sormProject);
        if (withPayments) {
            uploadBuilder.uploadWithPayments();
        } else {
            uploadBuilder.uploadWithoutPayments();
        }
        uploadBuilder.build().startUpload();
    }

    public void startFullUpload(SormProject sormProject, boolean withPayments) throws BGException {
        SormProjectUpload.Builder uploadBuilder = SormProjectUpload.newUploadBuilder(this.moduleId, sormProject);
        if (withPayments) {
            uploadBuilder.fullUploadWithPayments();
        } else {
            uploadBuilder.fullUploadWithoutPayments();
        }
        uploadBuilder.build().startUpload();
    }

    public SearchResult<SormUploadStatistic> getStatisticOfProject(int sormProjectId, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page).setList(new ArrayList());
        new SormStatisticDao(this.getConnection(), this.moduleId).getList((SearchResult<SormUploadStatistic>)searchResult);
        return searchResult;
    }

    public void clearStatisticOfProject(int sormProjectId, Date dateFilter) throws Exception {
        new SormStatisticDao(this.getConnection(), this.moduleId).deleteStatisticForSormProject(sormProjectId, dateFilter);
    }

    public void tryUploadToFTPAgain(SormUploadStatistic statistic) throws Exception {
        SormProject sormProject = (SormProject)this.sormProjectDao.get(statistic.getSormProjectId());
        if (sormProject == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0441 ID=" + statistic.getSormProjectId());
        }
        SormProjectUpload.newUploadBuilder(this.moduleId, sormProject).fullUploadWithPayments().build().startUploadForStatistic(statistic);
    }

    public List<IdTitle> listObjectType() throws BGException {
        return new ObjectTypeManager(this.getConnection()).getTypeList(false).stream().map(objectType -> new IdTitle(objectType.getId(), objectType.getTitle())).collect(Collectors.toList());
    }

    public List<IdTitle> listObjectParamsByObjectType(int typeParamId) throws BGException {
        try {
            List paramTypesIds = new ObjectParamTypeDao(this.getConnection()).getTypeParamList(typeParamId).stream().filter(typeParam -> typeParam.getTypeId() == typeParamId).mapToInt(ObjectParamType::getParamId).boxed().collect(Collectors.toList());
            return new ObjectParamDao(this.getConnection()).getParamList().stream().filter(objectParam -> paramTypesIds.contains(objectParam.getId())).map(objectParam -> new IdTitle(objectParam.getId(), objectParam.getTitle())).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<ClosedSormContract> checkClosedContract() throws BGException {
        ArrayList<ClosedSormContract> result = new ArrayList<ClosedSormContract>();
        String installedSormModulesIds = Utils.toString((Iterable)this.getInstalledSormModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList()));
        String query = "select m.cid as contractId, c.title as title from contract_module as m left join contract as c on m.cid=c.id where m.mid=? and c.date2<=? AND (select count(*) from contract_module where mid in (" + installedSormModulesIds + ") and cid=m.cid )>0";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, this.moduleId);
            Instant minimalDateRange = ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).minus(3L, ChronoUnit.YEARS).toInstant();
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)Date.from(minimalDateRange)));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new ClosedSormContract(rs.getInt("contractId")));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ClosedSormContract> searchOpenedContractsWithClosedServices(SormProject sormProject) throws BGException {
        String selectedModules = sormProject.getLoadedConfig().get("sorm.upload.modules");
        if (Utils.isBlankString((String)selectedModules)) {
            throw new BGMessageException("\u041d\u0435\u0442 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438");
        }
        List selectedModulesIds = Utils.toIntegerList((String)selectedModules);
        Map<Integer, InstalledInstanceModule> selectedModulesForUpload = this.getInstalledSormModules().stream().filter(instance -> selectedModulesIds.contains(instance.getModuleId())).collect(Collectors.toMap(InstalledInstanceModule::getModuleId, Function.identity()));
        ArrayList<ClosedSormContract> contractsWithSormUploadModules = new ArrayList<ClosedSormContract>();
        ContractWithClosedServices contractWithClosedServices = new ContractWithClosedServices(this.getConnection(), this.moduleId);
        for (InstalledInstanceModule selectedInstanceModule : selectedModulesForUpload.values()) {
            UploadModulesTitle.defineByTitle((String)selectedInstanceModule.getTitleModule()).ifPresent(moduleTitle -> {
                try {
                    contractsWithSormUploadModules.addAll(contractWithClosedServices.search((UploadModulesTitle)moduleTitle, selectedInstanceModule));
                }
                catch (BGException e) {
                    this.logError(e);
                }
            });
        }
        List<ClosedSormContract> contractsWithClosedResources = this.filterContractsByClosedResources(contractWithClosedServices, contractsWithSormUploadModules, selectedModulesForUpload);
        contractsWithClosedResources.sort(Comparator.comparingInt(Id::getId));
        return contractsWithClosedResources;
    }

    private List<ClosedSormContract> filterContractsByClosedResources(ContractWithClosedServices contractWithClosedServices, List<ClosedSormContract> contractsWithSormUploadModules, Map<Integer, InstalledInstanceModule> selectedInstanceModules) throws BGException {
        ArrayList<ClosedSormContract> contractsWithClosedResources = new ArrayList<ClosedSormContract>();
        ContractModuleManager contractModuleManager = new ContractModuleManager(this.getConnection());
        block2: for (ClosedSormContract closedSormContract : contractsWithSormUploadModules) {
            Set contractModules = contractModuleManager.getContractModuleSet(closedSormContract.getId());
            for (Integer installedMid : selectedInstanceModules.keySet()) {
                InstalledInstanceModule installedInstanceModule;
                Optional modulesTitle;
                if (!contractModules.contains(installedMid) || !(modulesTitle = UploadModulesTitle.defineByTitle((String)(installedInstanceModule = selectedInstanceModules.get(installedMid)).getTitleModule())).isPresent()) continue;
                try {
                    if (!contractWithClosedServices.hasOpenResources(closedSormContract.getId(), (UploadModulesTitle)modulesTitle.get(), installedInstanceModule)) continue;
                    continue block2;
                }
                catch (BGException ex) {
                    this.logError(ex);
                }
            }
            contractsWithClosedResources.add(closedSormContract);
        }
        return contractsWithClosedResources;
    }

    public void removeModuleOfContracts(Set<Integer> cids) throws BGException, BGMessageException {
        if (Utils.isEmptyCollection(cids)) {
            throw new BGMessageException("\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f \u043f\u0443\u0441\u0442!");
        }
        if (this.moduleId <= 0) {
            throw new BGMessageException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d \u043c\u043e\u0434\u0443\u043b\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
        }
        ContractModuleManager contractModuleManager = new ContractModuleManager(this.getConnection());
        for (Integer cid : cids) {
            try {
                this.getLogger().info("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0441 ModuleId = " + this.moduleId + " \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 = " + cid);
                contractModuleManager.deleteContractModule(cid.intValue(), this.moduleId);
                this.context.publishAfterCommit((Event)new ContractModifiedEvent(this.userId, cid.intValue()));
            }
            catch (BGException ex) {
                this.logError(ex);
            }
        }
    }

    public void addContractToUpload(int contractId) throws BGException, BGMessageException {
        if (contractId <= 0) {
            throw new BGException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u043f\u0435\u0440\u0435\u0434\u0430\u043d contractId");
        }
        EventProcessor.getInstance().request((QueueEvent)new AddContractToUploadEvent(this.moduleId, contractId, this.userId));
    }
}

