/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Page;

public class VoiceSearchPanel
extends BGUPanel {
    private BGDataSourceTableModel model = new BGDataSourceTableModel("VoiceSearch");
    private BGUComboBox<VoiceAccountType> accountType = new BGUComboBox();
    private VoiceAccountService wsAccount = (VoiceAccountService)((ClientContext)this.getContext()).getPort(VoiceAccountService.class);
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private JTextField searchFieldValue = new JTextField(30);
    private BGUComboBox<KeyValue> searchFields = new BGUComboBox();
    private List<KeyValue> searchFieldItems = Arrays.asList(new KeyValue("login", "\u041b\u043e\u0433\u0438\u043d"), new KeyValue("phone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d"), new KeyValue("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new KeyValue("accountId", "ID \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"));
    AbstractBGUPanel.DefaultAction find = new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            KeyValue selectedItem = (KeyValue)VoiceSearchPanel.this.searchFields.getSelectedItem();
            VoiceAccountType selectedType = (VoiceAccountType)VoiceSearchPanel.this.accountType.getSelectedItem();
            long number = -1L;
            if ("phone".equals(selectedItem.getKey())) {
                number = Utils.parseLong((String)VoiceSearchPanel.this.searchFieldValue.getText(), (long)-1L);
                if (!Utils.isEmptyString((String)VoiceSearchPanel.this.searchFieldValue.getText()) && number < 0L) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d \u041d\u043e\u043c\u0435\u0440!");
                    return;
                }
            }
            VoiceSearchPanel.this.model.loadData((ClientContext)VoiceSearchPanel.this.getContext(), new BGUTableParams().addParam("typeId", String.valueOf(selectedType != null ? selectedType.getId() : 0)).addParam("filter_key", selectedItem.getKey()).addParam("filter_value", VoiceSearchPanel.this.searchFieldValue.getText()).setPeriod(VoiceSearchPanel.this.period.getPeriod()).setPage(VoiceSearchPanel.this.pagePanel.getPage()));
            VoiceSearchPanel.this.pagePanel.setPage(Optional.ofNullable(VoiceSearchPanel.this.model.getPage()).orElse(new Page()));
        }
    };

    public VoiceSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)this.model);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.model.optSelectRow(VoiceAccount.class).ifPresent(a -> ClientUtils.openContract((int)a.getContractId())));
        this.setLayout(new GridBagLayout());
        this.add(this.createTopSearchPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel createTopSearchPanel() {
        this.searchFields.setData(this.searchFieldItems);
        this.searchFieldValue.setMinimumSize(new Dimension(200, 26));
        this.searchFieldValue.setHorizontalAlignment(0);
        BGButton clearField = new BGButton("X");
        clearField.addActionListener(e -> this.searchFieldValue.setText(""));
        BGButton searchButton = new BGButton((Action)this.find);
        this.searchFieldValue.setAction((Action)this.find);
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.find.perform();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.searchFields, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.searchFieldValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.accountType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List typeList = this.wsAccount.voiceAccountTypeList();
            typeList.add(0, new VoiceAccountType(0, "\u041b\u044e\u0431\u043e\u0439"));
            this.accountType.setData(typeList);
            this.model.loadData((ClientContext)this.getContext(), null);
        });
    }
}

