/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client;

import bitel.billing.module.common.BGControlPanelMonthAndDays;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.BGToggleButton;
import jakarta.activation.DataHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.voice.client.contract.report.SessionAccountReport;
import ru.bitel.bgbilling.modules.voice.client.contract.report.SessionDestinationReport;
import ru.bitel.bgbilling.modules.voice.client.contract.report.SessionDetailPanel;
import ru.bitel.bgbilling.modules.voice.client.contract.report.SessionServiceReport;
import ru.bitel.bgbilling.modules.voice.client.contract.report.SessionTableReport;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionFilter;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceRequestLogService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceSessionService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.GroupParent;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

public class ServiceReportPanel
extends BGUPanel
implements GroupParent {
    private static final String DO_ACTION = "do";
    private static final String EMAIL_ACTION = "email";
    private static final String SAVE_ACTION = "save";
    private static final String PRINT_ACTION = "print";
    private BGToggleButton sessionToggleButton = new BGToggleButton();
    private BGToggleButton sessionLogToggleButton = new BGToggleButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays();
    private BGUCheckList<VoiceAccount> voiceAccountList = new BGUCheckList(false);
    private BGUCheckList<VoiceOperAccount> voiceOperAccountList = new BGUCheckList(false);
    private BGUCheckList<Service> serviceCheckList = new BGUCheckList(false);
    private JCheckBox timeCheckBox = new JCheckBox("\u0412\u0440\u0435\u043c\u044f", true);
    private JCheckBox moneyCheckBox = new JCheckBox("\u0421\u0443\u043c\u043c\u0430");
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M});
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private VoiceAccountService accountService = (VoiceAccountService)((ClientContext)this.getContext()).getPort(VoiceAccountService.class);
    private VoiceOperAccountService operAccountService = (VoiceOperAccountService)((ClientContext)this.getContext()).getPort(VoiceOperAccountService.class);
    private VoiceSessionService sessionService = (VoiceSessionService)((ClientContext)this.getContext()).getPort(VoiceSessionService.class);
    private VoiceService voiceService = (VoiceService)((ClientContext)this.getContext()).getPort(VoiceService.class);
    private JLabel timeSumLabel = new JLabel();
    private JLabel roundTimeSumLabel = new JLabel();
    private BGTextField timeSum = new BGTextField();
    private BGTextField roundTimeSum = new BGTextField();
    private BGTextField moneySum = new BGTextField(15);
    private BGTextField sessionsCount = new BGTextField(15);
    private JCheckBox onlyCharged = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u043f\u043b\u0430\u0442\u043d\u044b\u0435");
    private JTabbedPane tabPane = new JTabbedPane();
    private SessionTableReport sessionTableReport = new SessionTableReport(this);
    private SessionAccountReport sessionAccountReport = new SessionAccountReport();
    private SessionDestinationReport sessionDestinationReport = new SessionDestinationReport();
    private SessionServiceReport sessionServiceReport = new SessionServiceReport();
    private SessionDetailPanel sessionDetailPanel = new SessionDetailPanel();
    private JRadioButton all = new JRadioButton("\u0412\u0441\u0435");
    private JRadioButton outgoing = new JRadioButton("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
    private JRadioButton incoming = new JRadioButton("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435");
    private JComponent columnsPanel = null;
    AbstractBGUPanel.DefaultAction controlPanelDoAction = new AbstractBGUPanel.DefaultAction("do", "doAction"){

        public void actionPerformedImpl(ActionEvent e) throws BGException {
            Page page = ServiceReportPanel.this.pagePanel.getPage();
            VoiceSessionFilter filter = ServiceReportPanel.this.getFilter();
            switch (ServiceReportPanel.this.tabPane.getSelectedIndex()) {
                case 0: {
                    ServiceReportPanel.this.setDataToMainTable(page, filter);
                    break;
                }
                case 1: {
                    ServiceReportPanel.this.sessionAccountReport.setData(ServiceReportPanel.this.sessionService.voiceSessionReportGroupByAccount(filter));
                    break;
                }
                case 2: {
                    ServiceReportPanel.this.sessionDestinationReport.setData(ServiceReportPanel.this.sessionService.voiceSessionReportGroupByAccountAndDestination(filter));
                    break;
                }
                case 3: {
                    ServiceReportPanel.this.sessionServiceReport.setData(ServiceReportPanel.this.sessionService.voiceSessionReportGroupByAccountAndService(filter));
                    break;
                }
                case 4: {
                    ServiceReportPanel.this.setDetailData(page, filter);
                }
            }
        }
    };

    public ServiceReportPanel() {
    }

    public ServiceReportPanel(ClientContext context) {
        super(context);
    }

    protected void jbInit() throws Exception {
        this.tabPane.addChangeListener(e -> this.columnsPanel.setVisible(this.tabPane.getSelectedIndex() == 0));
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createLeftPanel(), (Component)this.createRightPanel(), 400L), "Center");
    }

    private JPanel createRightPanel() {
        this.initTabPane();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.tabPane, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.createSumPanel(), new GridBagConstraints(0, 2, 5, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createBGEditor(), new GridBagConstraints(0, 3, 5, 1, 1.0, 0.2, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
        return panel;
    }

    private JPanel createTopPanel() {
        this.initToggleButtons();
        this.initPagePanel();
        this.initCallTypeButtons();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.sessionLogToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.sessionToggleButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.onlyCharged, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.all, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.outgoing, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.incoming, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private void initCallTypeButtons() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.all);
        group.add(this.outgoing);
        group.add(this.incoming);
        this.all.setSelected(true);
    }

    private void initTabPane() {
        this.tabPane.add("\u0422\u0430\u0431\u043b\u0438\u0446\u0430", (Component)((Object)this.sessionTableReport));
        this.tabPane.add("\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b", (Component)((Object)this.sessionAccountReport));
        this.tabPane.add("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f", (Component)((Object)this.sessionDestinationReport));
        this.tabPane.add("\u0423\u0441\u043b\u0443\u0433\u0438", (Component)((Object)this.sessionServiceReport));
        this.tabPane.add("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f", (Component)((Object)this.sessionDetailPanel));
        Stream.of(1, 2, 3).forEach(i -> this.tabPane.setEnabledAt((int)i, true));
    }

    private BGEditor createBGEditor() {
        BGEditor editor = new BGEditor();
        editor.addForm((JComponent)((Object)new LogForm()));
        editor.setPreferredSize(new Dimension(400, 400));
        editor.setVisible(false);
        return editor;
    }

    private void initPagePanel() {
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.performAction(DO_ACTION);
            }
        });
    }

    private void initToggleButtons() {
        this.sessionToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.sessionToggleButton.setText("\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
        this.sessionLogToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.sessionLogToggleButton.setSelected(true);
        this.sessionLogToggleButton.setText("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0435");
        ActionListener listener = e -> {
            for (int i = 1; i < 4; ++i) {
                this.tabPane.setEnabledAt(i, this.sessionLogToggleButton.isSelected());
            }
        };
        this.sessionLogToggleButton.addActionListener(listener);
        this.sessionToggleButton.addActionListener(listener);
        this.buttonGroup.add((AbstractButton)this.sessionToggleButton);
        this.buttonGroup.add((AbstractButton)this.sessionLogToggleButton);
    }

    private JPanel createSumPanel() {
        this.timeSumLabel.setText("\u0412\u0440\u0435\u043c\u044f [\u0441\u0435\u043a.]:");
        this.roundTimeSumLabel.setText("\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u0440.[\u0441\u0435\u043a.][\u043c\u0438\u043d.]:");
        Color bgColor = this.sessionsCount.getBackground();
        this.sessionsCount.setEditable(false);
        this.sessionsCount.setBackground(bgColor);
        this.sessionsCount.setHorizontalAlignment(4);
        this.moneySum.setEditable(false);
        this.moneySum.setBackground(bgColor);
        this.moneySum.setHorizontalAlignment(4);
        this.timeSum.setEditable(false);
        this.timeSum.setBackground(bgColor);
        this.roundTimeSum.setEditable(false);
        this.roundTimeSum.setBackground(bgColor);
        JPanel sumPanel = new JPanel(new GridBagLayout());
        sumPanel.add((Component)new JLabel("\u0421\u0435\u0441\u0441\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.sessionsCount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.moneySum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.timeSumLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.roundTimeSumLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.timeSum, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add((Component)this.roundTimeSum, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        sumPanel.add(Box.createGlue(), new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return sumPanel;
    }

    private JPanel createLeftPanel() {
        this.periodPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.columnsPanel = BGSwingUtilites.wrapBorder((JComponent)this.getColumnsPanel(), (String)"\u041a\u043e\u043b\u043e\u043d\u043a\u0438");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.createFilterPanel(), (String)"\u0424\u0438\u043b\u044c\u0442\u0440"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.columnsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel createFilterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        result.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        JTabbedPane tabPanel = new JTabbedPane();
        tabPanel.add("\u0410\u0431\u043e\u043d\u0435\u043d\u0442\u044b", (Component)this.voiceAccountList);
        try {
            Contract contract = ((ContractService)((ClientContext)this.getContext()).getPort(ContractService.class, 0)).contractGet(((ClientContext)this.getContext()).getContractId());
            if (!contract.isIndependSub() && VoiceCommonUtils.agetModeOn((Preferences)ClientSetup.getInstance())) {
                tabPanel.add("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u044b", (Component)this.voiceOperAccountList);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        result.add((Component)BGSwingUtilites.wrapBorder((JComponent)tabPanel, (String)"\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b"), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.periodPanel.addActionListener(e -> this.performAction("refresh"));
        this.buttonPanel.addActionListener(e -> this.performAction(e.getActionCommand()));
        return result;
    }

    private JTabbedPane getColumnsPanel() {
        JPanel servicePanel = new JPanel(new GridBagLayout());
        servicePanel.add((Component)this.timeCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        servicePanel.add((Component)this.moneyCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 0, 3, 3), 0, 0));
        servicePanel.add((Component)this.serviceCheckList, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JTabbedPane pane = new JTabbedPane();
        pane.add("\u0423\u0441\u043b\u0443\u0433\u0438", servicePanel);
        ActionListener serviceUnitActionListener = e -> {
            if (!this.timeCheckBox.isSelected() && !this.moneyCheckBox.isSelected()) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043f\u043e \u043a\u0440\u0430\u0439\u043d\u0435 \u043c\u0435\u0440\u0435 \u043e\u0434\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u0412\u0440\u0435\u043c\u044f \u0438\u043b\u0438 \u0421\u0443\u043c\u043c\u0430");
                ((JCheckBox)e.getSource()).setSelected(true);
            }
            this.updateTableModel();
        };
        this.serviceCheckList.addPropertyChangeListener(e -> this.updateTableModel());
        this.timeCheckBox.addActionListener(serviceUnitActionListener);
        this.moneyCheckBox.addActionListener(serviceUnitActionListener);
        this.timeCheckBox.setEnabled(false);
        this.moneyCheckBox.setEnabled(false);
        return pane;
    }

    private List<VoiceAccount> sortListAccounts(List<VoiceAccount> voiceAccountsList) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        for (VoiceAccount voiceAccount : voiceAccountsList) {
            if (voiceAccount.getNumber() <= 0L) continue;
            sortedMap.put(voiceAccount.getNumber(), voiceAccount);
        }
        voiceAccountsList.clear();
        for (Map.Entry entry : sortedMap.entrySet()) {
            voiceAccountsList.add((VoiceAccount)entry.getValue());
        }
        return voiceAccountsList;
    }

    private void setDetailData(Page page, VoiceSessionFilter filter) throws BGException {
        Result result = this.sessionService.voiceSessionDetailReport(filter, page);
        this.sessionDetailPanel.setData(result.getList());
        this.pagePanel.setPage(result.getPage());
    }

    private void setDataToMainTable(Page page, VoiceSessionFilter filter) throws BGException {
        Result result;
        if (this.sessionToggleButton.isSelected()) {
            filter.setHourFrom(null);
            filter.setHourTo(null);
            result = this.sessionService.voiceSessionContractList(filter, page);
        } else {
            result = this.sessionService.voiceSessionLogContractList(filter, page);
        }
        this.sessionTableReport.getTableModel().setData(result.getList());
        this.pagePanel.setPage(result.getPage());
        this.setTotalData((Result<VoiceSession>)result);
    }

    private VoiceSessionFilter getFilter() {
        Set accountSetIds = this.voiceAccountList.getSelectedIds();
        accountSetIds.addAll(this.voiceOperAccountList.getSelectedIds());
        return new VoiceSessionFilter().setContractIds(Collections.singleton(((ClientContext)this.getContext()).getContractId())).setAccountIds(accountSetIds).setServiceIds(this.serviceCheckList.getSelectedIds()).setHourFrom(this.periodPanel.getPeriod().getDateFrom()).setHourTo(TimeUtils.getNextDay((Date)this.periodPanel.getPeriod().getDateTo())).setOnlyCharged(this.onlyCharged.isSelected()).setCallType(this.incoming.isSelected() ? VoiceSessionFilter.CallType.INCOMING : (this.outgoing.isSelected() ? VoiceSessionFilter.CallType.OUTGOING : VoiceSessionFilter.CallType.ALL));
    }

    public void setTotalData(Result<VoiceSession> result) throws BGException {
        this.sessionsCount.setText(String.valueOf(Math.round(((Integer)result.getAttribute("totalCount")).intValue())));
        BigDecimal totalSum = (BigDecimal)result.getAttribute("totalSum");
        if (totalSum == null) {
            totalSum = BigDecimal.ZERO;
        }
        this.moneySum.setText(Utils.formatCostByGrouping((BigDecimal)totalSum, (int)3, (int)2));
        long valueTime = (Long)result.getAttribute("totalTime");
        this.timeSum.setText(Utils.formatSessionTime((int)((int)valueTime)));
        long valueTimeRound = (Long)result.getAttribute("totalTimeRound");
        this.roundTimeSum.setText(Utils.formatSessionTime((int)((int)valueTimeRound)) + " [" + Utils.formatInteger((int)((int)valueTimeRound / 60)) + "]");
    }

    private void updateTableModel() {
        int selectedServiceSize = this.serviceCheckList.getSelectedIds().size();
        this.timeCheckBox.setEnabled(selectedServiceSize > 0);
        this.moneyCheckBox.setEnabled(selectedServiceSize > 0);
        this.sessionTableReport.getTableModel().reinitColumns();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.voiceAccountList.setData(this.accountService.voiceAccountList(((ClientContext)this.getContext()).getContractId(), 0, this.periodPanel.getPeriod()));
            this.voiceOperAccountList.setData(this.operAccountService.voiceOperAccountList(((ClientContext)this.getContext()).getContractId(), this.periodPanel.getPeriod()));
            List services = ((ModuleService)((ClientContext)this.getContext()).getWebService(ModuleService.class, 0)).serviceList(((ClientContext)this.getContext()).getModuleId());
            this.serviceCheckList.setData(services);
            this.sessionTableReport.getServiceMap().putAll(services.stream().collect(Collectors.toMap(k -> k.getId(), v -> v)));
            this.tryCall(() -> {
                this.sessionTableReport.getDestMap().clear();
                SearchResult data = this.voiceService.voiceDestinationList(VoiceOperator.OPERTOR_ALL_ID, null, null);
                this.sessionTableReport.setDestMap(VoiceDestination.getDestinationMap((List)data.getList()));
            });
        });
        new AbstractBGUPanel.DefaultAction(EMAIL_ACTION, "emailAction"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(evt -> {
                    if (evt.getPropertyName().equals("selectEmail")) {
                        try {
                            String emails = String.valueOf(evt.getNewValue());
                            List<String> emailsList = Arrays.asList(emails.split(","));
                            VoiceSessionFilter filter = ServiceReportPanel.this.getFilter();
                            switch (ServiceReportPanel.this.tabPane.getSelectedIndex()) {
                                case 0: {
                                    ServiceReportPanel.this.sessionService.voiceSessionEmail(filter, emailsList, new Page(1, Integer.MAX_VALUE));
                                    break;
                                }
                                case 4: {
                                    ServiceReportPanel.this.sessionService.voiceSessionDetailEmail(filter, emailsList);
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
                dialog.loadEmailListFromContractParameter(((ClientContext)ServiceReportPanel.this.getContext()).getContractId(), 0);
                dialog.setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction(PRINT_ACTION, "printAction"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                throw new UnsupportedOperationException();
            }
        };
        new AbstractBGUPanel.DefaultAction(SAVE_ACTION, "saveAction"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List<Pair> fileTypes = null;
                switch (ServiceReportPanel.this.tabPane.getSelectedIndex()) {
                    case 0: 
                    case 4: {
                        fileTypes = Arrays.asList(new Pair((Object)"html", (Object)"HTML File"), new Pair((Object)"csv", (Object)"CSV File"));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                BGFileChooser fc = ServiceReportPanel.this.getFileChooser(fileTypes);
                if (fc.showSaveDialog() == 0) {
                    VoiceSessionFilter filter = ServiceReportPanel.this.getFilter();
                    DataHandler handler = null;
                    String format = ServiceReportPanel.this.getSelectedExtension(fc);
                    switch (ServiceReportPanel.this.tabPane.getSelectedIndex()) {
                        case 0: {
                            handler = ServiceReportPanel.this.sessionService.voiceSessionContractLogExport(filter, format, new Page(1, Integer.MAX_VALUE));
                            break;
                        }
                        case 4: {
                            handler = ServiceReportPanel.this.sessionService.voiceSessionDetailExport(filter, format);
                        }
                    }
                    if (handler != null) {
                        File file = new File(ServiceReportPanel.this.getSelectedFilePath(fc));
                        FileOutputStream fos = new FileOutputStream(file);
                        handler.writeTo((OutputStream)fos);
                        fos.flush();
                        fos.close();
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
                    }
                }
            }
        };
        new AbstractBGUPanel.MenuAction("voiceSession.finish", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0443\u044e) \u0441\u0435\u0441\u0441\u0438\u044e", ClientUtils.getIcon((String)"fugue/plug--minus")){
            {
                this.putValue("LongDescription", "<html>\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414, \u043a\u0430\u043a \u0435\u0441\u043b\u0438 \u0431\u044b \u0432\u044b\u0448\u0435\u043b \u043b\u0438\u043c\u0438\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f<br>RADIUS- \u0438\u043b\u0438 Netflow-\u043f\u0430\u043a\u0435\u0442\u0430 (connection.close.timeout).</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceSession session = (VoiceSession)ServiceReportPanel.this.sessionTableReport.getTableModel().getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", null)) {
                    ServiceReportPanel.this.sessionService.sessionFinish(session.getId());
                    ServiceReportPanel.this.performAction("refresh");
                }
            }
        };
    }

    public JCheckBox getTimeCheckBox() {
        return this.timeCheckBox;
    }

    public JCheckBox getMoneyCheckBox() {
        return this.moneyCheckBox;
    }

    public BGUCheckList<Service> getServiceCheckList() {
        return this.serviceCheckList;
    }

    private BGFileChooser getFileChooser(List<Pair> fileTypes) {
        BGFileChooser fc = new BGFileChooser((Component)((Object)this)){

            public void approveSelection() {
                int result;
                File f = this.getSelectedFile();
                if (f.exists() && (result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c?", "\u0424\u0430\u0439\u043b \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", 0)) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        FileFilter[] ff = fc.getChoosableFileFilters();
        if (ff != null) {
            for (int i = 0; i < ff.length; ++i) {
                fc.removeChoosableFileFilter(ff[i]);
            }
        }
        for (Pair type : fileTypes) {
            BGFileFilter csvFilter = new BGFileFilter((String)type.getFirst(), (String)type.getSecond());
            fc.addChoosableFileFilter((FileFilter)csvFilter);
        }
        return fc;
    }

    private String getSelectedFilePath(BGFileChooser fc) {
        String extension;
        Object path = fc.getSelectedFile().getAbsolutePath();
        if (!((String)path).endsWith(extension = this.getSelectedExtension(fc))) {
            path = (String)path + "." + extension;
        }
        return path;
    }

    private String getSelectedExtension(BGFileChooser fc) {
        String[] extensions = ((BGFileFilter)fc.getFileFilter()).getExtensions();
        String selected = null;
        if (extensions.length > 0) {
            selected = extensions[0];
        }
        return selected;
    }

    class LogForm
    extends BGUPanel {
        private JTextArea log = new JTextArea();
        private VoiceRequestLogService wsRequestLog = (VoiceRequestLogService)((ClientContext)this.getContext()).getPort(VoiceRequestLogService.class);

        LogForm() {
        }

        protected void jbInit() {
            JButton exit = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            exit.addActionListener(e -> this.performActionClose());
            this.log.setEditable(false);
            this.setLayout(new GridBagLayout());
            this.add(new JScrollPane(this.log), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add(exit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.MenuAction("voiceSession.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VoiceSession session = (VoiceSession)ServiceReportPanel.this.sessionTableReport.getTableModel().getSelectedRow();
                    if (session != null) {
                        LogForm.this.log.setText(LogForm.this.wsRequestLog.voiceConnectionLog(session.getDeviceId(), session.getId(), session.getSessionStart(), ServiceReportPanel.this.sessionLogToggleButton.isSelected()));
                    }
                    LogForm.this.performActionOpen();
                }
            };
        }
    }
}

