/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Writable;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.bill.client.ActionServiceConfig;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillGenerate;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.bgbilling.modules.bill.client.bean.BillPositionsEditor;
import ru.bitel.bgbilling.modules.bill.client.bean.BillTableRow;
import ru.bitel.bgbilling.modules.bill.client.bean.BillUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.io.IOUtils;
import ru.bitel.common.io.NoClosableOutputStream;
import ru.bitel.common.model.IdTitle;

public class BGBillTable
extends BGPanel {
    private int currentDocumentId = 0;
    private int currentPage = 1;
    private boolean invoice = false;
    private BGUTable table = null;
    private BGTableModel<BillTableRow> tableModel = new BillDocsTableModel("billDocs");
    private JPanel saveRestorePanel = new JPanel(new GridBagLayout());
    private ServiceConfigBillGenerate parent;
    private BGSelectFilePanel selectFile = new BGSelectFilePanel(true);
    private List<BillTableRow> rows = new ArrayList<BillTableRow>();
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGButton goButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b");
    private BGUComboBox<IdTitle> organizationComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> bankAccountComboBox = new BGUComboBox();
    private BGUComboBox<KeyValue> saveRestoreMode = new BGUComboBox();
    private BillPositionsEditor positionsEditor;
    private BillTableRow currentRow;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BillService billService = null;
    private boolean isAll = true;

    public BGBillTable(ServiceConfigBillGenerate parent, boolean isAll) {
        this.rb_name = ClientUtils.getRBName(ActionServiceConfig.class);
        this.getModuleDoc(ActionServiceConfig.class);
        this.parent = parent;
        this.isAll = isAll;
        this.positionsEditor = new BillPositionsEditor((BGPanel)parent, e -> {
            String cmd = e.getActionCommand();
            if ("refresh".equals(cmd)) {
                this.positionsEditor.reloadPos(this.currentRow, this.parent.getBillPosList(this.currentDocumentId));
            }
            BigDecimal billSumm = BigDecimal.ZERO;
            for (BGBillTablePos posit : this.currentRow.positionList) {
                if (!posit.inSum) continue;
                billSumm = billSumm.add(posit.getSum());
            }
            if (this.currentRow.subBillList != null) {
                for (BillTableRow sub : this.currentRow.subBillList) {
                    BigDecimal subSumm = BigDecimal.ZERO;
                    for (BGBillTablePos posit : sub.positionList) {
                        if (!posit.inSum) continue;
                        subSumm = subSumm.add(posit.getSum());
                    }
                    sub.setSumma(subSumm);
                    billSumm = billSumm.add(subSumm);
                }
            }
            this.currentRow.setSumma(billSumm);
            this.updatePage();
        });
        this.jbInit();
        this.date.setLocalDate(TimeUtils.convertDateToLocalDate((Date)new Date()));
        this.selectFile.setFileFilter("xml", "XML File");
    }

    private void jbInit() {
        this.table = new BGUTable(this.tableModel);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (BGBillTable.this.fl) {
                    int row = e.getFirstRow();
                    int col = e.getColumn();
                    Boolean value = (Boolean)BGBillTable.this.tableModel.getValueAt(row, col);
                    int pos = row + (BGBillTable.this.pagePanel.getPageIndex() - 1) * BGBillTable.this.pagePanel.getPageSize();
                    BGBillTable.this.rows.get(pos).setCheck(value);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.positionsEditor), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        JButton restoreButton = new JButton("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        int indexSavePanel = 0;
        this.saveRestorePanel.add((Component)this.selectFile, new GridBagConstraints(indexSavePanel++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (this.isAll) {
            this.saveRestorePanel.add((Component)this.saveRestoreMode, new GridBagConstraints(indexSavePanel++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        }
        this.saveRestorePanel.add((Component)saveButton, new GridBagConstraints(indexSavePanel++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.saveRestorePanel.add((Component)restoreButton, new GridBagConstraints(indexSavePanel++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.saveRestoreMode.setData(Arrays.asList(new KeyValue("all", "\u0412\u0441\u0435"), new KeyValue("cid", "\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")));
        this.add(this.saveRestorePanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 15, 1, new Insets(5, 5, 5, 0), 0, 0));
        saveButton.addActionListener(e -> this.saveToFile());
        restoreButton.addActionListener(e -> this.restoreFromFile());
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            this.currentPage = this.pagePanel.getPageIndex();
            this.showPage(false);
        });
        this.table.getSelectionModel().addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                return;
            }
            BillTableRow tableRow = (BillTableRow)this.tableModel.getSelectedRow();
            if (tableRow != null) {
                this.currentDocumentId = tableRow.getId();
                this.showPositions();
            }
        });
        this.goButton.addActionListener(e -> this.generate());
        this.organizationComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setAccountData(((IdTitle)e.getItem()).getId());
            }
        });
    }

    private JPanel getTopPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.organizationComboBox, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0411\u0430\u043d\u043a. \u0441\u0447\u0435\u0442:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.bankAccountComboBox, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.date, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.goButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private DefaultHandler getHandler() {
        return new DefaultHandler(){
            private final int NO = 0;
            private final int TABLE = 1;
            private final int ROW = 2;
            private final int POS = 3;
            private final int SUB_BILL = 4;
            private int current = 0;
            List<BGBillTablePos> posList = null;
            BillTableRow row = null;
            BillTableRow parentRow = null;

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                switch (this.current) {
                    case 0: {
                        if (!"table".equals(qName)) break;
                        this.current = 1;
                        break;
                    }
                    case 1: {
                        if (!"row".equals(qName)) break;
                        this.current = 2;
                        this.posList = new ArrayList<BGBillTablePos>();
                        this.row = new BillTableRow(this.posList);
                        this.row.setId(Utils.parseInt((String)attributes.getValue("id"), (int)0));
                        this.row.type = Utils.parseInt((String)attributes.getValue("type"), (int)0);
                        this.row.typeTitle = attributes.getValue("type_title");
                        this.row.cid = Utils.parseInt((String)attributes.getValue("cid"), (int)0);
                        String ch = attributes.getValue("check");
                        this.row.setCheck(BGBillTable.this.isAll ? "1".equals(ch) || "true".equals(ch) : false);
                        this.row.contract = attributes.getValue("contract");
                        this.row.contractComment = attributes.getValue("contract_comment");
                        this.row.setSumma(new BigDecimal(attributes.getValue("summ")));
                        this.row.setRest(new BigDecimal(attributes.getValue("rest")));
                        break;
                    }
                    case 2: {
                        if ("pos".equals(qName)) {
                            this.current = 3;
                            BGBillTablePos pos = new BGBillTablePos();
                            pos.fromElement(attributes);
                            this.posList.add(pos);
                            break;
                        }
                        if (!"sub_bill".equals(qName)) break;
                        this.current = 2;
                        this.parentRow = this.row;
                        if (this.parentRow.subBillList == null) {
                            this.parentRow.subBillList = new ArrayList<BillTableRow>(5);
                        }
                        this.posList = new ArrayList<BGBillTablePos>();
                        this.row = new BillTableRow(this.posList);
                        this.parentRow.subBillList.add(this.row);
                        this.row.setId(Utils.parseInt((String)attributes.getValue("id"), (int)0));
                        this.row.type = Utils.parseInt((String)attributes.getValue("type"), (int)0);
                        this.row.typeTitle = attributes.getValue("type_title");
                        this.row.cid = Utils.parseInt((String)attributes.getValue("cid"), (int)0);
                        this.row.contract = attributes.getValue("contract");
                        this.row.contractComment = attributes.getValue("contract_comment");
                        this.row.setSumma(new BigDecimal(attributes.getValue("summ")));
                        break;
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                switch (this.current) {
                    case 1: {
                        if (!"table".equals(qName)) break;
                        this.current = 0;
                        break;
                    }
                    case 2: {
                        if ("row".equals(qName)) {
                            this.current = 1;
                            BGBillTable.this.rows.add(this.row);
                            break;
                        }
                        if (!"sub_bill".equals(qName)) break;
                        this.current = 2;
                        this.row = this.parentRow;
                        break;
                    }
                    case 3: {
                        if (!"pos".equals(qName)) break;
                        this.current = 2;
                    }
                }
            }
        };
    }

    public void updateData(Object xml, boolean isInvoice) throws Exception {
        this.fl = false;
        this.invoice = isInvoice;
        this.bankAccountComboBox.setEnabled(!isInvoice);
        this.goButton.setText(isInvoice ? "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414" : "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0447\u0435\u0442\u0430");
        this.rows.clear();
        if (xml instanceof InputStream) {
            XMLUtils.parseDocument((InputSource)new InputSource((InputStream)xml), (ContentHandler)this.getHandler());
        } else if (xml instanceof String) {
            XMLUtils.parseDocument((InputSource)new InputSource(new StringReader((String)xml)), (ContentHandler)this.getHandler());
        }
        this.currentPage = 1;
        this.pagePanel.setPageCount(Utils.pageCount((int)this.rows.size(), (int)this.pagePanel.getPageSize()));
        if (this.pagePanel.getPageCount() <= 0) {
            this.pagePanel.setPageCount(1);
        }
        this.showPage(false);
        this.showPositions();
        this.fl = true;
    }

    private void generate() {
        String accountId;
        String date = this.date.getDateString();
        if (Utils.isBlankString((String)date)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443!");
            return;
        }
        int organizationId = this.getOrganizationId();
        if (organizationId == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043b\u0438 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e!");
            return;
        }
        String string = accountId = organizationId > 0 ? this.getAccountId(organizationId) : null;
        if (accountId == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0438\u043b\u0438 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0441\u0447\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e!");
            return;
        }
        if (this.rows != null) {
            boolean isSelect = false;
            for (BillTableRow row : this.rows) {
                if (!row.isCheck().booleanValue()) continue;
                isSelect = true;
                break;
            }
            if (!isSelect) {
                ClientUtils.showErrorMessageDialog((String)("\u041d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e " + (this.invoice ? "\u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u0430, \u0423\u041f\u0414" : "\u0441\u0447\u0435\u0442\u0430") + " \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f!"));
                return;
            }
        }
        if (ClientUtils.confirm((String)(this.invoice ? "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442, \u0423\u041f\u0414?" : "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0447\u0435\u0442\u0430?"), (String)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435")) {
            this.parent.generateBills(this.serialize(organizationId, accountId), date);
        }
    }

    private void showPage(boolean savePos) {
        this.fl = false;
        int pos = this.table.getSelectedRow();
        this.tableModel.setData(new ArrayList());
        int fromPos = (this.currentPage - 1) * this.pagePanel.getPageSize();
        int toPos = Math.min(fromPos + this.pagePanel.getPageSize(), this.rows.size());
        for (int i = fromPos; i < toPos; ++i) {
            this.tableModel.addRow((Object)this.rows.get(i));
        }
        if (savePos && pos < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(pos, pos);
        }
        this.fl = true;
    }

    private void updatePage() {
        this.fl = false;
        int fromPos = (this.currentPage - 1) * this.pagePanel.getPageSize();
        int toPos = Math.min(fromPos + this.pagePanel.getPageSize(), this.rows.size());
        int row = 0;
        for (int i = fromPos; i < toPos; ++i) {
            this.tableModel.getRows().set(row++, this.rows.get(i));
        }
        this.tableModel.fireTableRowsUpdated(0, this.table.getRowCount() - 1);
        this.fl = true;
    }

    private Writable serialize(final int organizationId, final String accountId) {
        final Writable result = this.rows != null ? new Writable(OutputStream.class){

            public void write(Object out) throws IOException {
                try {
                    XMLStreamWriter doc;
                    try {
                        doc = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)out, "UTF-8");
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    doc.writeStartDocument("UTF-8", "1.0");
                    doc.writeStartElement("bills");
                    for (BillTableRow row : BGBillTable.this.rows) {
                        boolean positionsOk;
                        if (!row.isCheck().booleanValue()) continue;
                        boolean bl = positionsOk = row.positionList.size() > 0;
                        if (!positionsOk) {
                            if (row.subBillList == null || row.subBillList.size() == 0) continue;
                            for (BillTableRow subBill : row.subBillList) {
                                if (subBill.positionList == null || subBill.positionList.size() <= 0) continue;
                                positionsOk = true;
                                break;
                            }
                            if (!positionsOk) continue;
                        }
                        doc.writeStartElement("bill");
                        doc.writeAttribute("id", String.valueOf(row.getId()));
                        doc.writeAttribute("type", String.valueOf(row.type));
                        doc.writeAttribute("type_title", row.typeTitle);
                        doc.writeAttribute("cid", String.valueOf(row.cid));
                        doc.writeAttribute("summ", row.getSumma().toPlainString());
                        if (accountId != null) {
                            doc.writeAttribute("account_id", accountId);
                        }
                        if (organizationId > 0) {
                            doc.writeAttribute("organization_id", String.valueOf(organizationId));
                        }
                        for (BGBillTablePos pos : row.positionList) {
                            doc.writeStartElement("pos");
                            pos.toElement(doc);
                            doc.writeEndElement();
                        }
                        if (row.subBillList != null) {
                            for (BillTableRow subBill : row.subBillList) {
                                doc.writeStartElement("sub_bill");
                                doc.writeAttribute("id", String.valueOf(subBill.getId()));
                                doc.writeAttribute("type", String.valueOf(subBill.type));
                                doc.writeAttribute("type_title", subBill.typeTitle);
                                doc.writeAttribute("cid", String.valueOf(subBill.cid));
                                doc.writeAttribute("summ", subBill.getSumma().toPlainString());
                                if (accountId != null) {
                                    doc.writeAttribute("account_id", accountId);
                                }
                                if (organizationId > 0) {
                                    doc.writeAttribute("organization_id", String.valueOf(organizationId));
                                }
                                for (BGBillTablePos pos : subBill.positionList) {
                                    doc.writeStartElement("pos");
                                    pos.toElement(doc);
                                    doc.writeEndElement();
                                }
                                doc.writeEndElement();
                            }
                        }
                        doc.writeEndElement();
                    }
                    doc.writeEndElement();
                    doc.writeEndDocument();
                    doc.flush();
                    doc = null;
                }
                catch (XMLStreamException ex) {
                    if (ex.getCause() instanceof IOException) {
                        throw (IOException)ex.getCause();
                    }
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } : null;
        return new Writable(this, OutputStream.class){

            public void write(Object out) throws IOException {
                GZIPOutputStream gzip = new GZIPOutputStream(IOUtils.urlEncode((OutputStream)new NoClosableOutputStream((OutputStream)out)), 2048);
                result.write((Object)gzip);
                gzip.finish();
                gzip.flush();
                gzip.close();
            }
        };
    }

    public void setData(Document doc) {
        try {
            IdTitle oldIdTitle = (IdTitle)this.organizationComboBox.getSelectedItem();
            IdTitle idTitle = BillUtils.setOrganizationComboBoxData(this.organizationComboBox, this.getBillService(), this.getContractId());
            if (oldIdTitle == null || oldIdTitle.getId() != idTitle.getId() || !oldIdTitle.getTitle().equals(idTitle.getTitle())) {
                this.setAccountData(idTitle.getId());
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setAccountData(int organizationId) {
        try {
            BillUtils.setBankAccountComboBoxData(this.bankAccountComboBox, this.getBillService(), this.getContractId(), organizationId);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void saveToFile() {
        File file = this.selectFile.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        String mode = this.getSaveMode();
        if (mode.equals("all")) {
            try {
                FileOutputStream fw = new FileOutputStream(file);
                XMLStreamWriter doc = XMLOutputFactory.newInstance().createXMLStreamWriter(fw, "UTF-8");
                doc.writeStartDocument("UTF-8", "1.0");
                doc.writeStartElement("table");
                doc.writeStartElement("data");
                for (BillTableRow row : this.rows) {
                    if (!row.isCheck().booleanValue()) continue;
                    doc.writeStartElement("row");
                    doc.writeAttribute("id", String.valueOf(row.getId()));
                    doc.writeAttribute("type", String.valueOf(row.type));
                    doc.writeAttribute("type_title", String.valueOf(row.typeTitle));
                    doc.writeAttribute("cid", String.valueOf(row.cid));
                    doc.writeAttribute("summ", row.getSumma().toPlainString());
                    doc.writeAttribute("contract", row.contract);
                    doc.writeAttribute("contract_comment", row.contractComment);
                    doc.writeAttribute("check", row.isCheck() != false ? "1" : "0");
                    doc.writeAttribute("rest", row.getRest().toPlainString());
                    for (BGBillTablePos pos : row.positionList) {
                        doc.writeStartElement("pos");
                        pos.toElement(doc);
                        doc.writeEndElement();
                    }
                    if (row.subBillList != null) {
                        for (BillTableRow subBill : row.subBillList) {
                            doc.writeStartElement("sub_bill");
                            doc.writeAttribute("id", String.valueOf(subBill.getId()));
                            doc.writeAttribute("type", String.valueOf(subBill.type));
                            doc.writeAttribute("cid", String.valueOf(subBill.cid));
                            doc.writeAttribute("summ", subBill.getSumma().toPlainString());
                            doc.writeAttribute("contract", subBill.contract);
                            doc.writeAttribute("contract_comment", subBill.contractComment);
                            doc.writeAttribute("check", subBill.isCheck() != false ? "1" : "0");
                            for (BGBillTablePos pos : subBill.positionList) {
                                doc.writeStartElement("pos");
                                pos.toElement(doc);
                                doc.writeEndElement();
                            }
                            doc.writeEndElement();
                        }
                    }
                    doc.writeEndElement();
                }
                doc.writeEndElement();
                doc.writeEndElement();
                doc.writeEndDocument();
                doc.flush();
                fw.flush();
                fw.close();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            StringBuilder cids = new StringBuilder();
            for (BillTableRow row : this.rows) {
                if (!row.isCheck().booleanValue()) continue;
                if (cids.length() > 0) {
                    cids.append(",");
                }
                cids.append(String.valueOf(row.cid));
            }
            try {
                FileOutputStream fw = new FileOutputStream(file);
                fw.write(cids.toString().getBytes());
                fw.close();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void restoreFromFile() {
        File file = this.selectFile.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        String mode = this.getSaveMode();
        if (mode.equals("all")) {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    this.updateData(new FileInputStream(file), this.invoice);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435?", "\u0423\u0441\u0435\u0447\u0435\u043d\u0438\u0435", 0) == 0) {
            HashSet cidSet = new HashSet();
            try {
                String str = new String(Utils.readByBlock((InputStream)new FileInputStream(file)));
                cidSet.addAll(Utils.toIntegerList((String)str));
                HashSet<BillTableRow> forDelete = new HashSet<BillTableRow>();
                for (BillTableRow row : this.rows) {
                    if (cidSet.contains(row.cid)) continue;
                    forDelete.add(row);
                }
                this.rows.removeAll(forDelete);
                this.fl = false;
                this.currentPage = 1;
                this.pagePanel.setPageCount(Utils.pageCount((int)this.rows.size(), (int)this.pagePanel.getPageSize()));
                if (this.pagePanel.getPageCount() <= 0) {
                    this.pagePanel.setPageCount(1);
                }
                this.showPage(false);
                this.showPositions();
                this.fl = true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private String getSaveMode() {
        return ((KeyValue)this.saveRestoreMode.getSelectedItem()).getKey();
    }

    private void showPositions() {
        if (this.currentDocumentId > 0) {
            int i;
            int size = this.rows.size();
            for (i = 0; i < size && this.rows.get(i).getId() != this.currentDocumentId; ++i) {
            }
            if (i >= size) {
                return;
            }
            this.currentRow = this.rows.get(i);
            this.positionsEditor.showPositions(this.currentRow);
        } else {
            this.positionsEditor.showPositions(null);
        }
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.positionsEditor.init(module, moduleId);
    }

    public void setPositionList(Node node) {
        this.positionsEditor.setPositionList(node);
    }

    public void setTableSelection(int index0, int index1) {
        this.table.getSelectionModel().setSelectionInterval(index0, index1);
    }

    public void setTableSelectionV() {
        for (BillTableRow billTableRow : this.tableModel.getRows()) {
            billTableRow.setCheck(true);
        }
    }

    public int getOrganizationId() {
        IdTitle item = (IdTitle)this.organizationComboBox.getSelectedItem();
        if (item != null) {
            int organizationId = item.getId();
            if (organizationId == 0) {
                Organization organization = null;
                try {
                    organization = this.getBillService().getDefaultOrganization();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                if (organization != null) {
                    organizationId = organization.getId();
                }
            }
            return organizationId;
        }
        return 0;
    }

    public String getAccountId(int organizationId) {
        IdTitle item = (IdTitle)this.bankAccountComboBox.getSelectedItem();
        if (item != null) {
            int bankAccountId = item.getId();
            if (bankAccountId == 0) {
                BankAccount bankAccount = null;
                try {
                    bankAccount = this.getBillService().getDefaultBankAccount(organizationId);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                if (bankAccount != null) {
                    bankAccountId = bankAccount.getId();
                }
            } else if (bankAccountId == -1) {
                try {
                    bankAccountId = new AccountDialog(this.getBillService().bankAccountList()).getBankAccountId();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            return bankAccountId > 0 ? String.valueOf(bankAccountId) : null;
        }
        return null;
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)this.getContext().getPort(BillService.class, this.getModuleId());
        }
        return this.billService;
    }

    class BillDocsTableModel
    extends BGTableModel<BillTableRow> {
        public BillDocsTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", Boolean.class, 30, 30, 30, "check", true);
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 200, 200, 200, "contract", true);
            this.addColumn("\u0418\u043c\u044f \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 200, 200, 500, "typeTitle", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", 200, 200, -1, "contractComment", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 150, 150, 150, "summa", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0418\u0441\u0445. \u043e\u0441\u0442\u0430\u0442\u043e\u043a", 150, 150, 150, "rest", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean result = false;
            if ("check".equals(this.getIdentifier(columnIndex))) {
                result = true;
            }
            return result;
        }
    }

    class AccountDialog
    extends BGDialog {
        private int bankAccountId = -1;
        private List<BankAccount> titles = null;
        private AccountTableModel accountTableModel = new AccountTableModel(AccountTableModel.class.getName());

        public AccountDialog(List<BankAccount> titles) {
            this.titles = titles;
            this.setModal(true);
            this.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442");
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            this.add(this.getTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.pack();
            this.moveWindowToCenterScreen();
            this.setVisible(true);
        }

        private JPanel getTablePanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.accountTableModel));
            table.setSelectionMode(0);
            this.accountTableModel.setData(this.titles);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        BankAccount bankAccount = (BankAccount)AccountDialog.this.accountTableModel.getSelectedRow();
                        if (bankAccount != null) {
                            AccountDialog.this.bankAccountId = bankAccount.getId();
                        }
                        AccountDialog.this.setVisible(false);
                    }
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        public int getBankAccountId() {
            return this.bankAccountId;
        }
    }

    class AccountTableModel
    extends BGTableModel<BankAccount> {
        public AccountTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

