/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.bill.common.bean.BillAccountsReceivable;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class BillAccountsReceivableManager
extends BGLogger {
    private int moduleId = 0;
    private Connection con = null;

    public BillAccountsReceivableManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public void searchBillAccountsReceivable(SearchResult<BillAccountsReceivable> searchResult, LocalDate onDate) throws Exception {
        ResultSet rs;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String uuid = UUID.randomUUID().toString().replace('-', '_');
        String tableNameContractIdTmp = "bill_contract_" + uuid;
        String query = "CREATE TEMPORARY TABLE " + tableNameContractIdTmp + " AS SELECT id, title, comment FROM contract WHERE fc=1 AND date1<=? AND (date2 IS NULL OR date2>=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        String tableNamePaymentTmp = "bill_payment_" + uuid;
        query = "CREATE TEMPORARY TABLE " + tableNamePaymentTmp + " AS SELECT cid AS contract_id, sum(summa) AS payment_sum FROM contract_payment WHERE dt<=? AND cid IN ( SELECT id FROM " + tableNameContractIdTmp + " ) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        String tableNameDateTmp = "bill_date_" + uuid;
        query = "CREATE TEMPORARY TABLE " + tableNameDateTmp + " AS SELECT cid AS contract_id, max(create_dt) AS bill_date FROM bill_data_" + this.moduleId + " WHERE create_dt<=? AND cid IN ( SELECT id FROM " + tableNameContractIdTmp + " ) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        String tableNameBillTmp = "bill_" + uuid;
        query = "CREATE TEMPORARY TABLE " + tableNameBillTmp + " AS SELECT cid AS contract_id, sum(summ) AS bill_sum FROM bill_data_" + this.moduleId + " WHERE create_dt<=? AND cid IN ( SELECT id FROM " + tableNameContractIdTmp + " ) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.executeUpdate();
        }
        query = "SELECT count(*), sum(IFNULL(b.bill_sum, 0) - IFNULL(p.payment_sum, 0)) FROM " + tableNameContractIdTmp + " AS c  LEFT JOIN " + tableNameBillTmp + " AS b ON c.id=b.contract_id LEFT JOIN " + tableNamePaymentTmp + " AS p ON c.id=p.contract_id WHERE IFNULL(b.bill_sum, 0) - IFNULL(p.payment_sum, 0) > 0";
        ps = this.con.prepareStatement(query);
        try {
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                    searchResult.setSum(rs.getBigDecimal(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "SELECT c.*, (IFNULL(b.bill_sum, 0) - IFNULL(p.payment_sum, 0)) AS dsum FROM " + tableNameContractIdTmp + " AS c  LEFT JOIN " + tableNameBillTmp + " AS b ON c.id=b.contract_id LEFT JOIN " + tableNamePaymentTmp + " AS p ON c.id=p.contract_id HAVING dsum > 0 ORDER BY dsum desc " + page.sqlLimit();
        ps = this.con.prepareStatement(query);
        try {
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(new BillAccountsReceivable().setContractId(rs.getInt("id")).setContractTitle(rs.getString("title")).setContractComment(rs.getString("comment")).setSum(rs.getBigDecimal("dsum")));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        HashMap<Integer, ArrayList<BillData>> billMap = new HashMap<Integer, ArrayList<BillData>>();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String contractIds = list.stream().map(a -> String.valueOf(a.getContractId())).collect(Collectors.joining(", "));
        query = "SELECT cid, create_dt, format_number, summ FROM bill_data_" + this.moduleId + " AS c LEFT JOIN " + tableNameDateTmp + " AS b ON c.id=b.contract_id WHERE create_dt<=? AND create_dt>DATE_SUB( IFNULL(b.bill_date, create_dt), INTERVAL ? MONTH ) AND cid IN ( " + contractIds + " ) ORDER BY cid, create_dt desc";
        try (Object ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)onDate));
            ps.setInt(index++, 6);
            try (ResultSet rs2 = ps.executeQuery();){
                while (rs2.next()) {
                    int contractId = rs2.getInt("cid");
                    ArrayList<BillData> billDatas = (ArrayList<BillData>)billMap.get(contractId);
                    if (billDatas == null) {
                        billDatas = new ArrayList<BillData>();
                        billMap.put(contractId, billDatas);
                    }
                    billDatas.add(new BillData(rs2.getDate("create_dt").toLocalDate(), rs2.getString("format_number"), rs2.getBigDecimal("summ")));
                }
            }
        }
        for (BillAccountsReceivable accountsReceivable : list) {
            List billDatas = (List)billMap.get(accountsReceivable.getContractId());
            if (billDatas == null || billDatas.isEmpty()) continue;
            BigDecimal s = accountsReceivable.getSum();
            ArrayList<BillData> dBills = new ArrayList<BillData>();
            for (BillData billData : billDatas) {
                dBills.add(billData);
                if ((s = s.subtract(billData.sum())).compareTo(BigDecimal.ZERO) >= 0) continue;
                break;
            }
            accountsReceivable.setDate(((BillData)dBills.getLast()).createDate);
            accountsReceivable.setBills(dBills.stream().map(a -> "\u2116" + a.formatNumber + " \u043e\u0442 " + dateTimeFormatter.format(a.createDate)).collect(Collectors.joining("; ")));
        }
        query = "DROP TABLE IF EXISTS " + tableNameContractIdTmp + ", " + tableNamePaymentTmp + ", " + tableNameBillTmp + ", " + tableNameDateTmp;
        ps = this.con.prepareStatement(query);
        try {
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private record BillData(LocalDate createDate, String formatNumber, BigDecimal sum) {
    }
}

