/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server.bean;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.chronopay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.chronopay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public Map<String, String> fields = new HashMap<String, String>();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "chronopay_transaction");
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, SearchParam searchParam) throws SQLException {
        if (searchResult != null) {
            ResultSet rs;
            int index;
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder queryFromWhere = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true").append(this.queryPeriod(period, "pt.create_date"));
            if (Utils.notBlankString((String)searchParam.getStatus()) && !TransactionStatus.ALL.getCode().equals(searchParam.getStatus())) {
                queryFromWhere.append(" AND pt.result=?");
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                queryFromWhere.append(" AND c.title LIKE ?");
            }
            if (searchParam.getContractId() > 0) {
                queryFromWhere.append(" AND c.id=").append(searchParam.getContractId());
            }
            String query = "SELECT pt.*, c.title AS contract_title" + queryFromWhere.toString() + this.getSQLOrder(sort, this.fields) + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                index = this.psSetPeriod(ps, 1, period);
                if (Utils.notBlankString((String)searchParam.getStatus()) && !TransactionStatus.ALL.getCode().equals(searchParam.getStatus())) {
                    ps.setString(index++, searchParam.getStatus());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                try {
                    HashSet<String> columnNames = new HashSet<String>();
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
                        columnNames.add(resultSetMetaData.getColumnName(columnIndex));
                    }
                    while (rs.next()) {
                        list.add(this.getFromRS(rs, columnNames));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            ps = this.con.prepareStatement("SELECT SUM(pt.sum), COUNT(*) " + queryFromWhere.toString());
            try {
                index = this.psSetPeriod(ps, 1, period);
                if (Utils.notBlankString((String)searchParam.getStatus()) && !TransactionStatus.ALL.getCode().equals(searchParam.getStatus())) {
                    ps.setString(index++, searchParam.getStatus());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        BigDecimal summa;
                        if (page != null) {
                            page.setRecordCount(rs.getInt(2));
                        }
                        if ((summa = rs.getBigDecimal(1)) == null) continue;
                        searchResult.setSum(summa);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, Collections.emptySet());
    }

    protected Transaction getFromRS(ResultSet rs, Set<String> columnNames) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(columnNames.contains("contract_title") ? rs.getString("contract_title") : null)).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setTransactionId(rs.getString("transaction_id"))).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doCheckRequest(int contractId) throws Exception {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        SearchParam searchParam = new SearchParam().setPage(new Page(1, 25)).setSort(new String[]{"createDate:1"}).setContractId(contractId).setStatus(TransactionStatus.CREATED.getCode());
        SearchResult searchResult = new SearchResult(searchParam);
        this.searchTransaction((SearchResult<Transaction>)searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            StringBuilder requestParam;
            String transactionId = transaction.getTransactionId();
            if (transactionId == null) continue;
            try {
                requestParam = new StringBuilder("command=c").append("&trans_id=").append(URLEncoder.encode(transactionId, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new BGException((Throwable)e);
            }
            String responseParam = TransactionManager.doRequest(requestParam.toString(), (ParameterMap)moduleSetup);
            if (responseParam == null) continue;
            if (responseParam.startsWith("error: ")) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setPaymentId(-1);
                transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                this.update(transaction);
                continue;
            }
            for (String line : responseParam.split("\n")) {
                if (!line.startsWith("RESULT:")) continue;
                String result = line.substring(7).trim();
                if ("OK".equals(result)) {
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    transaction.setTransactionDate(new Date());
                    Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(moduleSetup.getInt("chronopay.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u041c\u0422\u0421\u0411\u0430\u043d\u043a").build();
                    new PaymentDao(this.con).update((Object)payment);
                    try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                        balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                    }
                    transaction.setPaymentId(payment.getId());
                    transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                    this.update(transaction);
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    continue;
                }
                if ("PENDING".equals(result) || "CREATED".equals(result)) continue;
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setPaymentId(-1);
                transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                this.update(transaction);
            }
        }
    }

    public static String doRequest(String requestParam, ParameterMap moduleSetup) throws BGException {
        StringBuilder result = null;
        try {
            URL url = new URL(moduleSetup.get("", "https://payments.chronopay.ru/ecomm/MerchantHandler"));
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream writer = connection.getOutputStream();
            writer.write(requestParam.getBytes("utf-8"));
            writer.flush();
            writer.close();
            if (connection.getResponseCode() == 200) {
                result = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    result.append(line).append("\n");
                }
                if (LogManager.getLogger().isDebugEnabled()) {
                    LogManager.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 Payment Gate: " + String.valueOf(result));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0448\u043b\u044e\u0437\u0443. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + ex.getMessage(), (Throwable)ex);
        }
        return result == null ? null : result.toString();
    }
}

