/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class DialUpServiceConfigRecalculate
extends ServiceConfigTabbedPanel {
    private boolean _filterInit = false;
    private JTextField sessionsProtoEmail_TF = new JTextField();
    private BGTextField maxProtoEmail_TF = new BGTextField();
    private BGControlPanelMonth maxMonth = new BGControlPanelMonth();
    private BGControlPanelListSelect groups = new BGControlPanelListSelect();
    private BGControlPanelMonthAndDays sessionPeriod = new BGControlPanelMonthAndDays();
    private BGControlPanelContractSelect contracts = new BGControlPanelContractSelect();
    private static final String MAX_TRAFFIC_EMAIL_KEY = "dialup.max";
    private static final String SESSION_EMAIL_KEY = "dialup.session";

    public DialUpServiceConfigRecalculate() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        JButton maxButton = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        JButton runButton = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        JPanel startPanel = new JPanel();
        JPanel topPanel = new JPanel(new GridBagLayout());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        JPanel periodAndContractsPanel = new JPanel(new GridBagLayout());
        maxButton.addActionListener(e -> {
            this.saveUserEmail(MAX_TRAFFIC_EMAIL_KEY, this.maxProtoEmail_TF.getText().trim());
            this.maxRecalculate();
        });
        runButton.addActionListener(e -> {
            this.saveUserEmail(SESSION_EMAIL_KEY, this.sessionsProtoEmail_TF.getText().trim());
            this.sessionsRecalculate();
        });
        this.sessionsProtoEmail_TF.setName(SESSION_EMAIL_KEY);
        this.groups.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        this.sessionPeriod.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        this.sessionPeriod.setDebugGraphicsOptions(0);
        this.sessionsProtoEmail_TF.setMinimumSize(new Dimension(4, 24));
        this.sessionsProtoEmail_TF.setPreferredSize(new Dimension(200, 24));
        periodAndContractsPanel.setBorder(null);
        periodAndContractsPanel.add((Component)this.sessionPeriod, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        periodAndContractsPanel.add((Component)this.contracts, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        startPanel.setLayout(new GridBagLayout());
        startPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0443\u0441\u043a "));
        startPanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        startPanel.add((Component)this.sessionsProtoEmail_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        startPanel.add((Component)runButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        topPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0431\u0441\u0447\u0435\u0442 \u0441\u0435\u0441\u0441\u0438\u0439 "));
        topPanel.add((Component)this.groups, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)periodAndContractsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)startPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.setBorder((Border)new BGTitleBorder(" \u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0435 \u0442\u0440\u0430\u0444\u0438\u043a\u0438 "));
        bottomPanel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)this.maxMonth, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)new JLabel("\u0412\u044b\u0441\u043b\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043d\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)this.maxProtoEmail_TF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)maxButton, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(bottomPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setData() {
        this.initFilterPanel();
        this.maxProtoEmail_TF.setText(this.getUserEmail(MAX_TRAFFIC_EMAIL_KEY));
        this.sessionsProtoEmail_TF.setText(this.getUserEmail(SESSION_EMAIL_KEY));
    }

    private void initFilterPanel() {
        if (!this._filterInit) {
            this._filterInit = true;
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ListGroups");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList((JList)this.groups.getList(), (Node)XMLUtils.getElement((Document)doc, (String)"groups"));
            }
        }
    }

    private void sessionsRecalculate() {
        Request request = new Request();
        request.setModule("dialup");
        request.setModuleId(this.getModuleId());
        request.setAction("RecalculateSessions");
        request.setAttribute("date1", this.sessionPeriod.getDateString1());
        request.setAttribute("date2", this.sessionPeriod.getDateString2());
        request.setAttribute("groups", this.groups.getValue());
        request.setAttribute("contracts", this.contracts.getContracts());
        String email = this.sessionsProtoEmail_TF.getText();
        request.setAttribute("mail", email);
        if (email.length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a!");
        } else {
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", 1);
            }
        }
    }

    private void maxRecalculate() {
        Request request = new Request();
        request.setModule("dialup");
        request.setModuleId(this.getModuleId());
        request.setAction("MaxRecalculate");
        request.setAttribute("date", this.maxMonth.getDateString());
        String email = this.maxProtoEmail_TF.getText();
        request.setAttribute("mail", email);
        if (email.length() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a!");
        } else {
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043e\u043f\u043e\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0431\u0443\u0434\u0435\u0442 \n\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 EMail", "\u041f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d", 1);
            }
        }
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.contracts.init(module, mid);
    }
}

