/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class TariffZoneTariffTreeNode
extends DefaultTariffTreeNode {
    private JLabel view;
    private JPanel editor;
    private BGTextField zone;
    private BGComboBox<IdTitle> paymentTypeComboBox;
    private JComboBox<ComboBoxItem> actionComboBox;
    private JCheckBox paymentCheckBox;
    private BGTextField sum;
    private BGTextField eventNameTf;
    private String zoneString;
    private String action;
    private boolean addPayment;
    private int paymentType;
    private float paymentSum;
    private String eventName;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
    }

    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    public Component getEditor() throws Exception {
        if (this.editor == null) {
            this.zone = new BGTextField();
            this.paymentCheckBox = new JCheckBox("\u0417\u0430\u043d\u0435\u0441\u0442\u0438 \u043f\u0440\u0438\u0445\u043e\u0434:");
            this.actionComboBox = new BGComboBox();
            this.actionComboBox.addItem(new ComboBoxItem((Object)"0", "-- \u043d\u0435\u0442 --"));
            this.actionComboBox.addItem(new ComboBoxItem((Object)"1", "\u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0442\u044c"));
            this.actionComboBox.addItem(new ComboBoxItem((Object)"2", "\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c CoA"));
            this.eventNameTf = new BGTextField();
            this.paymentTypeComboBox = new BGComboBox();
            this.sum = new BGTextField(5);
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> {
                if ("ok".equals(e.getActionCommand())) {
                    this.editOk();
                } else if ("cancel".equals(e.getActionCommand())) {
                    this.tree.getViewableTree().stopEditing();
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.paymentCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.paymentTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)this.sum, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.editor = new JPanel(new GridBagLayout());
            this.editor.add((Component)new JLabel("\u0417\u043e\u043d\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.editor.add((Component)this.zone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)new JLabel("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add(this.actionComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)new JLabel("\u0421\u043e\u0431\u044b\u0442\u0438\u0435 BGBS:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.eventNameTf, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)panel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.editor.add((Component)okCancel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.buildDirectoryCombo(this.getDirManager().getDirectory("payment_types"), (JComboBox)this.paymentTypeComboBox);
        }
        this.zone.setText(this.zoneString);
        this.actionComboBox.setSelectedIndex(0);
        ClientUtils.setComboBoxSelection(this.actionComboBox, (Object)this.action);
        this.paymentCheckBox.setSelected(this.addPayment);
        this.eventNameTf.setText(this.eventName);
        this.setDirectoryItemSelection((JComboBox)this.paymentTypeComboBox, this.paymentType);
        this.sum.setText(Utils.formatCost((float)this.paymentSum));
        return this.editor;
    }

    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(ClientUtils.getIcon((String)"tag_green.png"), 2);
        }
        this.loadData();
        StringBuilder sb = new StringBuilder();
        sb.append("\u0417\u043e\u043d\u0430: ").append(this.zoneString);
        this.view.setText(sb.toString());
        return this.view;
    }

    protected void loadData() {
        Map data = this.getDataInHash();
        this.zoneString = (String)data.get("zone");
        this.action = Utils.maskNull((String)((String)data.get("disconnect")));
        this.addPayment = "1".equals(data.get("addPayment"));
        this.paymentType = Utils.parseInt((String)((String)data.get("paymentType")), (int)0);
        this.paymentSum = Utils.parseFloat((String)((String)data.get("paymentSum")), (float)0.0f);
        this.eventName = Utils.maskNull((String)((String)data.get("eventName")));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("zone", this.zone.getText());
        data.put("disconnect", ClientUtils.getIdFromComboBox(this.actionComboBox));
        data.put("addPayment", this.paymentCheckBox.isSelected() ? "1" : "0");
        data.put("paymentType", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.paymentTypeComboBox)));
        data.put("paymentSum", Utils.formatCost((float)Utils.parseFloat((String)this.sum.getText(), (float)0.0f)));
        data.put("eventName", this.eventNameTf.getText());
        super.setDataInHash(data);
        this.saveData();
    }

    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        el.setAttribute("zone", this.zone.getText());
        el.setAttribute("disconnect", ClientUtils.getIdFromComboBox(this.actionComboBox));
        el.setAttribute("addPayment", this.addPayment ? "1" : "0");
        el.setAttribute("paymentType", String.valueOf(this.paymentType));
        el.setAttribute("paymentSum", Utils.formatCost((float)this.paymentSum));
        el.setAttribute("eventName", this.eventName);
        this.serializeChildsToXML(el);
    }

    public void loadFromXML(Element el) throws Exception {
        String zone = el.getAttribute("zone");
        if (zone.length() > 0) {
            this.zoneString = zone;
            this.action = el.getAttribute("disconnect");
            this.addPayment = "1".equals(el.getAttribute("addPayment"));
            this.paymentType = Utils.parseInt((String)el.getAttribute("paymentType"), (int)0);
            this.paymentSum = Utils.parseFloat((String)el.getAttribute("paymentSum"), (float)0.0f);
            this.eventName = el.getAttribute("eventName");
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("zone", this.zoneString);
            data.put("disconnect", this.action);
            data.put("addPayment", this.addPayment ? "1" : "0");
            data.put("paymentType", String.valueOf(this.paymentType));
            data.put("paymentSum", Utils.formatCost((float)this.paymentSum));
            data.put("eventName", this.eventName);
            this.setDataInHash(data);
            this.saveData();
        }
        this.loadChildsFromXML(el);
    }
}

