/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.call.bean.CardCallUtils;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.processor.LC_LimitChecker;
import bitel.billing.server.processor.LoginError;
import bitel.billing.server.processor.dialup.ConnectionCountChecker;
import bitel.billing.server.processor.dialup.DNSUpdater;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.processor.dialup.EventBusListener;
import bitel.billing.server.processor.dialup.LevelManager;
import bitel.billing.server.processor.dialup.RejectToAccept;
import bitel.billing.server.processor.dialup.UpdateSuspendedSetter;
import bitel.billing.server.processor.dialup.UsedConnectionsMonitor;
import bitel.billing.server.radius.Antispam;
import bitel.billing.server.radius.RadiusSetup;
import bitel.billing.server.util.ConsoleTable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.AlarmTask;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.network.radius.AbstractRadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.dialup.server.DetailCompressRules;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginManager;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginParameter;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginParameterManager;
import ru.bitel.bgbilling.modules.dialup.server.event.radius.RadiusAuthenticationEvent;
import ru.bitel.bgbilling.modules.dialup.server.radius.ConnectionInfo;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpFlowListener;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusSessionParams;
import ru.bitel.bgbilling.modules.dialup.server.radius.IpAddressSet;
import ru.bitel.bgbilling.modules.dialup.server.radius.StaticAddressMonitor;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.RangedLongSet;

public class DialUpRadiusProcessor
extends AbstractRadiusProcessor<DialUpNasConnection, DialUpNas, DialUpRadiusSessionParams> {
    private static final Logger logger = LogManager.getLogger();
    private List<DialUpFlowListener> flowListenerList = new CopyOnWriteArrayList<DialUpFlowListener>();
    public static final RadiusPacket.RadiusPacketOption<Integer> SERVICE_TIME = new RadiusPacket.RadiusPacketOption("service_time");
    private Map<String, RangedLongSet> ipPools;
    private Map<String, Float> poolAlarmFullnessPercent;
    public static final IpAddressSet usedAddressSet = new IpAddressSet();
    public final StaticAddressMonitor staticAddressMonitor;
    private UpdateSuspendedSetter updateSuspendedSetter;
    private int checkDuplicateSessionOnSessionLimit = 0;
    private static final Pattern patternRouteNet1 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+");
    private static final Pattern patternRouteNet2 = Pattern.compile("^(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s*/\\s*(\\d+)");

    public DialUpRadiusProcessor(Setup setup, int moduleId) throws BGException {
        super(setup, "dialup", moduleId, (NasList)new DialupNasList());
        this.checkDuplicateSessionOnSessionLimit = setup.getModuleSetup(Integer.valueOf(moduleId)).getInt("check.duplicate.session", setup.getInt("check_duplicate_session", 0));
        DetailCompressRules.initCompressRule(moduleId);
        LC_LimitChecker limitChecker = new LC_LimitChecker(){

            protected int getLoginSessionsCount(int lid) {
                int result = 0;
                for (DialUpNasConnection connection : DialUpRadiusProcessor.this.connections()) {
                    DialUpSessionRealtime session = (DialUpSessionRealtime)connection.getSession();
                    if (session.getLogin().getId() != lid || connection.getStatus() != NasConnection.Status.working) continue;
                    ++result;
                }
                return result;
            }
        };
        limitChecker.init(moduleId);
        LC_LimitChecker.setLimitChecker((LC_LimitChecker)limitChecker);
        DNSUpdater.initUpdater(moduleId, this);
        AlarmSender.initSender((DefaultServerSetup)setup);
        AlarmSender.registerAlarmTask((AlarmTask)new DatabaseCheckTask());
        this.initPools();
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        ArrayList<AtomicInteger> counters = new ArrayList<AtomicInteger>();
        int count = 0;
        for (Object nas : this.nasList.nases()) {
            AtomicInteger atomicInteger = new AtomicInteger();
            counters.add(atomicInteger);
            tasks.add(((DialUpNas)((Object)nas)).restoreConnections(moduleId, this.nasList, atomicInteger));
            count += atomicInteger.get();
        }
        ArrayList futures = new ArrayList();
        try {
            for (Callable callable : tasks) {
                futures.add(executorService.submit(callable));
            }
            for (Future future : futures) {
                while (!future.isDone()) {
                    try {
                        future.get(5L, TimeUnit.SECONDS);
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        this.printCount(count, counters);
                    }
                    this.printCount(count, counters);
                }
            }
            this.printCount(count, counters);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        executorService.shutdown();
        this.collectorInit();
        new UsedConnectionsMonitor(this);
        new ConnectionCountChecker(this);
        this.updateSuspendedSetter = new UpdateSuspendedSetter((DefaultServerSetup)setup, this);
        new EventBusListener(this, moduleId);
        RejectToAccept.initRejectToAccept(moduleId);
        this.staticAddressMonitor = new StaticAddressMonitor(this, moduleId);
    }

    protected void reloadConfig() {
        super.reloadConfig();
        DetailCompressRules.initCompressRule(this.moduleId);
        DNSUpdater.initUpdater(this.moduleId, this);
        AlarmSender.initSender((DefaultServerSetup)this.setup);
        AlarmSender.registerAlarmTask((AlarmTask)new DatabaseCheckTask());
        this.initPools();
        this.updateSuspendedSetter.shutdown();
        this.updateSuspendedSetter = new UpdateSuspendedSetter((DefaultServerSetup)this.setup, this);
        RejectToAccept.initRejectToAccept(this.moduleId);
    }

    protected void afterNasListReload() {
        this.collectorInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void collectorInit() {
        BGNestedContext.push((String)"collector");
        try {
            for (DialUpFlowListener listener : this.flowListenerList) {
                listener.shutdown();
            }
            this.flowListenerList.clear();
            logger.info("Collector init");
            int portNetFlow = this.setup.getInt("netflow.port", 0);
            int recvBufferSize = this.setup.getInt("netflow.receive.buffer.capacity", 0x800000);
            recvBufferSize = this.setup.getInt("collector.capture.flow.buffer.capacity", recvBufferSize);
            int soRCVBUF = this.setup.getInt("netflow.receive.socket.buffer.size", 524288);
            soRCVBUF = this.setup.getInt("collector.capture.flow.socket.buffer.capacity", soRCVBUF);
            int threadCount = this.setup.getInt("netflow.thread.count", 8);
            threadCount = this.setup.getInt("collector.capture.flow.thread.count", threadCount);
            if (portNetFlow > 0 && portNetFlow <= 65535) {
                this.addFlowListener(0, (RadiusSetup)this.setup, portNetFlow, (ParameterMap)this.setup, threadCount, recvBufferSize, soRCVBUF, true);
            }
            SortedMap values = this.setup.subIndexed("collector.capture.flow.port.");
            for (Map.Entry e : values.entrySet()) {
                ParameterMap params = (ParameterMap)e.getValue();
                portNetFlow = params.getInt("", -1);
                if (portNetFlow <= 0) continue;
                this.addFlowListener((Integer)e.getKey(), (RadiusSetup)this.setup, portNetFlow, params, threadCount, recvBufferSize, soRCVBUF, false);
            }
        }
        finally {
            BGNestedContext.pop();
        }
    }

    private void initPools() {
        HashMap<String, RangedLongSet> ipPools = new HashMap<String, RangedLongSet>();
        ParameterMap pools = this.setup.sub("pools.");
        for (Map.Entry entry : pools.entrySet()) {
            DialUpRadiusProcessor.loadPools(ipPools, (String)entry.getKey(), pools.get((String)entry.getKey(), null));
        }
        this.ipPools = Collections.unmodifiableMap(ipPools);
        this.poolAlarmFullnessPercent = new ConcurrentHashMap<String, Float>();
        ParameterMap poolPercent = this.setup.sub("pool.alarm.fullness.");
        for (Map.Entry me : poolPercent.entrySet()) {
            float percent = Utils.parseFloat((String)((String)me.getValue()), (float)101.0f);
            if (percent > 100.0f) {
                logger.error("Incorrect IP pool fullness alarm percent: " + (String)me.getValue() + " for pool: " + (String)me.getKey());
                continue;
            }
            this.poolAlarmFullnessPercent.put((String)me.getKey(), Float.valueOf(percent));
        }
    }

    private DialUpFlowListener addFlowListener(int index, RadiusSetup setup, int port, ParameterMap params, int threadCount, int recvBufferSize, int soRCVBUF, boolean old) {
        logger.info("Starting FlowListener on port " + port + " [recv_buf_size=" + recvBufferSize + "]");
        String nases = params.get("nases", "");
        recvBufferSize = params.getInt("buffer.capacity", recvBufferSize);
        soRCVBUF = params.getInt("socket.buffer.capacity", soRCVBUF);
        threadCount = params.getInt("thread.count", threadCount);
        Integer sourceType = null;
        if (!old) {
            String srcType = params.get("type", "");
            logger.error("collector.capture.flow.port." + index + ".type=" + srcType + " (must be 'netflow' or 'sflow')");
            throw new IllegalArgumentException("type=" + params.get("type", null));
        }
        DialUpFlowListener l = DialUpFlowListener.newInstance(setup, port, threadCount, recvBufferSize, soRCVBUF, this.nasList.nases(), sourceType, nases);
        l.init();
        l.startListener();
        this.flowListenerList.add(l);
        return l;
    }

    private void printCount(int count, List<AtomicInteger> counters) {
        int c = 0;
        for (AtomicInteger i : counters) {
            c += i.get();
        }
        c = count - c;
        double percent = count != 0 ? (double)c * 100.0 / (double)count : 100.0;
        DecimalFormat df = new DecimalFormat("##0.00", Localizer.getDecimalFormatSymbols());
        logger.info("Restored " + c + "/" + count + " connections (" + df.format(percent) + "%)");
    }

    public static void loadPools(Map<String, RangedLongSet> ipPools, String poolName, String addrs) {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        block4: for (String rr : addrs.split(";")) {
            long start;
            long end;
            String[] r = rr.split("-");
            switch (r.length) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    start = end = IPUtils.convertStringIPtoLong((String)r[0]);
                    break;
                }
                default: {
                    start = IPUtils.convertStringIPtoLong((String)r[0]);
                    end = IPUtils.convertStringIPtoLong((String)r[1]);
                }
            }
            ranges.add(new long[]{start, end});
        }
        ipPools.put(poolName, new RangedLongSet(ranges));
    }

    protected void preprocessAccessRequest(DialUpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        super.preprocessAccessRequest((Nas)nas, request, response, connectionSet);
    }

    protected void preprocessAccountingRequest(DialUpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        super.preprocessAccountingRequest((Nas)nas, request, response, connectionSet);
    }

    protected RadiusSession<DialUpNas, DialUpRadiusSessionParams> newRadiusSession(Connection con, DialUpNas nas, RadiusPacket request, RadiusSession.State state) {
        int pos;
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        String realm = null;
        if (userNameAttribute == null) {
            userNameAttribute = new RadiusAttribute.RadiusAttributeString(-1, 1, "");
            request.setAttribute((RadiusAttribute)userNameAttribute);
            logger.warn("Attribute User-Name not found!");
        }
        String userName = (String)userNameAttribute.getValue();
        if (this.setup.getBoolean("trim.user.name", true)) {
            userName = userName.trim();
        }
        realm = (pos = userName.indexOf("@")) > 0 ? userName.substring(pos + 1) : "default";
        userName = Utils.deleteAfterDog((String)userName);
        if (this.setup.getInt("remove.user.name.before.backslash", 1) == 1 && (pos = userName.indexOf(92)) >= 0) {
            userName = userName.substring(pos + 1);
        }
        userNameAttribute = userNameAttribute.clone();
        if (request.getAttribute(-1, 79) != null) {
            return new EAPSession(userName, userNameAttribute, (Object)new DialUpRadiusSessionParams(realm));
        }
        return new RadiusSession(state != null ? state.state : null, userName, userNameAttribute, (Object)new DialUpRadiusSessionParams(realm));
    }

    protected Login getLogin(Connection con, int cid, Card card) {
        Login result = null;
        try {
            int sessionCol = this.setup.getInt("card.login.session.count", 0);
            int lid = new CardCallUtils(con, this.moduleId).createLogin(cid, card, sessionCol);
            if (lid > 0) {
                result = new DialUpLoginManager(con, this.moduleId).getLoginById(lid);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    protected Login getLogin(DialUpNas nas, RadiusPacket req, RadiusPacket resp, Connection con, String userName) {
        DialUpLogin result = null;
        if (userName != null) {
            try {
                result = new DialUpLoginManager(con, this.moduleId).findLogin(userName, new Date());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authenticationImpl(RadiusListenerWorker<?> req, DialUpNas nas, RadiusSession<DialUpNas, DialUpRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId, boolean realtimeTariff) {
        int result;
        int changedResult = result = super.authenticationImpl(req, (Nas)nas, radiusSession, request, response, connectionSet, logRecordId, realtimeTariff);
        if (result != 0 && RejectToAccept.getRejectToAccept().modifyResponse(result, response, nas)) {
            String realm = ((DialUpRadiusSessionParams)radiusSession.sessionParams).realm;
            String userName = radiusSession.userName;
            DialUpSessionRealtime ses = new DialUpSessionRealtime(true, nas.isSecondCalculatePeriod());
            ses.setMid(this.moduleId);
            ses.setRealm(realm);
            String loginName = this.getLoginName(userName, realm);
            ses.setLoginName(loginName);
            String phone = nas.getPhoneOnPort(String.valueOf(request.getIntAttribute(-1, 5, null)));
            if (Utils.isBlankString((String)phone)) {
                phone = Utils.maskNull((String)request.getStringAttribute(-1, 30, ""));
            }
            ses.setFromNumber(request.getStringAttribute(-1, 31, ""));
            ses.setToNumber(phone);
            DialUpNasConnection nasCon = new DialUpNasConnection(ses, (DefaultServerSetup)this.setup, this.nasList, nas.getId());
            DialUpRadiusProcessor dialUpRadiusProcessor = this;
            synchronized (dialUpRadiusProcessor) {
                long time1 = System.currentTimeMillis();
                this.setIpAddr(nas, ses, request, response, realm);
                long time2 = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug("Set address time: " + (time2 - time1));
                }
                if (nas.setConnection(nasCon, request, connectionSet.getConnection(), connectionSet.getSlaveConnection()) != null) {
                    changedResult = 0;
                    Contract contract = radiusSession.contract;
                    RejectToAccept.getRejectToAccept().insertErrorInBase(contract == null ? 0 : contract.getId(), result, response);
                    logger.info("Reject-To-Accept processed");
                } else {
                    logger.error("Reject-To-Accept set connection error");
                }
            }
        }
        return changedResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authorization(RadiusListenerWorker<?> req, DialUpNas nas, RadiusSession<DialUpNas, DialUpRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, ContractManager contrM, Contract contract, Object _login, String userName) {
        Connection con = connectionSet.getConnection();
        int result = 0;
        DialUpLogin login = (DialUpLogin)((Object)_login);
        String realm = ((DialUpRadiusSessionParams)radiusSession.sessionParams).realm;
        DialUpLoginManager dlu = new DialUpLoginManager(con, this.moduleId);
        DialUpSessionRealtime session = null;
        HashSet<Integer> attrSets = new HashSet<Integer>(8);
        HashSet<Integer> nasSet = new HashSet<Integer>(3);
        ArrayList<String> authAttrFilters = new ArrayList<String>(3);
        if (contract != null && _login != null) {
            login.setAttributeSets(dlu.loadAttrSet(login.getId(), realm));
            login.setAvpPairs(dlu.loadAVPPairs(login));
            attrSets.addAll(login.getAttributeSets());
            session = new DialUpSessionRealtime(false, nas.isSecondCalculatePeriod());
            session.setMid(this.moduleId);
            session.setLogin(login);
            session.setContract(contract);
            session.setRealm(realm);
            String loginName = this.getLoginName(userName, realm);
            session.setLoginName(loginName);
            session.setRequestLogRecordId(log_record_id);
            DialUpLoginParameterManager paramUtils = new DialUpLoginParameterManager(con, this.moduleId, (Preferences)this.setup);
            try {
                DialUpLoginParameter param = paramUtils.getLoginParameter(session.getLogin().getId()).get("dialup.dns");
                if (param != null) {
                    session.setDynDNSType(Utils.parseInt((String)param.getValue()));
                }
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            int port = request.getIntAttribute(-1, 5, Integer.valueOf(0));
            String port_str = String.valueOf(port);
            Integer requestServiceTime = (Integer)request.getOption(SERVICE_TIME);
            if (requestServiceTime != null && requestServiceTime > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Taking timeService from script setting=" + requestServiceTime);
                }
                session.setServiceTime(requestServiceTime);
            } else {
                session.setServiceTime(nas.getTimeService(realm, port_str));
            }
            List<Traffic> trafficConfig = nas.getTrafficConfig(realm, port_str);
            session.setTrafficConfig(trafficConfig);
            GregorianCalendar now = new GregorianCalendar();
            if (session.getServiceTime() <= 0 || trafficConfig == null) {
                result = 7;
                session = null;
            } else {
                session.setCalculatePeriod(con, (Calendar)new GregorianCalendar());
                if (session.getCalculatePeriodEnd() == null || session.getCalculatePeriodStart() == null) {
                    result = 31;
                    session = null;
                } else {
                    ContractTariffOptionDao contractTariffOptionM = new ContractTariffOptionDao(con);
                    contract.setTts(contrM.getRealtimeTariffTreeSet(contract.getId(), session.getCalculatePeriodStart(), this.module, this.moduleId, true));
                    try {
                        contract.setTariffOptions(contractTariffOptionM.getContractRealtimeTariffOptionList(contract.getId(), session.getCalculatePeriodStart().getTime()));
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    logger.debug("Checking tariff...");
                    if (contract.getTts().getTree((Calendar)new GregorianCalendar()) == null) {
                        logger.debug("Tariff plan not found.");
                        result = 3;
                        session = null;
                    } else {
                        try {
                            ContractStatusDao contractStatusDao = new ContractStatusDao(con);
                            session.resetAndInitTreeSet(contractStatusDao, new GregorianCalendar(), con);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        if (!session.checkPrices(now, attrSets, nasSet, authAttrFilters)) {
                            result = 11;
                            session = null;
                        }
                    }
                }
                if (session != null) {
                    for (String filter : authAttrFilters) {
                        int pos = filter.indexOf(61);
                        if (pos <= 0) continue;
                        String attrName = filter.substring(0, pos);
                        String regexp = filter.substring(pos + 1);
                        try {
                            Pattern pattern;
                            String value = null;
                            RadiusAttributeInfo info = RadiusDictionary.findAttributeInfo((String)attrName);
                            if (info != null) {
                                RadiusAttribute ra = request.getAttribute(info.vendor, info.type);
                                String string = value = ra != null ? ra.toString() : null;
                            }
                            if ((pattern = Pattern.compile(regexp)).matcher(value).matches()) continue;
                            result = 36;
                            session = null;
                            break;
                        }
                        catch (Exception value) {
                        }
                    }
                }
                if (session != null && nasSet.size() > 0 && !nasSet.contains(nas.getId())) {
                    result = 34;
                    session = null;
                }
                if (session != null) {
                    Set<Integer> sidSet = session.getServices();
                    if (!this.checkService(con, contract.getId(), sidSet)) {
                        result = 19;
                        session = null;
                    }
                }
            }
            if (!this.canLoginUseRealm(login, realm)) {
                result = 18;
                session = null;
            }
        }
        if (session != null) {
            LoginError error;
            LC_LimitChecker limitChecker = LC_LimitChecker.getLimitChecker();
            String phone = nas.getPhoneOnPort(String.valueOf(request.getIntAttribute(-1, 5, Integer.valueOf(0))));
            if (Utils.isBlankString((String)phone)) {
                phone = request.getStringAttribute(-1, 30, "");
            }
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("time", new GregorianCalendar());
            params.put("phone", phone);
            String from_phone = request.getStringAttribute(-1, 31, null);
            if (from_phone != null) {
                params.put("from_phone", from_phone);
            }
            if ((error = limitChecker.canComeIn(con, params, (Login)login)) != null) {
                result = error.getErrorCode();
                if (this.checkDuplicateSessionOnSessionLimit > 0 && result == 21) {
                    this.checkDuplicateSession(request, login.getId());
                }
            } else {
                boolean addServiceTypeAndFramedProtocol;
                boolean monthBreak;
                String[] tokens;
                String limitAttribute = null;
                String limitValue = null;
                String attrAndSid = nas.getConf().get("service.limit.attribute", null);
                if (attrAndSid != null && (tokens = attrAndSid.split(":")).length == 2) {
                    limitAttribute = tokens[0];
                    long limVal = session.getMaxServiceAmount(con, Utils.parseInt((String)tokens[1], (int)0), new GregorianCalendar());
                    if (limVal <= 0L) {
                        limitAttribute = null;
                    } else {
                        limitValue = String.valueOf(limVal);
                    }
                }
                session.setRequestLogRecordId(log_record_id);
                session.setFromNumber(request.getStringAttribute(-1, 31, null));
                session.setToNumber(phone);
                DialUpNasConnection nasCon = new DialUpNasConnection(session, (DefaultServerSetup)this.setup, this.nasList, nas.getId());
                nasCon.addRadiusAttributes((RadiusAttributeSet)response, attrSets, limitAttribute, limitValue);
                this.processRouteAttributes(response, session);
                boolean bl = monthBreak = this.setup.getInt("month.break", 0) == 1;
                if (monthBreak) {
                    long msNow = System.currentTimeMillis();
                    int monthBreakPeriod = nas.getConf().getInt("month.break.period", 3600);
                    GregorianCalendar nextMonth = new GregorianCalendar();
                    ((Calendar)nextMonth).add(2, 1);
                    nextMonth.set(5, 1);
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)nextMonth);
                    int secondToNextMonth = (int)((nextMonth.getTimeInMillis() - msNow) / 1000L) + 600;
                    Integer timeout = response.getIntAttribute(-1, 27, null);
                    if (timeout == null || timeout > (secondToNextMonth += new Random().nextInt(monthBreakPeriod))) {
                        response.setIntAttribute(-1, 27, secondToNextMonth);
                    }
                }
                boolean bl2 = addServiceTypeAndFramedProtocol = this.setup.getInt("add.service.type.and.framed.protocol", 1) == 1;
                if (addServiceTypeAndFramedProtocol) {
                    response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeInteger(-1, 6, 2));
                    response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeInteger(-1, 7, 1));
                }
                DialUpRadiusProcessor dialUpRadiusProcessor = this;
                synchronized (dialUpRadiusProcessor) {
                    long time1 = System.currentTimeMillis();
                    this.setIpAddr(nas, session, request, response, realm);
                    long time2 = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Set address time: " + (time2 - time1));
                    }
                    if (nas.setConnection(nasCon, request, con, connectionSet.getSlaveConnection()) == null) {
                        result = 12;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDuplicateSession(RadiusPacket request, int loginId) {
        String callingStationId = request.getStringAttribute(-1, 31, null);
        if (callingStationId != null) {
            for (DialUpNasConnection con : this.connections()) {
                DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                if (session.getLogin().getId() != loginId || con.getStatus() != NasConnection.Status.working || session.isFakeSession() || !callingStationId.equals(session.getFromNumber())) continue;
                switch (this.checkDuplicateSessionOnSessionLimit) {
                    case 2: {
                        DialUpNas nas;
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Close connection by session limit and eq callingStationId..");
                        con.kill(con.getNas());
                        DialUpNas dialUpNas = nas = (DialUpNas)con.getNas();
                        synchronized (dialUpNas) {
                            nas.dropConnection(((DialUpSessionRealtime)con.getSession()).getNasPort());
                            break;
                        }
                    }
                    case 3: {
                        DialUpNas nas;
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Close connection by session limit and eq callingStationId..");
                        DialUpNas dialUpNas = nas = (DialUpNas)con.getNas();
                        synchronized (dialUpNas) {
                            nas.dropConnection(((DialUpSessionRealtime)con.getSession()).getNasPort());
                            break;
                        }
                    }
                    default: {
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Breaking connection by session limit and eq callingStationId..");
                        con.kill(con.getNas());
                    }
                }
            }
        }
    }

    private String getLoginName(String userName, String realm) {
        Object loginName = userName;
        if (Utils.notBlankString((String)realm) && !realm.equals("default")) {
            loginName = (String)loginName + "@" + realm;
        }
        return loginName;
    }

    protected LocalEvent newRadiusAuthenticationEvent(RadiusPacket request, RadiusPacket response, RadiusSession<DialUpNas, DialUpRadiusSessionParams> radiusSession, int logRecordId) {
        return new RadiusAuthenticationEvent(radiusSession, this.moduleId, logRecordId, request, response);
    }

    private void processRouteAttributes(RadiusPacket response, DialUpSessionRealtime session) {
        List routeAddrList = response.getAttributes(-1, 22);
        if (routeAddrList != null) {
            for (RadiusAttribute ra : routeAddrList) {
                String value = (String)((RadiusAttribute.RadiusAttributeString)ra).getValue();
                IpNet net = new IpNet();
                Matcher m = patternRouteNet1.matcher(value);
                if (m.find()) {
                    net.net = IPUtils.convertStringIPtoLong((String)m.group(1), (long)0L);
                    net.mask = IPUtils.convertStringIPtoLong((String)m.group(2), (long)0L);
                } else {
                    m = patternRouteNet2.matcher(value);
                    if (m.find()) {
                        net.net = IPUtils.convertStringIPtoLong((String)m.group(1), (long)0L);
                        net.mask = IPUtils.getMask((int)Utils.parseInt((String)m.group(2)));
                    }
                }
                if (net.net <= 0L || net.mask <= 0L) continue;
                session.addIpNet(net);
            }
        }
    }

    protected void setIpAddr(DialUpNas nas, DialUpSessionRealtime session, RadiusPacket request, RadiusPacket response, String realm) {
        long ipAddr;
        int freeIp;
        int freeIp2;
        int freeIp3;
        String poolName;
        int frIp = response.getIntAttribute(-1, 8, Integer.valueOf(0));
        if (frIp != 0) {
            session.setIpAddress(Utils.unsignedIntToLong((int)frIp));
        } else {
            List<Long> ips = this.staticAddressMonitor.getActiveAddressList(session.getLogin().getId(), new Date(), realm);
            Long freeIp4 = usedAddressSet.tryOffer(ips, session);
            if (freeIp4 != null) {
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, freeIp4.intValue()));
                session.setIpAddress(freeIp4);
            } else if (ips.size() > 0) {
                freeIp4 = ips.get(0);
                usedAddressSet.add(freeIp4, session);
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, freeIp4.intValue()));
                session.setIpAddress(freeIp4);
            }
        }
        if (session.getIpAddress() == 0L && (poolName = response.getStringAttribute(-1, 88, null)) != null && (freeIp3 = nas.getFreeIpFromPool(this.ipPools, usedAddressSet, this.staticAddressMonitor.currentStaticAddressSet, session, poolName, this.poolAlarmFullnessPercent)) != 0) {
            response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, freeIp3));
            session.setIpAddress(Utils.unsignedIntToLong((int)freeIp3));
        }
        if (session.getIpAddress() == 0L && (freeIp2 = nas.getFreeIpFromPool(this.ipPools, usedAddressSet, this.staticAddressMonitor.currentStaticAddressSet, session, "global", this.poolAlarmFullnessPercent)) != 0) {
            response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, freeIp2));
            session.setIpAddress(Utils.unsignedIntToLong((int)freeIp2));
        }
        if (session.getIpAddress() == 0L && (freeIp = nas.getFreeIpFromPool(this.ipPools, usedAddressSet, this.staticAddressMonitor.currentStaticAddressSet, session, "global-extra", this.poolAlarmFullnessPercent)) != 0) {
            response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, freeIp));
            session.setIpAddress(Utils.unsignedIntToLong((int)freeIp));
        }
        if (session.getIpAddress() == 0L && (ipAddr = Utils.unsignedIntToLong((int)request.getIntAttribute(-1, 8, Integer.valueOf(0)))) != 0L) {
            usedAddressSet.add(ipAddr, session);
            session.setIpAddress(ipAddr);
        }
        if (session.getIpAddress() != 0L && nas.getConf().getInt("drop.framed.pool.attr", 0) == 1) {
            response.removeAttributes(-1, 88);
        }
    }

    private boolean canLoginUseRealm(DialUpLogin login, String realm) {
        boolean result = false;
        if (realm == null) {
            logger.error("Realm is NULL!!!");
        } else {
            String realms = this.setup.getModuleSetup(Integer.valueOf(this.moduleId)).get("realmgr." + login.getRealmGroup(), "");
            StringTokenizer st = new StringTokenizer(realms, ";");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(realm)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected DialUpNasConnection accounting(RadiusListenerWorker<DialUpNas> req, DialUpNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) {
        return (DialUpNasConnection)super.accounting(req, (Nas)nas, request, response, connectionSet, time);
    }

    public String executeCommand(String command, String params) {
        String result = null;
        if (command.equals("ps")) {
            result = this.getConnectionList(params);
        } else if (command.equals("kill")) {
            result = this.killConnections(params);
        } else if (command.equals("drop")) {
            result = this.dropConnections(params);
        } else if (command.equals("banlist")) {
            StringBuilder sb = new StringBuilder();
            Antispam antispam = Antispam.getAntispam();
            if (antispam != null) {
                for (String key : antispam.getBanList()) {
                    if (sb.length() != 0) {
                        sb.append("\n");
                    }
                    sb.append(key);
                }
            }
            result = sb.toString();
        } else if (command.startsWith("set_levels")) {
            LevelManager.updateLevels(command, true);
            result = "Levels updated";
        }
        return result;
    }

    public String getStatus() {
        List conList = this.getConnectionList();
        int countActive = 0;
        int countSuspend = 0;
        int countWait = 0;
        for (DialUpNasConnection con : conList) {
            switch (con.getStatus()) {
                case working: {
                    ++countActive;
                    break;
                }
                case suspended: {
                    ++countSuspend;
                    break;
                }
                case waiting: {
                    ++countWait;
                }
            }
        }
        VersionInfo vi = VersionInfo.getVersionInfo((String)"dialup");
        StringBuilder report = new StringBuilder();
        report.append("version ");
        report.append(vi.getVersionString());
        report.append("\n");
        report.append(TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy HH:mm:ss"));
        report.append("\t" + conList.size());
        report.append("\t" + countActive);
        report.append("\t" + countSuspend);
        report.append("\t" + countWait);
        report.append("\nRequest accounts per minute start: ");
        report.append(this.accountingStartCounter.getCount());
        report.append("; stop: ");
        report.append(this.accountingStopCounter.getCount());
        report.append("; update: ");
        report.append(this.accountingUpdateCounter.getCount());
        report.append("\nRequest auths per minute accept: ");
        report.append(this.authenticationAcceptCounter.getCount());
        report.append("; reject: ");
        report.append(this.authenticationRejectCounter.getCount());
        report.append("\nNetfow packets per minute: ");
        int packets = 0;
        for (DialUpFlowListener l : this.flowListenerList) {
            packets += l.getPacketCountMinute();
        }
        report.append(packets);
        report.append("\nIgnore per minute auth: ");
        report.append(this.authenticationIgnoreCount.getCount());
        report.append("; update: ");
        report.append(this.accountingUpdateIgnoreCount.getCount());
        report.append("\nAntispam ban count: ");
        report.append(Antispam.getAntispam().getBanCount());
        report.append("; used per minute: ");
        report.append(this.antispamIgnoreCount.getCount());
        report.append('\n');
        for (DialUpFlowListener l : this.flowListenerList) {
            report.append("FlowListener: ");
            report.append(l.toString());
            report.append("\n");
        }
        this.addCommonStatusData(report);
        return report.toString();
    }

    private String killConnections(String params) {
        List<ConnectionInfo> conList = this.getConnectionsByMask(params);
        for (int i = 0; i < conList.size(); ++i) {
            ConnectionInfo ci = conList.get(i);
            ci.nasCon.kill(ci.nasInfo);
        }
        return "OK Killed " + conList.size() + " connections.";
    }

    private String dropConnections(String params) {
        List<ConnectionInfo> conList = this.getConnectionsByMask(params);
        for (ConnectionInfo ci : conList) {
            ci.nasInfo.dropConnection(((DialUpSessionRealtime)ci.nasCon.getSession()).getNasPort());
        }
        return "OK Droped " + conList.size() + " connections.";
    }

    private String getConnectionList(String params) {
        String[] columns = new String[]{"NAS_ID", "NAS_IP", "Session", "Start", "Login", "IP", "FromNum", "Contract", "Status"};
        int[] widths = new int[]{15, 15, 30, 20, 10, 15, 20, 15, 10};
        ConsoleTable table = new ConsoleTable(columns, widths);
        List<ConnectionInfo> data = this.getConnectionsByMask(params);
        for (int i = 0; i < data.size(); ++i) {
            String[] row = new String[9];
            ConnectionInfo ci = data.get(i);
            row[0] = ci.nasIdentifier;
            row[1] = ci.nasIPAddr;
            row[2] = ci.session;
            row[3] = ci.start;
            row[4] = ci.login;
            row[5] = IPUtils.convertLongIpToString((long)ci.ipAddr);
            row[6] = ci.fromNum;
            row[7] = ci.contract;
            row[8] = ci.status;
            table.addRow(row);
        }
        StringBuffer result = new StringBuffer(table.toString());
        return result.toString();
    }

    private List<ConnectionInfo> getConnectionsByMask(String mask) {
        List<ConnectionInfo> conList = this.getConnectionsInfoList();
        StringTokenizer st1 = new StringTokenizer(mask, "-");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), " ");
            if (st2.countTokens() != 2) continue;
            String param = st2.nextToken();
            String values = st2.nextToken();
            this.truncConnectionsList(conList, param, values);
        }
        return conList;
    }

    private List<ConnectionInfo> getConnectionsInfoList() {
        ArrayList<ConnectionInfo> result = new ArrayList<ConnectionInfo>();
        for (DialUpNas nas : this.nasList.nases()) {
            for (DialUpNasConnection con : nas.connections()) {
                DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                ConnectionInfo ci = new ConnectionInfo();
                ci.id = String.valueOf(session.getLogRecordId());
                ci.nasInfo = nas;
                ci.nasCon = con;
                ci.nasIdentifier = nas.getNasIdentifier();
                ci.nasIPAddr = nas.getNasIPAddress().getHostAddress();
                ci.start = TimeUtils.format((Calendar)session.getStartTime(), (String)"dd.MM.yyyy HH:mm:ss");
                ci.fromNum = session.getFromNumber();
                ci.login = session.getLoginName();
                ci.contract = session.getContract().getTitle();
                ci.status = con.getStatus().name();
                ci.session = session.getAcctSessionId();
                ci.ipAddr = session.getIpAddress();
                result.add(ci);
            }
        }
        return result;
    }

    private void truncConnectionsList(List<ConnectionInfo> list, String param, String values) {
        if (param != null && values != null) {
            param = param.trim();
            HashSet valuesVect = new HashSet(Utils.toList((String)values));
            HashSet<ConnectionInfo> forRemove = new HashSet<ConnectionInfo>();
            for (ConnectionInfo ci : list) {
                if (!(param.equals("nas") && !valuesVect.contains(ci.nasIdentifier) && !valuesVect.contains(ci.nasIPAddr) || param.equals("login") && !valuesVect.contains(ci.login)) && (!param.equals("id") || valuesVect.contains(ci.id))) continue;
                forRemove.add(ci);
            }
            list.removeAll(forRemove);
        }
    }

    static class DialupNasList
    extends NasList<DialUpNasConnection, DialUpNas> {
        DialupNasList() {
        }

        protected DialUpNas newNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<DialUpNasConnection, DialUpNas, ?> processor, int id, DialUpNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, DialUpNasConnection> connections, String script, NasConnectionInspector inspector, Object ... params) {
            return new DialUpNas((Setup)setup, moduleId, (DialUpRadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
        }
    }

    public static interface ConnectionIterator
    extends RadiusProcessor.ConnectionIterator<DialUpNasConnection, DialUpNas> {
    }
}

