/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class IpAddressSet {
    private final ConcurrentMap<Long, Object> m;
    private final Set<Long> s;
    private final long timeout;
    final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2);

    public IpAddressSet() {
        this.m = new ConcurrentHashMap<Long, Object>();
        this.s = this.m.keySet();
        RadiusSetup setup = RadiusSetup.getSetup();
        this.timeout = setup != null ? setup.getLong("ip.free.timeout", 0L) : 0L;
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    public Set<Long> keySet() {
        return this.s;
    }

    public boolean removeWithTimeout(final Long e, final DialUpSessionRealtime value) {
        if (this.timeout <= 0L) {
            return this.remove0(e, value);
        }
        this.scheduledExecutorService.schedule(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return IpAddressSet.this.remove0(e, value);
            }
        }, this.timeout, TimeUnit.SECONDS);
        return true;
    }

    public boolean removeAddress(Long e) {
        return this.m.remove(e) != null;
    }

    public boolean remove(Long e, DialUpSessionRealtime value) {
        return this.remove0(e, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean remove0(Long e, DialUpSessionRealtime value) {
        block0: while (true) {
            Object o;
            if ((o = this.m.get(e)) == null) {
                return false;
            }
            if (o instanceof WeakReference) {
                WeakReference oldValue = (WeakReference)o;
                if (oldValue.get() != value) {
                    return false;
                }
                if (!this.m.remove(e, o)) continue;
                return true;
            }
            WeakReference[] array = (WeakReference[])o;
            int size = array.length;
            for (int i = 0; i < size; ++i) {
                if (value != array[i].get()) continue;
                if (size == 2) {
                    if (!this.m.replace(e, array, array[1 - i])) continue block0;
                    return true;
                }
                WeakReference[] newArray = new WeakReference[array.length - 1];
                System.arraycopy(array, 0, newArray, 0, i);
                System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
                if (this.m.replace(e, array, newArray)) return true;
                continue block0;
            }
            break;
        }
        return false;
    }

    public boolean add(Long e, DialUpSessionRealtime session) {
        while (true) {
            WeakReference[] newArray;
            WeakReference<DialUpSessionRealtime> value;
            WeakReference<DialUpSessionRealtime> o;
            if ((o = this.m.putIfAbsent(e, value = new WeakReference<DialUpSessionRealtime>(session))) == null) {
                return true;
            }
            if (o instanceof WeakReference) {
                WeakReference<DialUpSessionRealtime> oldValue = o;
                if (oldValue.get() == session) {
                    return false;
                }
                newArray = new WeakReference[]{oldValue, value};
                if (!this.m.replace(e, o, newArray)) continue;
                return false;
            }
            WeakReference[] array = (WeakReference[])o;
            for (int i = 0; i < array.length; ++i) {
                if (array[i].get() != session) continue;
                return false;
            }
            newArray = new WeakReference[array.length + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = value;
            if (this.m.replace(e, array, newArray)) break;
        }
        return true;
    }

    public Long tryOffer(List<Long> list, DialUpSessionRealtime session) {
        if (list == null || list.size() == 0) {
            return null;
        }
        WeakReference<DialUpSessionRealtime> value = new WeakReference<DialUpSessionRealtime>(session);
        if (list instanceof RandomAccess) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Long ip = list.get(i);
                if (this.m.containsKey(ip) || this.m.putIfAbsent(ip, value) != null) continue;
                return ip;
            }
        } else {
            for (Long ip : list) {
                if (this.m.containsKey(ip) || this.m.putIfAbsent(ip, value) != null) continue;
                return ip;
            }
        }
        return null;
    }

    public boolean tryOffer(Long ip, WeakReference<DialUpSessionRealtime> value) {
        return this.m.putIfAbsent(ip, value) == null;
    }

    public static void main(String[] args) {
        IpAddressSet set = new IpAddressSet();
        DialUpSessionRealtime s1 = new DialUpSessionRealtime(true, false);
        set.add(1L, s1);
        DialUpSessionRealtime s2 = new DialUpSessionRealtime(true, false);
        set.add(1L, s2);
        set.add(2L, new DialUpSessionRealtime(true, false));
        set.add(2L, new DialUpSessionRealtime(true, false));
        set.remove(2L, new DialUpSessionRealtime(true, false));
        set.remove(2L, s1);
        set.remove(1L, s1);
        set.remove(1L, s2);
    }
}

