/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.IpNet;
import ru.bitel.common.util.RangeSet;
import ru.bitel.common.util.Ranger;

public class TrafficInspector {
    private static final Ranger<RouteNet, Long> routeNetRanger = new Ranger<RouteNet, Long>(){

        public Long getMinValue(RouteNet r) {
            return r.fromAddr;
        }

        public Long getMaxValue(RouteNet r) {
            return r.toAddr;
        }
    };
    private static final Comparator<Long> routeNetComparator = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return o1.compareTo(o2);
        }
    };
    private final ConcurrentMap<Long, DialUpSessionRealtime> sessions;
    private final RangeAddressSet nets;

    public TrafficInspector(TrafficInspector old) {
        if (old != null) {
            this.sessions = old.sessions;
            this.nets = old.nets;
        } else {
            this.sessions = new ConcurrentHashMap<Long, DialUpSessionRealtime>(256);
            this.nets = new RangeAddressSet();
        }
    }

    public TrafficInspector() {
        this.sessions = new ConcurrentHashMap<Long, DialUpSessionRealtime>(256);
        this.nets = new RangeAddressSet();
    }

    public DialUpSessionRealtime getSession(long ip) {
        RouteNet net;
        DialUpSessionRealtime result = (DialUpSessionRealtime)((Object)this.sessions.get(ip));
        if (result == null && (net = (RouteNet)this.nets.search(ip)) != null) {
            return net.session;
        }
        return result;
    }

    private Set<RouteNet> getRouteNets(DialUpSessionRealtime session) {
        Set<IpNet> nets = session.getIpNetSet();
        if (nets.size() > 0) {
            HashSet<RouteNet> result = new HashSet<RouteNet>(2);
            for (IpNet net : session.getIpNetSet()) {
                long[] range = IPUtils.netMaskToRange((long)net.net, (long)net.mask);
                result.add(new RouteNet(range[0], range[1], session));
            }
            return result;
        }
        return Collections.emptySet();
    }

    public void startSession(DialUpSessionRealtime session, boolean sendRequest) {
        session.addLogInfo("IP address register on collector");
        this.sessions.put(session.getIpAddress(), session);
        this.nets.addAll(this.getRouteNets(session));
    }

    public void stopSession(DialUpSessionRealtime session) {
        if (this.sessions.remove(session.getIpAddress(), (Object)session)) {
            this.nets.removeAll(this.getRouteNets(session));
            session.addLogInfo("IP address unregistred from collector");
        }
    }

    static class RangeAddressSet
    extends RangeSet<Long, RouteNet> {
        public RangeAddressSet() {
            super(routeNetRanger, routeNetComparator, RouteNet.class, Long.class);
        }
    }

    static class RouteNet {
        final Long fromAddr;
        final Long toAddr;
        final DialUpSessionRealtime session;

        RouteNet(Long fromAddr, Long toAddr, DialUpSessionRealtime session) {
            this.fromAddr = fromAddr;
            this.toAddr = toAddr;
            this.session = session;
        }

        public int hashCode() {
            return 31 * (31 + this.fromAddr.hashCode()) + this.toAddr.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            RouteNet other = (RouteNet)obj;
            return this.fromAddr.equals(other.fromAddr);
        }
    }
}

